/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.util.cert;

import com.koalii.util.encoders.Base64;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.RSAPublicKey;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.util.PublicKeyFactory;

public class X509Cert {
    private Certificate x509 = null;

    public X509Cert(byte[] cert) throws IOException {
        ASN1InputStream asn1Is = new ASN1InputStream(cert);
        ASN1Primitive ans1Obj = asn1Is.readObject();
        this.x509 = Certificate.getInstance((Object)ans1Obj);
        asn1Is.close();
    }

    public X509Cert(String b64Cert) throws IOException {
        this(Base64.decode(b64Cert));
    }

    public SubjectPublicKeyInfo getSubjectPubKeyInfo() {
        return this.x509.getSubjectPublicKeyInfo();
    }

    public int getPubKeyByteSize() throws NoSuchAlgorithmException, IOException {
        int byteSize = 0;
        SubjectPublicKeyInfo pubKeyInfo = null;
        pubKeyInfo = this.x509.getSubjectPublicKeyInfo();
        if (this.getCertType().equalsIgnoreCase("SM2")) {
            ECPublicKeyParameters ecPubKey = (ECPublicKeyParameters)PublicKeyFactory.createKey((SubjectPublicKeyInfo)pubKeyInfo);
            byteSize = (ecPubKey.getParameters().getCurve().getFieldSize() + 7) / 8;
        } else if (this.getCertType().equalsIgnoreCase("RSA")) {
            RSAPublicKey rsaPubKey = RSAPublicKey.getInstance((Object)pubKeyInfo.getPublicKeyData());
            byteSize = (rsaPubKey.getModulus().bitLength() + 7) / 8;
        }
        return byteSize;
    }

    public String getCertType() throws NoSuchAlgorithmException {
        String certType = null;
        AlgorithmIdentifier algId = this.x509.getSubjectPublicKeyInfo().getAlgorithm();
        if (algId.getAlgorithm().equals((Object)GMObjectIdentifiers.sm2p256v1) || algId.getAlgorithm().equals((Object)X9ObjectIdentifiers.id_ecPublicKey)) {
            certType = "SM2";
        } else if (algId.getAlgorithm().equals((Object)PKCSObjectIdentifiers.rsaEncryption)) {
            certType = "RSA";
        } else {
            throw new NoSuchAlgorithmException("unknown algorithm id " + algId);
        }
        return certType;
    }
}

