/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.util.log;

import com.koalii.util.log.CustomFormatter;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogUtil {
    private static Logger m_file_logger = null;
    private static int m_file_limit = 102400;
    private static int m_file_rotate = 10;

    public static synchronized void init(String filePath) {
        LogUtil.init(filePath, m_file_limit, m_file_rotate);
    }

    public static synchronized void init(String filePath, int nMaxSizeKb, int nrotate) {
        FileHandler fh;
        LogUtil.clean();
        if (filePath == null || filePath.length() == 0) {
            return;
        }
        m_file_logger = Logger.getLogger(LogUtil.class.getName());
        m_file_logger.setLevel(Level.INFO);
        int nsize = m_file_limit * 1024;
        if (nMaxSizeKb > 0) {
            nsize = nMaxSizeKb * 1024;
        }
        int nr = m_file_rotate;
        if (nrotate > 0) {
            nr = nrotate;
        }
        try {
            fh = new FileHandler(filePath, nsize, nr, true);
            fh.setEncoding("UTF-8");
        }
        catch (Exception e) {
            return;
        }
        fh.setFormatter(new CustomFormatter());
        m_file_logger.setUseParentHandlers(false);
        m_file_logger.addHandler(fh);
    }

    public static synchronized void clean() {
        if (m_file_logger != null) {
            Handler[] hs;
            Handler[] handlerArray = hs = m_file_logger.getHandlers();
            int n = hs.length;
            int n2 = 0;
            while (n2 < n) {
                Handler h = handlerArray[n2];
                h.close();
                m_file_logger.removeHandler(h);
                ++n2;
            }
            m_file_logger = null;
        }
    }

    public static void info(String msg) {
        if (m_file_logger != null) {
            m_file_logger.log(Level.INFO, msg);
        }
    }

    public static void warn(String msg) {
        if (m_file_logger != null) {
            m_file_logger.log(Level.WARNING, msg);
        }
    }

    public static void error(String msg) {
        if (m_file_logger != null) {
            m_file_logger.log(Level.SEVERE, msg);
        }
    }

    public static void debug(String msg) {
        if (m_file_logger != null) {
            m_file_logger.log(Level.FINE, msg);
        }
    }

    public static synchronized Logger getFileLogger() {
        return m_file_logger;
    }

    public static void main(String[] args) {
        LogUtil.init("d:/svsc.log");
        int i = 0;
        while (i < 10) {
            LogUtil.info("\u6211\u88ab\u8bb0\u5f55\u4e86\u5417?");
            ++i;
        }
    }
}

