/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.util.pdf;

import com.itextpdf.text.pdf.codec.Base64;
import com.itextpdf.text.pdf.security.ExternalSignature;
import com.koalii.svs.client.Svs2ClientHelper;
import java.io.ByteArrayInputStream;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public class SvsSignature
implements ExternalSignature {
    private Svs2ClientHelper m_helper = null;
    String certId;
    private String hashAlgorithm = "SHA-1";
    private String encryptionAlgorithm = "RSA";

    public SvsSignature(Svs2ClientHelper svsHelper, String certId) {
        this.m_helper = svsHelper;
        this.certId = certId;
    }

    public SvsSignature(Svs2ClientHelper svsHelper, String certId, String hashAlgorithm) {
        this(svsHelper, certId);
        this.hashAlgorithm = hashAlgorithm;
    }

    public SvsSignature(Svs2ClientHelper svsHelper, String certId, String hashAlgorithm, String encryptionAlgorithm) {
        this(svsHelper, certId, hashAlgorithm);
        this.encryptionAlgorithm = encryptionAlgorithm;
    }

    public String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public Certificate getSignCert() throws CertificateException {
        X509Certificate x509Cert = null;
        if (this.m_helper == null) {
            return null;
        }
        Svs2ClientHelper.SvsResultData svsResultData = this.m_helper.cdbGetSignCert(this.certId);
        if (svsResultData == null || svsResultData.m_errno != 0) {
            throw new CertificateException("get signCert from svs with errCode " + svsResultData.m_errno);
        }
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        x509Cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(Base64.decode((String)svsResultData.m_b64SignedCert)));
        return x509Cert;
    }

    private int digestAlgorithmSwitch() {
        if (this.hashAlgorithm.equals("SHA-256") || this.hashAlgorithm.equals("SHA256")) {
            return 3;
        }
        if (this.hashAlgorithm.equals("MD-5") || this.hashAlgorithm.equals("MD5")) {
            return 1;
        }
        return 2;
    }

    public byte[] sign(byte[] originData) throws GeneralSecurityException {
        int hashAlg = this.digestAlgorithmSwitch();
        Svs2ClientHelper.SvsResultData m_result = this.m_helper.cdbSignData(originData, hashAlg, this.certId);
        if (m_result.m_errno != 0) {
            throw new GeneralSecurityException("svs detach sign failed " + m_result.m_errno);
        }
        return Base64.decode((String)m_result.m_b64SignedData);
    }
}

