/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.util.pkcs7;

import com.koalii.asn1.ASN1EncodableVector;
import com.koalii.asn1.ASN1InputStream;
import com.koalii.asn1.DERInteger;
import com.koalii.asn1.DEROctetString;
import com.koalii.asn1.DERSequence;
import com.koalii.asn1.DERSet;
import com.koalii.asn1.cms.CMSObjectIdentifiers;
import com.koalii.asn1.cms.ContentInfo;
import com.koalii.asn1.cms.EncryptedContentInfo;
import com.koalii.asn1.cms.EnvelopedData;
import com.koalii.asn1.cms.IssuerAndSerialNumber;
import com.koalii.asn1.cms.KeyTransRecipientInfo;
import com.koalii.asn1.cms.RecipientIdentifier;
import com.koalii.asn1.cms.RecipientInfo;
import com.koalii.asn1.x509.AlgorithmIdentifier;
import com.koalii.asn1.x509.X509Name;
import com.koalii.asn1.x509.X509NameTokenizer;
import com.koalii.cert.SecretStore;
import com.koalii.crypto.DESUtil;
import com.koalii.crypto.RSAUtil;
import com.koalii.crypto.engines.DESedeEngine;
import com.koalii.crypto.modes.CBCBlockCipher;
import com.koalii.crypto.paddings.PaddedBufferedBlockCipher;
import com.koalii.crypto.params.KeyParameter;
import com.koalii.util.encoders.Base64;
import com.koalii.util.pkcs7.PKCS7Exception;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;

public class PKCS7EnvelopUtil {
    private SecretStore decryptStore;

    public PKCS7EnvelopUtil(SecretStore decrypt) {
        this.decryptStore = decrypt;
    }

    public PKCS7EnvelopUtil() {
    }

    public static X509Name toX509Name(String dirName) {
        X509NameTokenizer nTok = new X509NameTokenizer(dirName);
        boolean isCnFirst = true;
        if (nTok.hasMoreTokens()) {
            String token = nTok.nextToken();
            int index = token.indexOf(61);
            if (index == -1) {
                throw new IllegalArgumentException("badly formated directory string");
            }
            String name = token.substring(0, index);
            isCnFirst = name.equalsIgnoreCase("CN");
            return new X509Name(true, dirName);
        }
        throw new IllegalArgumentException("badly formated directory string");
    }

    public static byte[] createEnvelop(X509Certificate encryptcert, byte[] oridata) throws PKCS7Exception {
        if (encryptcert == null || oridata == null) {
            throw new IllegalArgumentException();
        }
        IssuerAndSerialNumber isn = new IssuerAndSerialNumber(PKCS7EnvelopUtil.toX509Name(encryptcert.getIssuerDN().getName()), encryptcert.getSerialNumber());
        byte[] key = DESUtil.generateKey(null);
        byte[] encryptkey = null;
        try {
            encryptkey = RSAUtil.pubKeyEncrypt(encryptcert.getPublicKey(), key);
        }
        catch (Exception exp) {
            throw new PKCS7Exception(exp);
        }
        KeyTransRecipientInfo recinfo = new KeyTransRecipientInfo(new RecipientIdentifier(isn), new AlgorithmIdentifier(CMSObjectIdentifiers.rsaEncryption), new DEROctetString(encryptkey));
        ASN1EncodableVector recinfos = new ASN1EncodableVector();
        recinfos.add(new RecipientInfo(recinfo));
        DESUtil.DESResulte encdata = null;
        try {
            encdata = DESUtil.encrypt((byte[])key, (byte[])oridata);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        EncryptedContentInfo enccont = new EncryptedContentInfo(CMSObjectIdentifiers.data, new AlgorithmIdentifier(CMSObjectIdentifiers.des_EDE3_CBC, new DEROctetString(encdata.m_ivp)), new DEROctetString(encdata.m_encrypt));
        EnvelopedData evpdata = new EnvelopedData(null, new DERSet(recinfos), enccont, null);
        ContentInfo p7 = new ContentInfo(CMSObjectIdentifiers.envelopedData, evpdata);
        return p7.getDEREncoded();
    }

    public static byte[] createEnvelop(X509Certificate encryptcert, byte[] oridata, byte[] encryptkey, byte[] key) throws PKCS7Exception {
        if (encryptcert == null || oridata == null) {
            throw new IllegalArgumentException();
        }
        IssuerAndSerialNumber isn = new IssuerAndSerialNumber(PKCS7EnvelopUtil.toX509Name(encryptcert.getIssuerDN().getName()), encryptcert.getSerialNumber());
        KeyTransRecipientInfo recinfo = new KeyTransRecipientInfo(new RecipientIdentifier(isn), new AlgorithmIdentifier(CMSObjectIdentifiers.rsaEncryption), new DEROctetString(encryptkey));
        ASN1EncodableVector recinfos = new ASN1EncodableVector();
        recinfos.add(new RecipientInfo(recinfo));
        DESUtil.DESResulte encdata = null;
        try {
            encdata = DESUtil.encrypt((byte[])key, (byte[])oridata);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        EncryptedContentInfo enccont = new EncryptedContentInfo(CMSObjectIdentifiers.data, new AlgorithmIdentifier(CMSObjectIdentifiers.des_EDE3_CBC, new DEROctetString(encdata.m_ivp)), new DEROctetString(encdata.m_encrypt));
        EnvelopedData evpdata = new EnvelopedData(null, new DERSet(recinfos), enccont, null);
        ContentInfo p7 = new ContentInfo(CMSObjectIdentifiers.envelopedData, evpdata);
        return p7.getDEREncoded();
    }

    public byte[] parseEnvelop(byte[] evpdata) throws PKCS7Exception {
        if (evpdata == null) {
            throw new IllegalArgumentException();
        }
        if (this.decryptStore == null) {
            throw new PKCS7Exception("not find decrypt store");
        }
        ContentInfo cinfo = null;
        try {
            cinfo = ContentInfo.getInstance(new ASN1InputStream(evpdata).readObject());
        }
        catch (Exception exp) {
            throw new PKCS7Exception(exp);
        }
        if (!cinfo.getContentType().equals(CMSObjectIdentifiers.envelopedData)) {
            throw new PKCS7Exception("illegal content type " + cinfo.getContentType().getId());
        }
        EnvelopedData edata = EnvelopedData.getInstance(cinfo.getContent());
        if (edata == null) {
            throw new PKCS7Exception("parse envelopedData error");
        }
        if (edata.getVersion().getValue().intValue() != 0) {
            throw new PKCS7Exception("unsupported envelopedData version " + edata.getVersion().getValue().intValue());
        }
        KeyTransRecipientInfo recinfo = KeyTransRecipientInfo.getInstance(edata.getRecipientInfos().getObjectAt(0));
        if (!recinfo.getKeyEncryptionAlgorithm().getObjectId().equals(CMSObjectIdentifiers.rsaEncryption)) {
            throw new PKCS7Exception("unsupported encrypt key alg " + recinfo.getKeyEncryptionAlgorithm().getObjectId());
        }
        byte[] encryptkey = recinfo.getEncryptedKey().getOctets();
        byte[] key = null;
        try {
            key = RSAUtil.privKeyDecrypt(this.decryptStore.getPrivKey(), encryptkey);
        }
        catch (Exception exp) {
            throw new PKCS7Exception(exp);
        }
        EncryptedContentInfo enccont = edata.getEncryptedContentInfo();
        if (!enccont.getContentEncryptionAlgorithm().getObjectId().equals(CMSObjectIdentifiers.des_EDE3_CBC)) {
            throw new PKCS7Exception("unsupported encrypt content alg " + enccont.getContentEncryptionAlgorithm().getObjectId());
        }
        byte[] oridata = null;
        try {
            oridata = DESUtil.decrypt(key, enccont.getEncryptedContent().getOctets());
        }
        catch (Exception exp) {
            throw new PKCS7Exception(exp);
        }
        return oridata;
    }

    public static byte[] parseEnvelop(SecretStore store, byte[] evpdata) throws PKCS7Exception {
        PKCS7EnvelopUtil envutil = new PKCS7EnvelopUtil(store);
        return envutil.parseEnvelop(evpdata);
    }

    public static X509Name getRecipientIssuerDN(byte[] evpdata) throws PKCS7Exception {
        return PKCS7EnvelopUtil.getIssuerDnAndSN(evpdata).getName();
    }

    public static BigInteger getRecipientSN(byte[] evpdata) throws PKCS7Exception {
        return PKCS7EnvelopUtil.getIssuerDnAndSN(evpdata).getSerialNumber().getPositiveValue();
    }

    protected static IssuerAndSerialNumber getIssuerDnAndSN(byte[] evpdata) throws PKCS7Exception {
        if (evpdata == null) {
            throw new IllegalArgumentException();
        }
        ContentInfo cinfo = null;
        try {
            cinfo = ContentInfo.getInstance(new ASN1InputStream(evpdata).readObject());
        }
        catch (Exception exp) {
            throw new PKCS7Exception(exp);
        }
        if (!cinfo.getContentType().equals(CMSObjectIdentifiers.envelopedData)) {
            throw new PKCS7Exception("illegal content type " + cinfo.getContentType().getId());
        }
        EnvelopedData edata = EnvelopedData.getInstance(cinfo.getContent());
        if (edata == null) {
            throw new PKCS7Exception("parse envelopedData error");
        }
        if (edata.getVersion().getValue().intValue() != 0) {
            throw new PKCS7Exception("unsupported envelopedData version " + edata.getVersion().getValue().intValue());
        }
        KeyTransRecipientInfo recinfo = KeyTransRecipientInfo.getInstance(edata.getRecipientInfos().getObjectAt(0));
        IssuerAndSerialNumber ias = null;
        try {
            ias = IssuerAndSerialNumber.getInstance(new ASN1InputStream(recinfo.getRecipientIdentifier().getDEREncoded()).readObject());
        }
        catch (Exception exp) {
            throw new PKCS7Exception(exp);
        }
        return ias;
    }

    public static X509Certificate[] parseB64Cert(String b64Cert) {
        return PKCS7EnvelopUtil.parseDerCert(Base64.decode(b64Cert.getBytes()));
    }

    public static X509Certificate[] parseDerCert(byte[] derCert) {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> col = cf.generateCertificates(new ByteArrayInputStream(derCert));
            int clen = col.size();
            X509Certificate[] x509s = new X509Certificate[clen];
            col.toArray(x509s);
            return x509s;
        }
        catch (Exception exp) {
            throw new IllegalArgumentException("parse der cert  - " + exp);
        }
    }

    public EnvelopResult parseEnvelopKey(byte[] evpdata) throws PKCS7Exception {
        EnvelopResult result = new EnvelopResult();
        if (evpdata == null) {
            throw new IllegalArgumentException();
        }
        ContentInfo cinfo = null;
        try {
            cinfo = ContentInfo.getInstance(new ASN1InputStream(evpdata).readObject());
        }
        catch (Exception exp) {
            throw new PKCS7Exception(exp);
        }
        if (!cinfo.getContentType().equals(CMSObjectIdentifiers.envelopedData)) {
            throw new PKCS7Exception("illegal content type " + cinfo.getContentType().getId());
        }
        EnvelopedData edata = EnvelopedData.getInstance(cinfo.getContent());
        if (edata == null) {
            throw new PKCS7Exception("parse envelopedData error");
        }
        if (edata.getVersion().getValue().intValue() != 0) {
            throw new PKCS7Exception("unsupported envelopedData version " + edata.getVersion().getValue().intValue());
        }
        DERSequence reci = (DERSequence)edata.getRecipientInfos().getObjectAt(0).getDERObject();
        DERSequence certinfo = (DERSequence)reci.getObjectAt(1);
        DERInteger certsn = (DERInteger)certinfo.getObjectAt(1);
        result.cert_sn = this.printHexString(certsn.getPositiveValue().toByteArray());
        KeyTransRecipientInfo recinfo = KeyTransRecipientInfo.getInstance(edata.getRecipientInfos().getObjectAt(0));
        if (!recinfo.getKeyEncryptionAlgorithm().getObjectId().equals(CMSObjectIdentifiers.rsaEncryption)) {
            throw new PKCS7Exception("unsupported encrypt key alg " + recinfo.getKeyEncryptionAlgorithm().getObjectId());
        }
        byte[] encryptkey = recinfo.getEncryptedKey().getOctets();
        result.envelop_key = encryptkey;
        EncryptedContentInfo enccont = edata.getEncryptedContentInfo();
        if (!enccont.getContentEncryptionAlgorithm().getObjectId().equals(CMSObjectIdentifiers.des_EDE3_CBC)) {
            throw new PKCS7Exception("unsupported encrypt content alg " + enccont.getContentEncryptionAlgorithm().getObjectId());
        }
        DEROctetString ivparameters = (DEROctetString)enccont.getContentEncryptionAlgorithm().getParameters();
        byte[] ivparam = ivparameters.getOctets();
        result.envelop_content = enccont.getEncryptedContent().getOctets();
        result.envelop_ivparam = ivparam;
        return result;
    }

    public String printHexString(byte[] b) {
        String ret = "";
        int i = 0;
        while (i < b.length) {
            String hex = Integer.toHexString(b[i] & 0xFF);
            if (hex.length() == 1) {
                hex = String.valueOf('0') + hex;
            }
            ret = String.valueOf(ret) + hex.toUpperCase();
            ++i;
        }
        return ret;
    }

    public static byte[] parseEnvelopData(byte[] deskey, byte[] enccont, byte[] ivparam) throws PKCS7Exception {
        byte[] oridata = null;
        try {
            oridata = DESUtil.decrypt((byte[])deskey, (byte[])enccont, (byte[])ivparam);
        }
        catch (Exception exp) {
            throw new PKCS7Exception(exp);
        }
        return oridata;
    }

    public static byte[] decrypt(byte[] key, byte[] secretdata, byte[] ivparam) throws Exception {
        if (key == null || secretdata == null) {
            throw new IllegalArgumentException();
        }
        PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(new DESedeEngine()));
        cipher.init(false, new KeyParameter(key));
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] outblock = new byte[cipher.getOutputSize(secretdata.length)];
        int outlen = cipher.processBytes(secretdata, 0, secretdata.length, outblock, 0);
        if (outlen > 0) {
            bout.write(outblock, 0, outlen);
        }
        if ((outlen = cipher.doFinal(outblock, 0)) > 0) {
            bout.write(outblock, 0, outlen);
        }
        byte[] oridata = bout.toByteArray();
        byte[] head = new byte[8];
        int i = 0;
        while (i < ivparam.length) {
            head[i] = (byte)(ivparam[i] ^ oridata[i]);
            ++i;
        }
        System.arraycopy(head, 0, oridata, 0, head.length);
        return oridata;
    }

    public class EnvelopResult {
        public byte[] envelop_key = null;
        public String cert_sn = null;
        public byte[] envelop_content = null;
        public byte[] envelop_ivparam = null;
    }
}

