/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.util.pkcs7;

import com.itextpdf.text.error_messages.MessageLocalization;
import com.koalii.asn1.ASN1EncodableVector;
import com.koalii.asn1.ASN1InputStream;
import com.koalii.asn1.ASN1OctetString;
import com.koalii.asn1.ASN1Set;
import com.koalii.asn1.DERObjectIdentifier;
import com.koalii.asn1.DEROctetString;
import com.koalii.asn1.DERSet;
import com.koalii.asn1.cms.Attribute;
import com.koalii.asn1.cms.AttributeTable;
import com.koalii.asn1.cms.CMSObjectIdentifiers;
import com.koalii.asn1.cms.ContentInfo;
import com.koalii.asn1.cms.IssuerAndSerialNumber;
import com.koalii.asn1.cms.SignedData;
import com.koalii.asn1.cms.SignerIdentifier;
import com.koalii.asn1.cms.SignerInfo;
import com.koalii.asn1.nist.NISTObjectIdentifiers;
import com.koalii.asn1.oiw.OIWObjectIdentifiers;
import com.koalii.asn1.pkcs.PKCSObjectIdentifiers;
import com.koalii.asn1.x509.AlgorithmIdentifier;
import com.koalii.asn1.x509.X509CertificateStructure;
import com.koalii.cert.SecretStore;
import com.koalii.cert.X509CertParser;
import com.koalii.cert.X509NameUtil;
import com.koalii.crypto.SignUtil;
import com.koalii.util.pkcs7.PKCS7Exception;
import java.io.IOException;
import java.security.Principal;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;

public class PKCS7SignUtil {
    private SecretStore signerStore;

    public PKCS7SignUtil(SecretStore signer) {
        this.signerStore = signer;
    }

    public byte[] createSign(byte[] oriData) throws PKCS7Exception {
        if (oriData == null) {
            throw new IllegalArgumentException();
        }
        if (this.signerStore == null || this.signerStore.getCert() == null) {
            throw new PKCS7Exception("Not find signer store");
        }
        ASN1EncodableVector digestAlgorithms = new ASN1EncodableVector();
        digestAlgorithms.add(new AlgorithmIdentifier("1.3.14.3.2.26"));
        String digestEncryptionAlgorithm = this.signerStore.getAlgorithm();
        if (digestEncryptionAlgorithm.equals("RSA")) {
            digestEncryptionAlgorithm = "1.2.840.113549.1.1.1";
        } else if (digestEncryptionAlgorithm.equals("DSA")) {
            digestEncryptionAlgorithm = "1.2.840.10040.4.1";
        } else {
            throw new PKCS7Exception("Unknown Key Algorithm " + digestEncryptionAlgorithm);
        }
        ASN1EncodableVector certs = new ASN1EncodableVector();
        try {
            certs.add(new ASN1InputStream(this.signerStore.getCert().getEncoded()).readObject());
        }
        catch (IOException iOException) {
        }
        catch (CertificateEncodingException certificateEncodingException) {
            // empty catch block
        }
        byte[] signedData = null;
        try {
            signedData = this.signerStore.signData(oriData);
        }
        catch (Exception exp) {
            throw new PKCS7Exception(exp);
        }
        ContentInfo cinfo = new ContentInfo(CMSObjectIdentifiers.data, new DEROctetString(oriData));
        IssuerAndSerialNumber isn = new IssuerAndSerialNumber(X509NameUtil.toX509Name((Principal)this.signerStore.getCert().getIssuerDN()), this.signerStore.getCert().getSerialNumber());
        SignerInfo signer = new SignerInfo(new SignerIdentifier(isn), new AlgorithmIdentifier("1.3.14.3.2.26"), null, new AlgorithmIdentifier(digestEncryptionAlgorithm), new DEROctetString(signedData), null);
        ASN1EncodableVector signers = new ASN1EncodableVector();
        signers.add(signer);
        SignedData sdata = new SignedData(new DERSet(digestAlgorithms), cinfo, new DERSet(certs), null, new DERSet(signers));
        ContentInfo p7 = new ContentInfo(CMSObjectIdentifiers.signedData, sdata);
        return p7.getDEREncoded();
    }

    public static byte[] createSign(SecretStore signer, byte[] oriData) throws PKCS7Exception {
        PKCS7SignUtil p7util = new PKCS7SignUtil(signer);
        return p7util.createSign(oriData);
    }

    public byte[] createDetachSign(byte[] oriData) throws PKCS7Exception {
        if (oriData == null) {
            throw new IllegalArgumentException();
        }
        if (this.signerStore == null || this.signerStore.getCert() == null) {
            throw new PKCS7Exception("Not find signer store");
        }
        ASN1EncodableVector digestAlgorithms = new ASN1EncodableVector();
        digestAlgorithms.add(new AlgorithmIdentifier("1.3.14.3.2.26"));
        String digestEncryptionAlgorithm = this.signerStore.getAlgorithm();
        if (digestEncryptionAlgorithm.equals("RSA")) {
            digestEncryptionAlgorithm = "1.2.840.113549.1.1.1";
        } else if (digestEncryptionAlgorithm.equals("DSA")) {
            digestEncryptionAlgorithm = "1.2.840.10040.4.1";
        } else {
            throw new PKCS7Exception("Unknown Key Algorithm " + digestEncryptionAlgorithm);
        }
        ASN1EncodableVector certs = new ASN1EncodableVector();
        try {
            certs.add(new ASN1InputStream(this.signerStore.getCert().getEncoded()).readObject());
        }
        catch (IOException iOException) {
        }
        catch (CertificateEncodingException certificateEncodingException) {
            // empty catch block
        }
        byte[] signedData = null;
        try {
            signedData = this.signerStore.signData(oriData);
        }
        catch (Exception exp) {
            throw new PKCS7Exception(exp);
        }
        ContentInfo cinfo = new ContentInfo(CMSObjectIdentifiers.data, null);
        IssuerAndSerialNumber isn = new IssuerAndSerialNumber(X509NameUtil.toX509Name((Principal)this.signerStore.getCert().getIssuerDN()), this.signerStore.getCert().getSerialNumber());
        SignerInfo signer = new SignerInfo(new SignerIdentifier(isn), new AlgorithmIdentifier("1.3.14.3.2.26"), null, new AlgorithmIdentifier(digestEncryptionAlgorithm), new DEROctetString(signedData), null);
        ASN1EncodableVector signers = new ASN1EncodableVector();
        signers.add(signer);
        SignedData sdata = new SignedData(new DERSet(digestAlgorithms), cinfo, new DERSet(certs), null, new DERSet(signers));
        ContentInfo p7 = new ContentInfo(CMSObjectIdentifiers.signedData, sdata);
        return p7.getDEREncoded();
    }

    public static byte[] createDetachSign(SecretStore signer, byte[] oriData) throws PKCS7Exception {
        PKCS7SignUtil p7util = new PKCS7SignUtil(signer);
        return p7util.createDetachSign(oriData);
    }

    public static boolean verifySign(byte[] signdata, byte[] oridata) throws PKCS7Exception {
        if (signdata == null) {
            throw new IllegalArgumentException();
        }
        ContentInfo cinfo = null;
        try {
            cinfo = ContentInfo.getInstance(new ASN1InputStream(signdata).readObject());
        }
        catch (Exception exp) {
            throw new PKCS7Exception(exp);
        }
        if (!cinfo.getContentType().equals(CMSObjectIdentifiers.signedData)) {
            throw new PKCS7Exception("illegal content type " + cinfo.getContentType().getId());
        }
        SignedData sdata = SignedData.getInstance(cinfo.getContent());
        if (sdata == null) {
            throw new PKCS7Exception("parse signeddata error");
        }
        ContentInfo encapContent = sdata.getEncapContentInfo();
        if (!encapContent.getContentType().equals(CMSObjectIdentifiers.data)) {
            throw new PKCS7Exception("illegal encapture content type " + encapContent.getContentType().getId());
        }
        byte[] oriToSign = null;
        ASN1OctetString octets = ASN1OctetString.getInstance(encapContent.getContent());
        if (octets == null) {
            if (oridata == null) {
                throw new IllegalArgumentException("no oridata");
            }
            oriToSign = oridata;
        } else if (oridata != null) {
            oriToSign = octets.getOctets();
            if (oriToSign.length != oridata.length) {
                return false;
            }
            int i = 0;
            i = 0;
            while (i < oriToSign.length) {
                if (oriToSign[i] != oridata[i]) {
                    return false;
                }
                ++i;
            }
        } else {
            oriToSign = octets.getOctets();
        }
        SignerInfo signer = SignerInfo.getInstance(sdata.getSignerInfos().getObjectAt(0));
        if (sdata.getCertificates() == null || sdata.getCertificates().size() <= 0) {
            throw new PKCS7Exception("not find sign cert");
        }
        X509Certificate[] scerts = X509CertParser.parseDerCert(sdata.getCertificates().getObjectAt(0).getDERObject().getDEREncoded());
        try {
            return SignUtil.sha1WithRsaVerify(oriToSign, signer.getEncryptedDigest().getOctets(), scerts[0].getPublicKey());
        }
        catch (Exception exp) {
            throw new PKCS7Exception(exp);
        }
    }

    public static X509Certificate[] getSignCerts(byte[] signdata) throws PKCS7Exception {
        if (signdata == null) {
            throw new IllegalArgumentException();
        }
        ContentInfo cinfo = null;
        try {
            cinfo = ContentInfo.getInstance(new ASN1InputStream(signdata).readObject());
        }
        catch (Exception exp) {
            throw new PKCS7Exception(exp);
        }
        SignedData sdata = SignedData.getInstance(cinfo.getContent());
        if (sdata == null) {
            throw new PKCS7Exception("parse signeddata error");
        }
        return X509CertParser.parseDerCert(sdata.getCertificates().getObjectAt(0).getDERObject().getDEREncoded());
    }

    public static byte[] getOriData(byte[] signdata) throws PKCS7Exception {
        if (signdata == null) {
            throw new IllegalArgumentException();
        }
        ContentInfo cinfo = null;
        try {
            cinfo = ContentInfo.getInstance(new ASN1InputStream(signdata).readObject());
        }
        catch (Exception exp) {
            throw new PKCS7Exception(exp);
        }
        SignedData sdata = SignedData.getInstance(cinfo.getContent());
        if (sdata == null) {
            throw new PKCS7Exception("parse signeddata error");
        }
        ContentInfo encapContent = sdata.getEncapContentInfo();
        if (!encapContent.getContentType().equals(CMSObjectIdentifiers.data)) {
            throw new PKCS7Exception("illegal encapture content type " + encapContent.getContentType().getId());
        }
        ASN1OctetString octets = ASN1OctetString.getInstance(encapContent.getContent());
        return octets.getOctets();
    }

    public static SignerInfo getSignerInfo(byte[] signdata) throws PKCS7Exception {
        ContentInfo p7ContentInfo;
        if (signdata == null) {
            throw new IllegalArgumentException();
        }
        ASN1InputStream inputStream = new ASN1InputStream(signdata);
        try {
            p7ContentInfo = ContentInfo.getInstance(inputStream.readObject());
        }
        catch (IOException e) {
            throw new PKCS7Exception(e);
        }
        SignedData signedData = SignedData.getInstance(p7ContentInfo.getContent());
        if (signedData == null) {
            throw new PKCS7Exception("parse signeddata error");
        }
        if (signedData.getSignerInfos().size() != 1) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage((String)"this.pkcs.7.object.has.multiple.signerinfos.only.one.is.supported.at.this.time", (Object[])new Object[0]));
        }
        SignerInfo signerInfo = SignerInfo.getInstance(signedData.getSignerInfos().getObjectAt(0));
        return signerInfo;
    }

    public static byte[] getAuthenticatedAttrs(byte[] signdata) throws PKCS7Exception {
        SignerInfo signerInfo = PKCS7SignUtil.getSignerInfo(signdata);
        return PKCS7SignUtil.getAuthenticatedAttrs(signerInfo);
    }

    public static byte[] getAuthenticatedAttrs(SignerInfo signerInfo) throws PKCS7Exception {
        if (signerInfo == null) {
            throw new IllegalArgumentException("signerInfo null");
        }
        ASN1Set authenticatedAttrs = signerInfo.getAuthenticatedAttributes();
        if (authenticatedAttrs == null) {
            return null;
        }
        return authenticatedAttrs.getDEREncoded();
    }

    public static byte[] getMessageDigestAttrInAuthenticatedAttris(byte[] signdata) throws PKCS7Exception {
        SignerInfo signerInfo = PKCS7SignUtil.getSignerInfo(signdata);
        return PKCS7SignUtil.getMessageDigestAttrInAuthenticatedAttris(signerInfo);
    }

    public static byte[] getMessageDigestAttrInAuthenticatedAttris(SignerInfo signerInfo) throws PKCS7Exception {
        if (signerInfo == null) {
            throw new IllegalArgumentException("signerInfo null");
        }
        ASN1Set authenticatedAttrsSet = signerInfo.getAuthenticatedAttributes();
        if (authenticatedAttrsSet == null) {
            throw new PKCS7Exception("authenticatedAttributes not exist");
        }
        AttributeTable authenticatedAttrs = new AttributeTable(authenticatedAttrsSet);
        Attribute messageDigestAttr = authenticatedAttrs.get(new DERObjectIdentifier("1.2.840.113549.1.9.4"));
        if (messageDigestAttr == null) {
            throw new PKCS7Exception("messageDigest attribute no exist in authenticatedAttrbutes");
        }
        ASN1OctetString messageDigest = (ASN1OctetString)messageDigestAttr.getAttrValues().getObjectAt(0);
        return messageDigest.getOctets();
    }

    public static byte[] getEncryptedDigest(byte[] signdata) throws PKCS7Exception {
        SignerInfo signerInfo = PKCS7SignUtil.getSignerInfo(signdata);
        return PKCS7SignUtil.getEncryptedDigest(signerInfo);
    }

    public static byte[] getEncryptedDigest(SignerInfo signerInfo) throws PKCS7Exception {
        if (signerInfo == null) {
            throw new IllegalArgumentException("signerInfo null");
        }
        return signerInfo.getEncryptedDigest().getOctets();
    }

    public static String getSignerCertDN(byte[] signdata) throws PKCS7Exception {
        X509CertificateStructure certificateStructure;
        byte[] signerCert = PKCS7SignUtil.getSignerCertificate(signdata);
        if (signerCert == null) {
            return null;
        }
        try {
            certificateStructure = X509CertificateStructure.getInstance(new ASN1InputStream(signerCert).readObject());
        }
        catch (IOException e) {
            throw new PKCS7Exception(e);
        }
        return certificateStructure.getSubject().toString();
    }

    public static byte[] getSignerCertificate(byte[] signdata) throws PKCS7Exception {
        if (signdata == null) {
            throw new IllegalArgumentException();
        }
        ContentInfo cinfo = null;
        try {
            cinfo = ContentInfo.getInstance(new ASN1InputStream(signdata).readObject());
        }
        catch (Exception exp) {
            throw new PKCS7Exception(exp);
        }
        SignedData sdata = SignedData.getInstance(cinfo.getContent());
        if (sdata == null) {
            throw new PKCS7Exception("parse signeddata error");
        }
        Enumeration certs = sdata.getCertificates().getObjects();
        if (sdata.getSignerInfos().size() != 1) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage((String)"this.pkcs.7.object.has.multiple.signerinfos.only.one.is.supported.at.this.time", (Object[])new Object[0]));
        }
        SignerInfo signerInfo = SignerInfo.getInstance(sdata.getSignerInfos().getObjectAt(0).getDERObject());
        SignerIdentifier signerIdentifier = signerInfo.getSID();
        IssuerAndSerialNumber issuerAndSerialNumber = IssuerAndSerialNumber.getInstance(signerIdentifier.getDERObject());
        while (certs.hasMoreElements()) {
            X509CertificateStructure certificateStructure = X509CertificateStructure.getInstance(certs.nextElement());
            if (!certificateStructure.getIssuer().equals(issuerAndSerialNumber.getName()) || !certificateStructure.getSerialNumber().equals(issuerAndSerialNumber.getSerialNumber())) continue;
            return certificateStructure.getDEREncoded();
        }
        return null;
    }

    public static int getDigestAlgorithm(byte[] signdata) throws PKCS7Exception {
        SignerInfo signerInfo = PKCS7SignUtil.getSignerInfo(signdata);
        return PKCS7SignUtil.getDigestAlgorithm(signerInfo);
    }

    public static int getDigestAlgorithm(SignerInfo signerInfo) throws PKCS7Exception {
        int digestAlg = -1;
        if (signerInfo == null) {
            throw new IllegalArgumentException("signerInfo null");
        }
        AlgorithmIdentifier algorithmIdentifier = signerInfo.getDigestAlgorithm();
        DERObjectIdentifier algorithmID = algorithmIdentifier.getObjectId();
        if (algorithmID.equals(PKCSObjectIdentifiers.sha1WithRSAEncryption) || algorithmID.equals(OIWObjectIdentifiers.idSHA1)) {
            digestAlg = 2;
        } else if (algorithmID.equals(PKCSObjectIdentifiers.sha256WithRSAEncryption) || algorithmID.equals(NISTObjectIdentifiers.id_sha256)) {
            digestAlg = 3;
        } else if (algorithmID.equals(PKCSObjectIdentifiers.md5WithRSAEncryption)) {
            digestAlg = 1;
        }
        return digestAlg;
    }
}

