/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.util.symmetric;

import com.koalii.crypto.engines.AESEngine;
import com.koalii.crypto.paddings.PKCS5Padding;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;

public class AESUtil {
    public static byte[] generateKey() throws Exception {
        Random random = new Random();
        byte[] key = new byte[32];
        random.nextBytes(key);
        return key;
    }

    public static byte[] encrypt(byte[] data, byte[] key) throws Exception {
        byte[] paddingdata = PKCS5Padding.addPadding(data);
        byte[] redata = new byte[paddingdata.length];
        AESEngine aesengine = new AESEngine();
        aesengine.init(true, key);
        byte[] in_encrypt = new byte[16];
        byte[] out_encrypt = new byte[16];
        int i = 0;
        while (i < paddingdata.length) {
            System.arraycopy(paddingdata, i, in_encrypt, 0, in_encrypt.length);
            aesengine.processBlock(in_encrypt, 0, out_encrypt, 0);
            System.arraycopy(out_encrypt, 0, redata, i, out_encrypt.length);
            i += 16;
        }
        return redata;
    }

    public static byte[] encryptNOPadding(byte[] data, byte[] key) throws Exception {
        byte[] redata = new byte[data.length];
        AESEngine aesengine = new AESEngine();
        aesengine.init(true, key);
        byte[] in_encrypt = new byte[16];
        byte[] out_encrypt = new byte[16];
        int i = 0;
        while (i < data.length) {
            System.arraycopy(data, i, in_encrypt, 0, in_encrypt.length);
            aesengine.processBlock(in_encrypt, 0, out_encrypt, 0);
            System.arraycopy(out_encrypt, 0, redata, i, out_encrypt.length);
            i += 16;
        }
        return redata;
    }

    public static byte[] decrypt(byte[] data, byte[] key) throws Exception {
        byte[] redata = new byte[data.length];
        AESEngine aesengine = new AESEngine();
        aesengine.init(false, key);
        byte[] in_encrypt = new byte[16];
        byte[] out_encrypt = new byte[16];
        int i = 0;
        while (i < data.length) {
            System.arraycopy(data, i, in_encrypt, 0, in_encrypt.length);
            aesengine.processBlock(in_encrypt, 0, out_encrypt, 0);
            System.arraycopy(out_encrypt, 0, redata, i, out_encrypt.length);
            i += 16;
        }
        return PKCS5Padding.removePadding(redata);
    }

    public static byte[] decryptNOPadding(byte[] data, byte[] key) throws Exception {
        byte[] redata = new byte[data.length];
        AESEngine aesengine = new AESEngine();
        aesengine.init(false, key);
        byte[] in_encrypt = new byte[16];
        byte[] out_encrypt = new byte[16];
        int i = 0;
        while (i < data.length) {
            System.arraycopy(data, i, in_encrypt, 0, in_encrypt.length);
            aesengine.processBlock(in_encrypt, 0, out_encrypt, 0);
            System.arraycopy(out_encrypt, 0, redata, i, out_encrypt.length);
            i += 16;
        }
        return redata;
    }

    public static void encrypt(String inpath, String outpath, byte[] key) throws Exception {
        FileInputStream in = null;
        OutputStream out = null;
        try {
            try {
                in = new FileInputStream(inpath);
                out = new FileOutputStream(outpath);
                int blockSize = 8192;
                int outputSize = 8192;
                byte[] inBytes = new byte[blockSize];
                byte[] outBytes = new byte[outputSize];
                byte[] lastBytes = null;
                int inLength = 0;
                boolean more = true;
                while (more) {
                    inLength = ((InputStream)in).read(inBytes);
                    if (inLength == blockSize) {
                        outBytes = AESUtil.encryptNOPadding(inBytes, key);
                        out.write(outBytes, 0, outBytes.length);
                        continue;
                    }
                    if (inLength > 0) {
                        lastBytes = new byte[inLength];
                        System.arraycopy(inBytes, 0, lastBytes, 0, inLength);
                    } else {
                        lastBytes = new byte[]{};
                    }
                    more = false;
                }
                outBytes = AESUtil.encryptNOPadding(PKCS5Padding.addPadding(lastBytes), key);
                out.write(outBytes, 0, outBytes.length);
                out.flush();
            }
            catch (Exception e) {
                throw new Exception(e);
            }
        }
        finally {
            out.close();
            ((InputStream)in).close();
        }
    }

    public static void decrypt(String inpath, String outpath, byte[] key) throws Exception {
        FileInputStream in = null;
        OutputStream out = null;
        try {
            try {
                in = new FileInputStream(inpath);
                out = new FileOutputStream(outpath);
                int blockSize = 8192;
                int outputSize = 8192;
                byte[] inBytes = new byte[blockSize];
                byte[] outBytes = new byte[outputSize];
                int inLength = 0;
                boolean more = true;
                boolean first = true;
                while (more) {
                    inLength = ((InputStream)in).read(inBytes);
                    if (inLength > 0) {
                        if (!first) {
                            outBytes = AESUtil.decryptNOPadding(outBytes, key);
                            out.write(outBytes, 0, outBytes.length);
                        }
                        if (inLength != outBytes.length) {
                            outBytes = new byte[inLength];
                        }
                        System.arraycopy(inBytes, 0, outBytes, 0, inLength);
                    } else {
                        outBytes = AESUtil.decryptNOPadding(outBytes, key);
                        outBytes = PKCS5Padding.removePadding(outBytes);
                        out.write(outBytes, 0, outBytes.length);
                        more = false;
                    }
                    first = false;
                }
                out.flush();
            }
            catch (Exception e) {
                throw new Exception(e);
            }
        }
        finally {
            out.close();
            ((InputStream)in).close();
        }
    }
}

