/*
 * Decompiled with CFR 0.152.
 */
package test.com.koalii.svs;

import com.koalii.svs.client.Svs2ClientException;
import com.koalii.svs.client.Svs2ClientHelper;
import com.koalii.util.cert.X509Cert;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.MessageDigest;
import test.com.koalii.svs.TestObject;

public class CdbPkcs7DetachSignByDigest
extends TestObject {
    private InputStream is = null;

    @Override
    public int done() throws Exception {
        Svs2ClientHelper helper = Svs2ClientHelper.getInstance();
        Svs2ClientHelper.SvsResultData result = helper.cdbGetSignCert(this.m_certId);
        String b64CertData = result.m_b64Cert;
        MessageDigest messageDigest = null;
        X509Cert cert = new X509Cert(b64CertData);
        if (cert.getCertType().equalsIgnoreCase("SM2")) {
            this.m_digestAlg = 6;
        } else {
            this.inputAlg();
        }
        try {
            messageDigest = Svs2ClientHelper.createDigest(this.m_digestAlg, b64CertData);
        }
        catch (Svs2ClientException e) {
            System.out.println(String.valueOf(e.getErrorNo()) + " " + e.getMessage());
            return e.getErrorNo();
        }
        byte[] b = new byte[4096];
        int nr = 0;
        while ((nr = this.is.read(b)) != -1) {
            messageDigest.update(b, 0, nr);
        }
        byte[] digest = messageDigest.digest();
        this.m_result = helper.cdbPkcs7DetachSignByDigest(digest, this.m_certId, this.m_digestAlg);
        return result.m_errno;
    }

    @Override
    public void input() throws Exception {
        this.m_certId = this.selectSignCert();
        this.is = this.inputOriStream();
        this.inputOutpathForSignOrEvpData();
    }

    @Override
    public void output() throws Exception {
        this.outputResult();
        if (this.is != null) {
            this.is.close();
        }
    }

    public static void main(String[] args) throws Exception {
        String host = "192.168.83.145";
        int port = 5000;
        int timeoutSec = 2;
        Svs2ClientHelper helper = Svs2ClientHelper.getInstance();
        helper.init(host, port, timeoutSec);
        String oriFile = "D:/Users/haob/tmp/18\u5e74/pdftest/pdf_reference_1.7.pdf";
        String sm2CertId = "6349002E00000003";
        int digestAlg = 6;
        CdbPkcs7DetachSignByDigest detachSignTest = new CdbPkcs7DetachSignByDigest();
        detachSignTest.m_certId = sm2CertId;
        detachSignTest.m_digestAlg = digestAlg;
        detachSignTest.is = new FileInputStream(oriFile);
        detachSignTest.done();
        detachSignTest.output();
        oriFile = "D:/Users/haob/tmp/18\u5e74/pdftest/pdf_reference_1.7.pdf";
        String rsaCertId = "6348000B00000015";
        digestAlg = 3;
        detachSignTest = new CdbPkcs7DetachSignByDigest();
        detachSignTest.m_certId = rsaCertId;
        detachSignTest.m_digestAlg = digestAlg;
        detachSignTest.is = new FileInputStream(oriFile);
        detachSignTest.done();
        detachSignTest.output();
        oriFile = "D:/Users/haob/tmp/18\u5e74/pdftest/pdf_reference_1.7.pdf";
        rsaCertId = "6348000B00000015";
        digestAlg = 3;
        detachSignTest = new CdbPkcs7DetachSignByDigest();
        detachSignTest.m_certId = rsaCertId;
        detachSignTest.m_digestAlg = digestAlg;
        detachSignTest.is = new ByteArrayInputStream(oriFile.getBytes());
        detachSignTest.done();
        detachSignTest.output();
        Svs2ClientHelper.SvsResultData result = helper.cdbPkcs7DetachVerifyEx(detachSignTest.m_result.m_b64SignedData, oriFile.getBytes());
        System.out.println("error code:" + result.m_errno);
        oriFile = "D:/Users/haob/tmp/18\u5e74/pdftest/pdf_reference_1.7.pdf";
        sm2CertId = "6349002E00000003";
        digestAlg = 6;
        detachSignTest = new CdbPkcs7DetachSignByDigest();
        detachSignTest.m_certId = sm2CertId;
        detachSignTest.m_digestAlg = digestAlg;
        detachSignTest.is = new ByteArrayInputStream(oriFile.getBytes());
        detachSignTest.done();
        detachSignTest.output();
        result = helper.cdbPkcs7DetachVerifyEx(detachSignTest.m_result.m_b64SignedData, oriFile.getBytes());
        System.out.println("error code:" + result.m_errno);
        oriFile = "qwer";
        rsaCertId = "6348000B00000015";
        digestAlg = 3;
        detachSignTest = new CdbPkcs7DetachSignByDigest();
        detachSignTest.m_certId = rsaCertId;
        detachSignTest.m_digestAlg = digestAlg;
        detachSignTest.is = new ByteArrayInputStream(oriFile.getBytes());
        detachSignTest.done();
        detachSignTest.output();
        result = helper.cdbPkcs7DetachVerifyEx(detachSignTest.m_result.m_b64SignedData, oriFile.getBytes());
        System.out.println("error code:" + result.m_errno);
    }
}

