/*
 * Decompiled with CFR 0.152.
 */
package test.com.koalii.svs;

import com.koalii.svs.client.Svs2ClientException;
import com.koalii.svs.client.Svs2ClientHelper;
import com.koalii.util.cert.X509Cert;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.MessageDigest;
import test.com.koalii.svs.TestObject;

public class CdbVerifySignByDigestTest
extends TestObject {
    private InputStream is = null;

    @Override
    public int done() throws Exception {
        Svs2ClientHelper helper = Svs2ClientHelper.getInstance();
        Svs2ClientHelper.SvsResultData result = helper.cdbGetSignCert(this.m_certId);
        String b64CertData = result.m_b64Cert;
        MessageDigest messageDigest = null;
        X509Cert cert = new X509Cert(b64CertData);
        if (cert.getCertType().equalsIgnoreCase("SM2")) {
            this.m_digestAlg = 6;
        } else {
            this.inputAlg();
        }
        try {
            messageDigest = Svs2ClientHelper.createDigest(this.m_digestAlg, b64CertData);
        }
        catch (Svs2ClientException e) {
            System.out.println(String.valueOf(e.getErrorNo()) + " " + e.getMessage());
            return e.getErrorNo();
        }
        byte[] b = new byte[4096];
        int nr = 0;
        while ((nr = this.is.read(b)) != -1) {
            messageDigest.update(b, 0, nr);
        }
        byte[] digest = messageDigest.digest();
        this.m_result = helper.cdbVerifySignByDigest(digest, this.m_digestAlg, this.m_signData, this.m_certId);
        return result.m_errno;
    }

    @Override
    public void input() throws Exception {
        this.m_certId = this.selectVerifyCert();
        this.is = this.inputOriStream();
        this.inputSignData();
    }

    @Override
    public void output() throws Exception {
        this.outputResult();
    }

    public static void main(String[] args) throws Exception {
        String host = "192.168.83.145";
        int port = 5000;
        int timeoutSec = 2;
        Svs2ClientHelper helper = Svs2ClientHelper.getInstance();
        helper.init(host, port, timeoutSec);
        String oriFile = "D:/Users/haob/tmp/18\u5e74/pdftest/pdf_reference_1.7.pdf";
        String sm2CertId = "6349002E00000003";
        int digestAlg = 6;
        String signData = "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";
        CdbVerifySignByDigestTest detachVerifyTest = new CdbVerifySignByDigestTest();
        detachVerifyTest.m_certId = sm2CertId;
        detachVerifyTest.m_digestAlg = digestAlg;
        detachVerifyTest.is = new FileInputStream(oriFile);
        detachVerifyTest.m_signData = signData;
        detachVerifyTest.done();
        detachVerifyTest.output();
        oriFile = "D:/Users/haob/tmp/18\u5e74/pdftest/pdf_reference_1.7.pdf";
        String rsaCertId = "6348000B00000015";
        digestAlg = 3;
        signData = "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";
        detachVerifyTest = new CdbVerifySignByDigestTest();
        detachVerifyTest.m_certId = rsaCertId;
        detachVerifyTest.m_digestAlg = digestAlg;
        detachVerifyTest.is = new FileInputStream(oriFile);
        detachVerifyTest.m_signData = signData;
        detachVerifyTest.done();
        detachVerifyTest.output();
    }
}

