/*
 * Decompiled with CFR 0.152.
 */
package test.com.koalii.svs;

import com.itextpdf.text.Rectangle;
import com.koalii.svs.client.Svs2ClientHelper;
import com.koalii.svs.client.Svs2ClientPDFHelper;
import test.com.koalii.svs.SvsClientTest;
import test.com.koalii.svs.TestObject;

public class PDFSignTest
extends TestObject {
    String fileName = "G:\\javaprojs\\res\\pdfs\\big_seal.pdf";
    String outputFileName = "G:\\javaprojs\\res\\pdfs\\big_seal2.pdf";
    String pkfPath = new String("");
    char[] passwd;
    int pageIndex = 0;
    Rectangle rectangle;
    String certId = null;
    Svs2ClientPDFHelper pdfSignature = null;
    Boolean isRemoteMode = true;
    String sealImagePath = null;
    float sealImageOpacity = 1.0f;
    long start = 0L;
    long end = 0L;

    @Override
    public int done() throws Exception {
        this.pdfSignature = this.isRemoteMode != false ? new Svs2ClientPDFHelper(Svs2ClientHelper.getInstance(), this.certId) : new Svs2ClientPDFHelper(this.pkfPath, new String(this.passwd));
        if (this.pdfSignature == null) {
            System.out.println("get pdf instatance error ,see log for detail info\n");
        }
        this.start = System.currentTimeMillis();
        this.pdfSignature.loadPdf(this.fileName, this.outputFileName);
        this.end = System.currentTimeMillis();
        System.out.println("load pdf :" + (this.end - this.start) + "ms");
        this.pdfSignature.setReason(this.inputString("input reason of signature: "));
        this.pdfSignature.setLocation(this.inputString("input location of signature: "));
        this.inputSealImage();
        this.inputPageIndex();
        this.inputSigatureRegion();
        this.start = System.currentTimeMillis();
        int errCode = this.pdfSignature.setVisibleAppearence(this.sealImagePath, this.pageIndex, this.rectangle, this.sealImageOpacity);
        this.end = System.currentTimeMillis();
        System.out.println("set visible Appearence :" + (this.end - this.start) + "ms");
        if (errCode < 0) {
            System.out.printf("set appearence error with " + errCode, new Object[0]);
            return errCode;
        }
        this.start = System.currentTimeMillis();
        errCode = this.pdfSignature.sign();
        this.end = System.currentTimeMillis();
        System.out.println("sign :" + (this.end - this.start) + "ms");
        if (errCode != 0) {
            if (errCode == -2101) {
                System.out.println("open pdf file failed");
            } else {
                System.out.printf("sign error with " + errCode + "\n", new Object[0]);
            }
        } else {
            System.out.printf("sign ok\n", new Object[0]);
        }
        return 0;
    }

    public void inputPageIndex() {
        System.out.print("set the number of page which would contain the signature ?(y/n)");
        String YN = this.m_scanner.next();
        if (YN.equalsIgnoreCase("yes") || YN.equalsIgnoreCase("y")) {
            if (this.pdfSignature != null) {
                int maxPageIndex = 0;
                maxPageIndex = Svs2ClientPDFHelper.getPageCount(this.fileName);
                System.out.println("number of page range from 1 to " + maxPageIndex);
            }
            System.out.print("input page number:");
            this.pageIndex = this.m_scanner.nextInt();
        } else {
            this.pageIndex = Svs2ClientPDFHelper.getPageCount(this.fileName);
            if (this.pageIndex < 0) {
                this.pageIndex = 1;
            }
        }
    }

    public void inputSigatureRegion() {
        System.out.print("set the rectangle region for the signature appearence ?(y/n)");
        String YN = this.m_scanner.next();
        if (YN.equalsIgnoreCase("yes") || YN.equalsIgnoreCase("y")) {
            Rectangle rectangle;
            if (this.pdfSignature != null && (rectangle = Svs2ClientPDFHelper.getPageSize(this.fileName, this.pageIndex)) != null) {
                System.out.println("the rectangle region of page " + this.pageIndex + " is [" + rectangle.getLeft() + "," + rectangle.getBottom() + "," + rectangle.getWidth() + "," + rectangle.getHeight() + " ].");
            }
            System.out.println("rectangle is represented by [x,y,width,height].");
            System.out.print("input rectangle's x value (float):");
            float llx = this.m_scanner.nextFloat();
            System.out.print("input rectangle's y value (float):");
            float lly = this.m_scanner.nextFloat();
            System.out.print("input rectangle's width value (float):");
            float width = this.m_scanner.nextFloat();
            System.out.print("input rectangle's height value (float):");
            float height = this.m_scanner.nextFloat();
            this.rectangle = new Rectangle(llx, lly, llx + width, lly + height);
        }
    }

    public void inputSealImage() {
        System.out.print("set seal image used for the appearence of signature ?(y/n).");
        String YN = this.m_scanner.next();
        if (YN.equalsIgnoreCase("yes") || YN.equalsIgnoreCase("y")) {
            this.sealImagePath = this.inputFileName("input image path of seal :");
            System.out.print("input value of opacity of seal image (range 0.0~1.0):");
            this.sealImageOpacity = this.m_scanner.nextFloat();
        }
    }

    public String inputString(String tip) {
        System.out.print(tip);
        return this.m_scanner.next();
    }

    @Override
    public void input() throws Exception {
        this.isRemoteMode = this.selectPdfMode();
        if (!this.isRemoteMode.booleanValue()) {
            this.pkfPath = this.inputFileName("input pfx path:");
            this.passwd = this.inputPasswd();
        } else {
            SvsClientTest.connect(30);
            this.certId = this.selectSignCert();
        }
        this.fileName = this.inputFileName("input pdf filename(signed):");
        this.outputFileName = this.inputFileName("input pdf output filename:");
    }

    @Override
    public void output() throws Exception {
    }
}

