/*
 * Decompiled with CFR 0.152.
 */
package test.com.koalii.svs;

import com.itextpdf.text.pdf.codec.Base64;
import com.koalii.svs.client.Svs2ClientHelper;
import com.koalii.svs.client.Svs2ClientPDFHelper;
import java.util.ArrayList;
import test.com.koalii.svs.SvsClientTest;
import test.com.koalii.svs.TestObject;

public class PDFVerifyTest
extends TestObject {
    private boolean isRemoteMode;
    private String fileName;
    Svs2ClientPDFHelper pdfSignature;
    String certId;
    String logFile = null;
    long start = 0L;
    long end = 0L;

    @Override
    public int done() throws Exception {
        int errCode;
        if (this.isRemoteMode) {
            this.start = System.currentTimeMillis();
            errCode = Svs2ClientPDFHelper.verify(this.fileName, Svs2ClientHelper.getInstance());
            this.end = System.currentTimeMillis();
            System.out.println("svs verify " + (this.end - this.start) + "ms");
        } else {
            this.start = System.currentTimeMillis();
            errCode = Svs2ClientPDFHelper.verify(this.fileName, null);
            this.end = System.currentTimeMillis();
            System.out.println("local verify " + (this.end - this.start) + "ms");
        }
        if (errCode == -2109) {
            System.out.println("no find signautre in pdf");
        } else if (errCode != 0) {
            if (errCode == -2101) {
                System.out.println("open pdf file failed with " + errCode + "\n");
            } else if (errCode == 1) {
                System.out.println("\u4ee5\u7b7e\u540d\uff0c\u4e14\u7b7e\u540d\u90fd\u662f\u6709\u6548\u7684\u662f\uff0c\u53ea\u662f\u5728\u6700\u540e\u4e00\u6b21\u7b7e\u540d\u540e\uff0c\u6587\u6863\u53d1\u751f\u4e86\u4e3a\u7b7e\u540d\u7684\u66f4\u6539");
            } else {
                System.out.printf("verify error with " + errCode + "\n", new Object[0]);
            }
        } else {
            System.out.printf("verify ok\n", new Object[0]);
        }
        System.out.print("print signatures (yes | no):");
        String YN = this.m_scanner.next();
        if (YN.equalsIgnoreCase("yes") || YN.equalsIgnoreCase("y")) {
            ArrayList<byte[]> p7s = Svs2ClientPDFHelper.getSignatures(this.fileName);
            for (byte[] p7 : p7s) {
                System.out.println("========================");
                System.out.print(Base64.encodeBytes((byte[])p7));
            }
        }
        System.out.print("print signature reasons (yes | no):");
        YN = this.m_scanner.next();
        if (YN.equalsIgnoreCase("yes") || YN.equalsIgnoreCase("y")) {
            ArrayList<String> p7sReasons = Svs2ClientPDFHelper.getSignReasons(this.fileName);
            for (String p7sReason : p7sReasons) {
                System.out.println("========================");
                System.out.print(p7sReason);
            }
        }
        return 0;
    }

    @Override
    public void input() throws Exception {
        this.isRemoteMode = this.selectPdfMode();
        if (this.isRemoteMode) {
            SvsClientTest.connect(30);
            this.certId = this.selectVerifyCert();
        }
        this.fileName = this.inputFileName("input pdf filename(verify):");
    }

    @Override
    public void output() throws Exception {
    }
}

