/*
 * Decompiled with CFR 0.152.
 */
package test.com.koalii.svs;

import com.koalii.svs.client.Svs2ClientHelper;
import com.koalii.svs.util.ScannerUtil;
import com.koalii.util.log.LogUtil;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import test.com.koalii.svs.CdbPkcs7DetachSignByDigest;
import test.com.koalii.svs.CdbPkcs7DetachSignExTest;
import test.com.koalii.svs.CdbPkcs7DetachVerifyByDigest;
import test.com.koalii.svs.CdbPkcs7DetachVerifyExTest;
import test.com.koalii.svs.CdbPkcs7EvpDecryptExTest;
import test.com.koalii.svs.CdbPkcs7EvpDecryptTest;
import test.com.koalii.svs.CdbPkcs7EvpEncryptExTest;
import test.com.koalii.svs.CdbPkcs7EvpEncryptTest;
import test.com.koalii.svs.CdbPkcs7SignTest;
import test.com.koalii.svs.CdbPkcs7VerifyTest;
import test.com.koalii.svs.CdbSignDataByDigestTest;
import test.com.koalii.svs.CdbSignDataWithUserIdTest;
import test.com.koalii.svs.CdbSignTest;
import test.com.koalii.svs.CdbSignWithDigetsAlgTest;
import test.com.koalii.svs.CdbVerifySignByDigestTest;
import test.com.koalii.svs.CdbVerifySignTest;
import test.com.koalii.svs.CdbVerifySignWithDigestAlgTest;
import test.com.koalii.svs.CdbVerifySignWithUserIdTest;
import test.com.koalii.svs.PDFSignTest;
import test.com.koalii.svs.PDFVerifyTest;
import test.com.koalii.svs.ParseCertTest;
import test.com.koalii.svs.ParsePkcs7Test;
import test.com.koalii.svs.Pkcs7DetachSignTest;
import test.com.koalii.svs.Pkcs7DetachSignWithDigestAlgTest;
import test.com.koalii.svs.Pkcs7DetachVerifyExTest;
import test.com.koalii.svs.Pkcs7DetachVerifyTest;
import test.com.koalii.svs.Pkcs7DetachVerifyWithDigestAlgTest;
import test.com.koalii.svs.Pkcs7SignFileHashTest;
import test.com.koalii.svs.Pkcs7SignFileHashWithDigestAlgTest;
import test.com.koalii.svs.Pkcs7SignTest;
import test.com.koalii.svs.Pkcs7VerifyFileHashTest;
import test.com.koalii.svs.Pkcs7VerifyFileHashWithDigestAlgTest;
import test.com.koalii.svs.Pkcs7VerifyTest;
import test.com.koalii.svs.SignTest;
import test.com.koalii.svs.Sm2Pkcs7DetachSignTest;
import test.com.koalii.svs.Sm2Pkcs7DetachVerifyExTest;
import test.com.koalii.svs.Sm2Pkcs7SignTest;
import test.com.koalii.svs.Sm2Pkcs7VerifyTest;
import test.com.koalii.svs.Sm2SignTest;
import test.com.koalii.svs.Sm2VerifySignTest;
import test.com.koalii.svs.TestObject;
import test.com.koalii.svs.VerifyCertTest;
import test.com.koalii.svs.VerifySignTest;

public class SvsClientTest
extends Thread {
    protected static ScannerUtil m_scanner = new ScannerUtil();
    private static Svs2ClientHelper m_helper = null;
    private static String m_ip = null;
    private static int m_port = 0;
    private static boolean m_is_use_pool = true;
    private static int m_timeout_sec = 0;
    private static int m_retry_times = 3;
    private static int m_retry_wait_sec = 3;
    private static File[] files = null;
    protected static String outPutFilePath = null;
    private static boolean isAuto = false;
    private static long max_last = 0L;
    private static long second_max = 0L;
    private static long times = 0L;
    private static long totalElapse = 0L;
    private static long last_totalElapse = 0L;
    private static long count = 1000L;
    private static ArrayList<TestCase> m_cases = new ArrayList();
    private static ArrayList<TestCase> m_cdbCases = new ArrayList();
    private static ArrayList<TestCase> m_pdfOperCases = new ArrayList();
    private static int m_ntotal = 0;
    private static long m_start = 0L;
    private static long m_last = 0L;
    private TestObject m_testObj = null;
    private int m_requests = 0;

    static {
        m_cases.add(new TestCase("Stop", "Stop"));
        m_cases.add(new TestCase("Sign", SignTest.class.getName()));
        m_cases.add(new TestCase("VerifySign", VerifySignTest.class.getName()));
        m_cases.add(new TestCase("Pkcs7Sign", Pkcs7SignTest.class.getName()));
        m_cases.add(new TestCase("Pkcs7Verify", Pkcs7VerifyTest.class.getName()));
        m_cases.add(new TestCase("Pkcs7SignFileHash", Pkcs7SignFileHashTest.class.getName()));
        m_cases.add(new TestCase("Pkcs7VerifyFileHash", Pkcs7VerifyFileHashTest.class.getName()));
        m_cases.add(new TestCase("Pkcs7SignFileHashWithDigestAlg", Pkcs7SignFileHashWithDigestAlgTest.class.getName()));
        m_cases.add(new TestCase("Pkcs7VerifyFileHashWithDigestAlg", Pkcs7VerifyFileHashWithDigestAlgTest.class.getName()));
        m_cases.add(new TestCase("Pkcs7DetachSign", Pkcs7DetachSignTest.class.getName()));
        m_cases.add(new TestCase("Pkcs7DetachVerify(send digest)", Pkcs7DetachVerifyTest.class.getName()));
        m_cases.add(new TestCase("Pkcs7DetachVerify(send origin)", Pkcs7DetachVerifyExTest.class.getName()));
        m_cases.add(new TestCase("Pkcs7DetachSignWithDigestAlg", Pkcs7DetachSignWithDigestAlgTest.class.getName()));
        m_cases.add(new TestCase("Pkcs7DetachVerifyWithDigestAlg", Pkcs7DetachVerifyWithDigestAlgTest.class.getName()));
        m_cases.add(new TestCase("VerifyCert", VerifyCertTest.class.getName()));
        m_cases.add(new TestCase("Sm2Sign", Sm2SignTest.class.getName()));
        m_cases.add(new TestCase("Sm2VerifySign", Sm2VerifySignTest.class.getName()));
        m_cases.add(new TestCase("Sm2Pkcs7Sign", Sm2Pkcs7SignTest.class.getName()));
        m_cases.add(new TestCase("Sm2Pkcs7Verify", Sm2Pkcs7VerifyTest.class.getName()));
        m_cases.add(new TestCase("Sm2Pkcs7DetachSign", Sm2Pkcs7DetachSignTest.class.getName()));
        m_cases.add(new TestCase("Sm2Pkcs7DetachVerifyEx", Sm2Pkcs7DetachVerifyExTest.class.getName()));
        m_cases.add(new TestCase("ParsePkcs7", ParsePkcs7Test.class.getName()));
        m_cases.add(new TestCase("ParseCert", ParseCertTest.class.getName()));
        m_cdbCases.add(new TestCase("Stop", "Stop"));
        m_cdbCases.add(new TestCase("CdbSign", CdbSignTest.class.getName()));
        m_cdbCases.add(new TestCase("CdbVerifySign", CdbVerifySignTest.class.getName()));
        m_cdbCases.add(new TestCase("CdbSignDataByDigest", CdbSignDataByDigestTest.class.getName()));
        m_cdbCases.add(new TestCase("CdbVerifySignByDigest", CdbVerifySignByDigestTest.class.getName()));
        m_cdbCases.add(new TestCase("CdbSignWithDigetsAlg", CdbSignWithDigetsAlgTest.class.getName()));
        m_cdbCases.add(new TestCase("CdbVerifySignWithDigestAlg", CdbVerifySignWithDigestAlgTest.class.getName()));
        m_cdbCases.add(new TestCase("CdbPkcs7Sign", CdbPkcs7SignTest.class.getName()));
        m_cdbCases.add(new TestCase("CdbPkcs7Verify", CdbPkcs7VerifyTest.class.getName()));
        m_cdbCases.add(new TestCase("CdbPkcs7DetachSign(send origin)", CdbPkcs7DetachSignExTest.class.getName()));
        m_cdbCases.add(new TestCase("CdbPkcs7DetachVerify(send origin)", CdbPkcs7DetachVerifyExTest.class.getName()));
        m_cdbCases.add(new TestCase("CdbPkcs7EvpEncrypt(send origin)", CdbPkcs7EvpEncryptTest.class.getName()));
        m_cdbCases.add(new TestCase("CdbPkcs7EvpDecrypt(send evpdata)", CdbPkcs7EvpDecryptTest.class.getName()));
        m_cdbCases.add(new TestCase("CdbPkcs7EvpEncrypt(send key)", CdbPkcs7EvpEncryptExTest.class.getName()));
        m_cdbCases.add(new TestCase("CdbPkcs7EvpDecrypt(send key)", CdbPkcs7EvpDecryptExTest.class.getName()));
        m_cdbCases.add(new TestCase("CdbPkcs7DetachSignByDigest(support svs2.3.37)", CdbPkcs7DetachSignByDigest.class.getName()));
        m_cdbCases.add(new TestCase("CdbPkcs7DetachVerifyByDigest(support svs2.3.37)", CdbPkcs7DetachVerifyByDigest.class.getName()));
        m_cdbCases.add(new TestCase("CdbSignDataWithUserId", CdbSignDataWithUserIdTest.class.getName()));
        m_cdbCases.add(new TestCase("CdbVerifySignWithUserId", CdbVerifySignWithUserIdTest.class.getName()));
        m_pdfOperCases.add(new TestCase("Stop", "Stop"));
        m_pdfOperCases.add(new TestCase("VerifyPDF", PDFVerifyTest.class.getName()));
        m_pdfOperCases.add(new TestCase("SignPDF", PDFSignTest.class.getName()));
    }

    public SvsClientTest(TestObject obj, int nreqs) {
        this.m_testObj = obj;
        this.m_requests = nreqs;
    }

    @Override
    public void run() {
        if (this.m_testObj == null) {
            return;
        }
        int nresult = 0;
        int i = 0;
        while (this.m_requests == 0 || i < this.m_requests) {
            try {
                long start = System.currentTimeMillis();
                nresult = this.m_testObj.done();
                long end = System.currentTimeMillis();
                long during = end - start;
                totalElapse += during;
                last_totalElapse += during;
                if (times != 0L) {
                    if (during > second_max) {
                        second_max = during;
                    }
                    if (during > max_last) {
                        max_last = during;
                    }
                }
                ++times;
            }
            catch (Exception e) {
                System.out.println("Error1: " + e.getMessage());
                e.printStackTrace();
            }
            if (nresult != 0) {
                System.out.println("Error: " + nresult);
            }
            SvsClientTest.total();
            if (this.m_requests == 0) continue;
            ++i;
        }
    }

    public static void lastElapse() {
        long current = System.currentTimeMillis();
        long elapse = current - m_last;
        float avg = (float)count / ((float)elapse / 1000.0f);
        System.out.println("Last max = " + max_last + " ms");
        System.out.println("Last avg elapse = " + (float)last_totalElapse / (float)count + " ms");
        System.out.println("Total " + count + ", Last elapse " + elapse + "ms, Avg " + avg + "tps");
        System.out.println();
        m_last = current;
        max_last = 0L;
        last_totalElapse = 0L;
        m_last = current;
    }

    public static void totalElapse() {
        long current = System.currentTimeMillis();
        long elapse = current - m_start;
        float avg = (float)m_ntotal / ((float)elapse / 1000.0f);
        System.out.println("Total max = " + second_max + " ms");
        System.out.println("Total elapse = " + totalElapse + " ms");
        System.out.println("Total avg elapse = " + (float)totalElapse / (float)m_ntotal + " ms");
        System.out.println("Total " + m_ntotal + ", total elapse " + elapse + "ms, Avg " + avg + "tps");
    }

    public static void cleanCounter() {
        last_totalElapse = 0L;
        totalElapse = 0L;
        max_last = 0L;
        second_max = 0L;
    }

    public static synchronized void total() {
        if (0L == (long)(++m_ntotal) % count) {
            SvsClientTest.lastElapse();
        }
    }

    public static String inputSelect() throws Exception {
        int i = 0;
        String[] name = new String[m_cases.size()];
        System.out.println("Please input your selection: ");
        i = 0;
        while (i < m_cases.size()) {
            TestCase c = m_cases.get(i);
            System.out.println("[" + i + "] " + c.m_name);
            name[i] = c.m_class;
            ++i;
        }
        System.out.print("Your selection: ");
        int select = m_scanner.nextInt();
        if (select < 0 || select >= m_cases.size()) {
            System.out.println("Invalid selection!");
            return null;
        }
        if (name[select].equalsIgnoreCase("stop")) {
            System.exit(1);
        }
        System.out.println();
        System.out.println("=== Start " + name[select] + " Test ===");
        return name[select];
    }

    public static String cdbSelect() throws Exception {
        int i = 0;
        String[] name = new String[m_cdbCases.size()];
        System.out.println("Please input your selection: ");
        i = 0;
        while (i < m_cdbCases.size()) {
            TestCase c = m_cdbCases.get(i);
            System.out.println("[" + i + "] " + c.m_name);
            name[i] = c.m_class;
            ++i;
        }
        System.out.print("Your selection: ");
        int select = m_scanner.nextInt();
        if (select < 0 || select >= m_cdbCases.size()) {
            System.out.println("Invalid selection!");
            return null;
        }
        if (name[select].equalsIgnoreCase("stop")) {
            System.exit(1);
        }
        System.out.println();
        System.out.println("=== Start " + name[select] + " Test ===");
        return name[select];
    }

    public static String pdfOperSelect() throws Exception {
        int i = 0;
        String[] name = new String[m_pdfOperCases.size()];
        System.out.println("Please input your selection: ");
        i = 0;
        while (i < m_pdfOperCases.size()) {
            TestCase c = m_pdfOperCases.get(i);
            System.out.println("[" + i + "] " + c.m_name);
            name[i] = c.m_class;
            ++i;
        }
        System.out.print("Your selection: ");
        int select = m_scanner.nextInt();
        if (select < 0 || select >= m_pdfOperCases.size()) {
            System.out.println("Invalid selection!");
            return null;
        }
        if (name[select].equalsIgnoreCase("stop")) {
            System.exit(1);
        }
        System.out.println();
        System.out.println("=== Start " + name[select] + " Test ===");
        return name[select];
    }

    public static void inputConnect() throws Exception {
        System.out.print("Please input svs host ip: ");
        m_ip = m_scanner.next();
        System.out.print("Please input svs host port: ");
        m_port = m_scanner.nextInt();
        System.out.print("Please input is use socket pool (Y/N): ");
        String s = m_scanner.next();
        m_is_use_pool = s.equalsIgnoreCase("Y");
        System.out.print("Please input recv timeout (seconds: 0 ~ 30):");
        m_timeout_sec = m_scanner.nextInt();
        System.out.print("Please input retry times (0: for default):");
        m_retry_times = m_scanner.nextInt();
        if (m_retry_times > 0) {
            System.out.print("Please input retry wait seconds (>= 0):");
            m_retry_wait_sec = m_scanner.nextInt();
        }
        System.out.println();
    }

    public static void inputLogFile() {
        if (LogUtil.getFileLogger() == null) {
            System.out.print("Is using log file(Y/N): ");
            String s = m_scanner.next();
            if ('Y' == s.charAt(0) || 'y' == s.charAt(0)) {
                System.out.println("Please input log filename (with full path):");
                String f = m_scanner.next();
                LogUtil.init(f);
            }
        }
    }

    public static void connect(int concurrency) throws Exception {
        if (m_helper == null) {
            m_helper = Svs2ClientHelper.getInstance();
            SvsClientTest.inputConnect();
            if (m_is_use_pool) {
                m_helper.init(m_ip, m_port, m_timeout_sec, concurrency);
            } else {
                m_helper.initNoPool(m_ip, m_port, m_timeout_sec);
            }
            if (m_retry_times > 0) {
                m_helper.setRetry(m_retry_times, m_retry_wait_sec);
            }
            if (LogUtil.getFileLogger() == null) {
                System.out.print("Is using log file(Y/N): ");
                String s = m_scanner.next();
                if ('Y' == s.charAt(0) || 'y' == s.charAt(0)) {
                    System.out.println("Please input log filename (with full path):");
                    String f = m_scanner.next();
                    m_helper.setLogFile(f);
                }
            }
            System.out.println();
        }
    }

    public static void singleTest() throws Exception {
        boolean iscontinue = true;
        SvsClientTest.connect(30);
        while (iscontinue) {
            String name = SvsClientTest.inputSelect();
            if (name == null) continue;
            TestObject obj = (TestObject)Class.forName(name).newInstance();
            obj.test();
            System.out.println();
            System.out.print("Continue? (Y/N): ");
            String s = m_scanner.next();
            if ('N' == s.charAt(0) || 'n' == s.charAt(0)) {
                iscontinue = false;
            }
            System.out.println();
        }
    }

    public static void cdbTest() throws Exception {
        boolean iscontinue = true;
        SvsClientTest.connect(30);
        while (iscontinue) {
            String name = SvsClientTest.cdbSelect();
            if (name == null) continue;
            TestObject obj = (TestObject)Class.forName(name).newInstance();
            obj.test();
            System.out.println();
            System.out.print("Continue? (Y/N): ");
            String s = m_scanner.next();
            if ('N' == s.charAt(0) || 'n' == s.charAt(0)) {
                iscontinue = false;
            }
            System.out.println();
        }
    }

    public static void multiTest(int type) throws Exception {
        boolean iscontinue = true;
        SvsClientTest.connect(200);
        while (iscontinue) {
            String name = type == 0 ? SvsClientTest.inputSelect() : SvsClientTest.cdbSelect();
            if (name == null) continue;
            TestObject tobj = (TestObject)Class.forName(name).newInstance();
            tobj.input();
            System.out.print("Please input the thread num (1-200): ");
            int nthreads = m_scanner.nextInt();
            System.out.print("Please input the test num per thread (0 for unlimit): ");
            int nreqs = m_scanner.nextInt();
            System.out.print("Please input transaction count between two output(1000)\uff1a");
            count = m_scanner.nextLong();
            SvsClientTest[] cases = new SvsClientTest[nthreads];
            m_start = m_last = System.currentTimeMillis();
            m_ntotal = 0;
            int i = 0;
            while (i < nthreads) {
                cases[i] = new SvsClientTest(tobj, nreqs);
                cases[i].start();
                ++i;
            }
            int j = 0;
            while (j < nthreads) {
                cases[j].join();
                ++j;
            }
            System.out.println();
            SvsClientTest.totalElapse();
            System.out.print("Continue? (Y/N): ");
            String s = m_scanner.next();
            if ('N' == s.charAt(0) || 'n' == s.charAt(0)) {
                iscontinue = false;
            }
            SvsClientTest.cleanCounter();
            System.out.println();
        }
    }

    public static void pdfSignature() throws Exception {
        boolean iscontinue = true;
        SvsClientTest.inputLogFile();
        while (iscontinue) {
            String name = SvsClientTest.pdfOperSelect();
            if (name == null) continue;
            TestObject obj = (TestObject)Class.forName(name).newInstance();
            obj.test();
            System.out.println();
            System.out.print("Continue? (Y/N): ");
            String s = m_scanner.next();
            if ('N' == s.charAt(0) || 'n' == s.charAt(0)) {
                iscontinue = false;
            }
            System.out.println();
        }
    }

    public static boolean testPdfSignaure() {
        String testPdfSignture = System.getProperty("testPdfSignture");
        return testPdfSignture != null;
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Welcom to svs client java api test, current vertion is " + Svs2ClientHelper.version());
        if (args != null && args.length > 1) {
            files = ScannerUtil.getAllFiles(args[0]);
            outPutFilePath = SvsClientTest.pathForamt(args[1]);
            isAuto = true;
        }
        System.out.println("Please input test mode:");
        System.out.println("[1]: function test");
        System.out.println("[2]: concurrency test");
        System.out.println("[3]: cdb function test");
        System.out.println("[4]: cdb concurrency test");
        if (args.length >= 1 && args[0].equals("testPdfSignature")) {
            System.out.println("[5]: pdf signature test");
        }
        System.out.print("Your selection: ");
        if (isAuto) {
            int i = 0;
            while (i < files.length) {
                m_helper = null;
                m_scanner.setOutpath(String.valueOf(outPutFilePath) + SvsClientTest.getDate() + "_" + files[i].getName());
                m_scanner.reset(files[i].getPath(), isAuto);
                m_scanner.init();
                int nselect = m_scanner.nextInt();
                switch (nselect) {
                    case 1: {
                        SvsClientTest.singleTest();
                        break;
                    }
                    case 2: {
                        m_scanner.setOutpath(null);
                        SvsClientTest.multiTest(0);
                        break;
                    }
                    case 3: {
                        SvsClientTest.cdbTest();
                        break;
                    }
                    case 4: {
                        m_scanner.setOutpath(null);
                        SvsClientTest.multiTest(1);
                        break;
                    }
                    case 5: {
                        SvsClientTest.pdfSignature();
                    }
                    default: {
                        System.out.println("Invalid selection! Exit!");
                    }
                }
                ++i;
            }
        } else {
            m_scanner = new ScannerUtil(null, isAuto);
            int nselect = m_scanner.nextInt();
            System.out.println();
            switch (nselect) {
                case 1: {
                    SvsClientTest.singleTest();
                    break;
                }
                case 2: {
                    SvsClientTest.multiTest(0);
                    break;
                }
                case 3: {
                    SvsClientTest.cdbTest();
                    break;
                }
                case 4: {
                    SvsClientTest.multiTest(1);
                    break;
                }
                case 5: {
                    SvsClientTest.pdfSignature();
                }
                default: {
                    System.out.println("Invalid selection! Exit!");
                }
            }
        }
    }

    public static String pathForamt(String pathstr) {
        if (!"/".equals(Character.valueOf(pathstr.toCharArray()[pathstr.toCharArray().length - 1]))) {
            return String.valueOf(pathstr) + "/";
        }
        return pathstr;
    }

    public static String getDate() {
        SimpleDateFormat myFmt1 = new SimpleDateFormat("yyyyMMddHHmmss");
        return myFmt1.format(new Date());
    }

    protected static class TestCase {
        public String m_name;
        public String m_class;

        public TestCase(String name, String classname) {
            this.m_name = name;
            this.m_class = classname;
        }
    }
}

