/*
 * Decompiled with CFR 0.152.
 */
package test.com.koalii.svs;

import com.koalii.svs.client.Svs2ClientHelper;
import com.koalii.svs.util.FileUtil;
import com.koalii.svs.util.ScannerUtil;
import com.koalii.util.encoders.Base64;
import java.io.ByteArrayInputStream;
import java.io.Console;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import test.com.koalii.svs.SvsClientTest;

public abstract class TestObject {
    protected ScannerUtil m_scanner = SvsClientTest.m_scanner;
    protected byte[] m_oriData = null;
    protected String m_oriFile = null;
    protected String m_certData = null;
    protected String m_signData = null;
    protected String m_certId = null;
    protected Svs2ClientHelper.SvsResultData m_result = null;
    protected int m_errno = -1;
    protected int m_digestAlg = -1;
    protected String outpathForSignOrEvpData = null;
    protected String outpathForCertData = null;
    protected byte[] m_userId = null;

    public abstract int done() throws Exception;

    public abstract void input() throws Exception;

    public abstract void output() throws Exception;

    public void test() throws Exception {
        this.input();
        this.done();
        this.output();
    }

    public byte[] readFile(String filename) {
        FileInputStream fin = null;
        byte[] fdata = null;
        try {
            fin = new FileInputStream(filename);
            fdata = new byte[fin.available()];
            fin.read(fdata);
        }
        catch (Exception e) {
            fdata = null;
        }
        try {
            fin.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fdata;
    }

    public String selectVerifyCert() {
        System.out.println("Please input select type:");
        System.out.println("0: select cert form server");
        System.out.println("1: select cert from input data");
        System.out.println("Your Selection: ");
        int isSelect = this.m_scanner.nextInt();
        if (isSelect == 0) {
            System.out.println("Please select cert id type: ");
            System.out.println("0: DN");
            System.out.println("1: alias");
            System.out.print("Your Selection: ");
            int type = this.m_scanner.nextInt();
            if (type == 0) {
                return this.selectCert(false, true);
            }
            return this.selectCert(false, false);
        }
        System.out.println("please input certDN or alias :");
        return this.m_scanner.next();
    }

    public String selectSignCert() {
        System.out.println("Please input select type:");
        System.out.println("0: select cert form server");
        System.out.println("1: select cert from input data");
        System.out.println("Your Selection: ");
        int isSelect = this.m_scanner.nextInt();
        if (isSelect == 0) {
            System.out.println("Please input select cert id type: ");
            System.out.println("0: DN");
            System.out.println("1: alias");
            System.out.print("Your Selection: ");
            int type = this.m_scanner.nextInt();
            System.out.println();
            if (type == 0) {
                return this.selectCert(true, true);
            }
            return this.selectCert(true, false);
        }
        System.out.println("please input certDN or alias :");
        return this.m_scanner.next();
    }

    public String selectCert(boolean isSign, boolean isDn) {
        Svs2ClientHelper helper = Svs2ClientHelper.getInstance();
        Svs2ClientHelper.SvsResultData result = null;
        result = isSign ? (isDn ? helper.cdbGetSignCertList(512) : helper.cdbGetSignCertAliasList(512)) : (isDn ? helper.cdbGetCertList(512) : helper.cdbGetCertAliasList(512));
        int s = -1;
        System.out.println("Select cert: ");
        int i = 0;
        while (i < result.m_certs.size()) {
            System.out.println("[" + i + "] " + result.m_certs.get(i));
            int j = i + 1;
            if (j % 16 == 0 || i == result.m_certs.size() - 1) {
                if (j % 16 == 0) {
                    System.out.print("Is need to show more(Y/N)? ");
                    String isSelectNext = this.m_scanner.next();
                    if (isSelectNext.charAt(0) != '\u0001') {
                        System.out.print("Your Selection: ");
                        s = this.m_scanner.nextInt();
                        if (s >= 0 && s < result.m_certs.size()) {
                            return result.m_certs.get(s);
                        }
                        System.out.println("Invalid selections!");
                        return null;
                    }
                } else {
                    System.out.print("Your Selection: ");
                    s = this.m_scanner.nextInt();
                    if (s >= 0 && s < result.m_certs.size()) {
                        return result.m_certs.get(s);
                    }
                    System.out.println("Invalid selections!");
                    return null;
                }
            }
            ++i;
        }
        return result.m_certs.get(s);
    }

    public String inputFileName(String tip) {
        System.out.print(tip);
        return this.m_scanner.next();
    }

    public void inputOriFileName() {
        System.out.println("Please input origin file name: ");
        this.m_oriFile = this.m_scanner.next();
    }

    public char[] inputPasswd() {
        Console cons = System.console();
        System.out.print("passwd:");
        char[] passwd = cons != null ? cons.readPassword() : this.m_scanner.next().toCharArray();
        return passwd;
    }

    public boolean selectPdfMode() {
        System.out.println("select mode for signing or verifying pdf:");
        System.out.println("0 : remote mode (use svs server)");
        System.out.println("1 : local mode (use itext)");
        System.out.print("your selection:");
        int mode = this.m_scanner.nextInt();
        boolean isRemoteMode = mode == 0;
        return isRemoteMode;
    }

    public String inputData() throws Exception {
        System.out.println("Select data type: ");
        System.out.println("0: data");
        System.out.println("1: file");
        System.out.print("Your Selection: ");
        int type = this.m_scanner.nextInt();
        if (1 == type) {
            System.out.println("File name: ");
            String filename = this.m_scanner.next();
            return new String(this.readFile(filename));
        }
        System.out.println("Data: ");
        String s = this.m_scanner.next();
        return s;
    }

    public void inputOriData() throws Exception {
        this.m_oriData = null;
        this.m_oriFile = null;
        System.out.println("Please input origin data:");
        System.out.println("Select data type: ");
        System.out.println("0: data");
        System.out.println("1: file");
        System.out.print("Your Selection: ");
        int type = this.m_scanner.nextInt();
        if (1 == type) {
            System.out.println("File name: ");
            this.m_oriFile = this.m_scanner.next();
            this.m_oriData = this.readFile(this.m_oriFile);
        } else {
            System.out.println("Data: ");
            this.m_oriData = this.m_scanner.next().getBytes(Charset.forName("UTF-8"));
        }
        System.out.println();
    }

    public InputStream inputOriStream() throws Exception {
        this.m_oriData = null;
        this.m_oriFile = null;
        InputStream is = null;
        System.out.println("Please input origin data:");
        System.out.println("Select data type: ");
        System.out.println("0: data");
        System.out.println("1: file");
        System.out.print("Your Selection: ");
        int type = this.m_scanner.nextInt();
        if (1 == type) {
            System.out.println("File name: ");
            this.m_oriFile = this.m_scanner.next();
            is = new FileInputStream(this.m_oriFile);
        } else {
            System.out.println("Data: ");
            this.m_oriData = this.m_scanner.next().getBytes(Charset.forName("UTF-8"));
            is = new ByteArrayInputStream(this.m_oriData);
        }
        System.out.println();
        return is;
    }

    public void inputCertData() throws Exception {
        System.out.println("Please input base64 cert:");
        this.m_certData = this.inputData();
        System.out.println();
    }

    public void inputSignData() throws Exception {
        System.out.println("Please input sign or evp data:");
        this.m_signData = this.inputData();
        System.out.println();
    }

    public void inputOutpathForSignOrEvpData() throws Exception {
        System.out.println("Is input outpath for Sign or Evp data ?");
        System.out.println("0 : No");
        System.out.println("1 : Yes");
        int nselect = this.m_scanner.nextInt();
        if (nselect == 1) {
            System.out.println("Please input outpath :");
            this.outpathForSignOrEvpData = this.m_scanner.next();
        }
    }

    public void inputOutpathForCertData() throws Exception {
        System.out.println("Is input outpath for cert data ?");
        System.out.println("0 : No");
        System.out.println("1 : Yes");
        int nselect = this.m_scanner.nextInt();
        if (nselect == 1) {
            System.out.println("Please input outpath :");
            this.outpathForCertData = this.m_scanner.next();
        }
    }

    public void inputAlg() throws Exception {
        System.out.println("Please input digestAlg :");
        System.out.println("1 : MD5");
        System.out.println("2 : SHA-1");
        System.out.println("3 : SHA-256");
        System.out.println("4 : SHA-512");
        System.out.print("Your selection:");
        this.m_digestAlg = this.m_scanner.nextInt();
        System.out.println();
    }

    public void inputUserId() throws Exception {
        System.out.println("Is input user id ?");
        System.out.println("0 : No");
        System.out.println("1 : Yes");
        int nselect = this.m_scanner.nextInt();
        if (nselect == 1) {
            System.out.println("Please input user id:");
            this.m_userId = this.m_scanner.next().getBytes(Charset.forName("UTF-8"));
            System.out.println();
        }
    }

    public void outputResult() throws Exception {
        String compareResult = null;
        if (this.m_result != null) {
            System.out.println("Result: " + this.m_result.m_errno);
            if (SvsClientTest.outPutFilePath != null) {
                this.m_scanner.writeFileByLine("m_errno : " + this.m_result.m_errno);
                System.out.print("Please input the error num:");
                int inPutData = this.m_scanner.nextInt();
                compareResult = inPutData == this.m_result.m_errno ? "true" : "false";
                this.m_scanner.writeFileByLine("compare m_errno result : " + compareResult);
            }
            if (this.m_result.m_errno != 0) {
                System.out.println("Failed!");
                return;
            }
            if (this.m_result.m_originData != null && this.m_result.m_originData.length > 0) {
                System.out.println("Origin Data [" + this.m_result.m_originData.length + "]:");
                System.out.println(new String(this.m_result.m_originData));
                this.m_scanner.writeFileByLine("Origin Data(base64) : " + new String(Base64.encode(this.m_result.m_originData)));
            }
            if (this.m_result.m_b64SignedData != null && this.m_result.m_b64SignedData.length() > 0) {
                System.out.println("Sign Data(base64) [" + this.m_result.m_b64SignedData.length() + "]:");
                System.out.println(this.m_result.m_b64SignedData);
                if (this.outpathForSignOrEvpData != null) {
                    FileUtil.writeFileBytes(this.outpathForSignOrEvpData, this.m_result.m_b64SignedData.getBytes());
                }
                this.m_scanner.writeFileByLine("Sign Data(base64) : " + this.m_result.m_b64SignedData);
            }
            if (this.m_result.m_b64Cert != null && this.m_result.m_b64Cert.length() > 0) {
                System.out.println("Sign Cert(base64) [" + this.m_result.m_b64Cert.length() + "]:");
                System.out.println(this.m_result.m_b64Cert);
                Svs2ClientHelper helper = Svs2ClientHelper.getInstance();
                System.out.println("SN is:" + helper.parseX509Cert(this.m_result.m_b64Cert, "SN_HEX"));
                System.out.println("DN is:" + helper.parseX509Cert(this.m_result.m_b64Cert, "DN"));
                System.out.println("ISSUR is:" + helper.parseX509Cert(this.m_result.m_b64Cert, "ISSUER"));
                System.out.println("START is:" + helper.parseX509Cert(this.m_result.m_b64Cert, "START"));
                System.out.println("END is:" + helper.parseX509Cert(this.m_result.m_b64Cert, "END"));
                if (this.outpathForCertData != null) {
                    FileUtil.writeFileBytes(this.outpathForCertData, this.m_result.m_b64Cert.getBytes());
                }
                this.m_scanner.writeFileByLine("Sign Cert(base64) : " + this.m_result.m_b64Cert);
            }
            if (this.m_result.m_b64EvpData != null && this.m_result.m_b64EvpData.length() > 0) {
                System.out.println("Envelop Data(base64) [" + this.m_result.m_b64EvpData.length() + "]:");
                System.out.println(this.m_result.m_b64EvpData);
                if (this.outpathForSignOrEvpData != null) {
                    FileUtil.writeFileBytes(this.outpathForSignOrEvpData, this.m_result.m_b64EvpData.getBytes());
                }
                this.m_scanner.writeFileByLine("Envelop Data(base64) : " + this.m_result.m_b64EvpData);
            }
            if (this.m_result.m_digestAlg != null && this.m_result.m_digestAlg.length() > 0) {
                System.out.println("digestAlg is:" + this.m_result.m_digestAlg);
            }
            if (this.m_result.m_signAlg != null && this.m_result.m_signAlg.length() > 0) {
                System.out.println("signAlg is:" + this.m_result.m_signAlg);
            }
        }
    }
}

