/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.sandbox;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Meter;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Spectator;
import com.netflix.spectator.api.Statistic;
import com.netflix.spectator.api.Tag;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class DoubleDistributionSummary
implements Meter {
    private static final ConcurrentHashMap<Id, DoubleDistributionSummary> INSTANCES = new ConcurrentHashMap();
    private static final long RESET_FREQ = 60000L;
    private static final long INACTIVE_TTL = 900000L;
    private static final long ZERO = Double.doubleToLongBits(0.0);
    private final Clock clock;
    private final Id id;
    private final long resetFreq;
    private final AtomicLong lastResetTime;
    private final AtomicLong lastUpdateTime;
    private final AtomicLong count;
    private final AtomicLong totalAmount;
    private final AtomicLong totalOfSquares;
    private final AtomicLong max;
    private final Id countId;
    private final Id totalAmountId;
    private final Id totalOfSquaresId;
    private final Id maxId;

    public static DoubleDistributionSummary get(Id id) {
        return DoubleDistributionSummary.get((Registry)Spectator.globalRegistry(), id);
    }

    static DoubleDistributionSummary get(Registry registry, Id id) {
        Clock c;
        DoubleDistributionSummary tmp;
        DoubleDistributionSummary instance = INSTANCES.get(id);
        if (instance == null && (instance = INSTANCES.putIfAbsent(id, tmp = new DoubleDistributionSummary(c = registry.clock(), id, 60000L))) == null) {
            instance = tmp;
            registry.register((Meter)tmp);
        }
        return instance;
    }

    DoubleDistributionSummary(Clock clock, Id id, long resetFreq) {
        this.clock = clock;
        this.id = id;
        this.resetFreq = resetFreq;
        this.lastResetTime = new AtomicLong(clock.wallTime());
        this.lastUpdateTime = new AtomicLong(clock.wallTime());
        this.count = new AtomicLong(0L);
        this.totalAmount = new AtomicLong(ZERO);
        this.totalOfSquares = new AtomicLong(ZERO);
        this.max = new AtomicLong(ZERO);
        this.countId = id.withTag((Tag)Statistic.count);
        this.totalAmountId = id.withTag((Tag)Statistic.totalAmount);
        this.totalOfSquaresId = id.withTag((Tag)Statistic.totalOfSquares);
        this.maxId = id.withTag((Tag)Statistic.max);
    }

    private void add(AtomicLong num, double amount) {
        double d;
        long next;
        long v;
        while (!num.compareAndSet(v = num.get(), next = Double.doubleToLongBits((d = Double.longBitsToDouble(v)) + amount))) {
        }
    }

    private void max(AtomicLong num, double amount) {
        long v;
        double d;
        long n = Double.doubleToLongBits(amount);
        while (amount > (d = Double.longBitsToDouble(v = num.get())) && !num.compareAndSet(v, n)) {
        }
    }

    private double toRateLong(AtomicLong num, long deltaMillis, boolean reset) {
        long v = reset ? num.getAndSet(0L) : num.get();
        double delta = (double)deltaMillis / 1000.0;
        return (double)v / delta;
    }

    private double toRateDouble(AtomicLong num, long deltaMillis, boolean reset) {
        long v = reset ? num.getAndSet(ZERO) : num.get();
        double delta = (double)deltaMillis / 1000.0;
        return Double.longBitsToDouble(v) / delta;
    }

    private double toDouble(AtomicLong num, boolean reset) {
        long v = reset ? num.getAndSet(ZERO) : num.get();
        return Double.longBitsToDouble(v);
    }

    public Id id() {
        return this.id;
    }

    public boolean hasExpired() {
        return this.clock.wallTime() - this.lastUpdateTime.get() > 900000L;
    }

    public Iterable<Measurement> measure() {
        boolean reset;
        long prev;
        long now = this.clock.wallTime();
        long delta = now - (prev = this.lastResetTime.get());
        boolean bl = reset = delta > this.resetFreq;
        if (reset) {
            this.lastResetTime.set(now);
        }
        ArrayList<Measurement> ms = new ArrayList<Measurement>(3);
        if (delta > 1000L) {
            ms.add(new Measurement(this.countId, now, this.toRateLong(this.count, delta, reset)));
            ms.add(new Measurement(this.totalAmountId, now, this.toRateDouble(this.totalAmount, delta, reset)));
            ms.add(new Measurement(this.totalOfSquaresId, now, this.toRateDouble(this.totalOfSquares, delta, reset)));
            ms.add(new Measurement(this.maxId, now, this.toDouble(this.max, reset)));
        }
        return ms;
    }

    public void record(double amount) {
        if (amount >= 0.0) {
            this.add(this.totalAmount, amount);
            this.add(this.totalOfSquares, amount * amount);
            this.max(this.max, amount);
            this.count.incrementAndGet();
            this.lastUpdateTime.set(this.clock.wallTime());
        }
    }

    public long count() {
        return this.count.get();
    }

    public double totalAmount() {
        return Double.longBitsToDouble(this.totalAmount.get());
    }
}

