/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.docker.registry.api.v2.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.netflix.spinnaker.clouddriver.docker.registry.api.v2.DockerUserAgent;
import com.netflix.spinnaker.clouddriver.docker.registry.api.v2.auth.DockerBearerTokenService;
import com.netflix.spinnaker.clouddriver.docker.registry.api.v2.client.DockerRegistryCatalog;
import com.netflix.spinnaker.clouddriver.docker.registry.api.v2.client.DockerRegistryTags;
import com.netflix.spinnaker.clouddriver.docker.registry.api.v2.exception.DockerRegistryOperationException;
import com.netflix.spinnaker.clouddriver.docker.registry.security.TrustAllX509TrustManager;
import com.squareup.okhttp.OkHttpClient;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.io.File;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.security.SecureRandom;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit.RestAdapter;
import retrofit.RetrofitError;
import retrofit.client.OkClient;
import retrofit.client.Response;
import retrofit.converter.GsonConverter;
import retrofit.http.GET;
import retrofit.http.Header;
import retrofit.http.Headers;
import retrofit.http.Path;
import retrofit.http.Query;

public class DockerRegistryClient
implements GroovyObject {
    private static final Logger LOG;
    private DockerBearerTokenService tokenService;
    private String address;
    private String email;
    private DockerRegistryService registryService;
    private GsonConverter converter;
    private String catalogFile;
    private static final String userAgent;
    private final int paginateSize;
    private Map tagDateCache;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public DockerRegistryClient(String address, long clientTimeoutMillis, int paginateSize, String catalogFile, boolean insecureRegistry) {
        MetaClass metaClass;
        Map map;
        CallSite[] callSiteArray = DockerRegistryClient.$getCallSiteArray();
        this.tagDateCache = map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        int n = paginateSize;
        this.paginateSize = DefaultTypeTransformation.intUnbox((Object)n);
        Object object = callSiteArray[0].callConstructor(DockerBearerTokenService.class);
        this.tokenService = (DockerBearerTokenService)ScriptBytecodeAdapter.castToType((Object)object, DockerBearerTokenService.class);
        OkHttpClient client = (OkHttpClient)ScriptBytecodeAdapter.castToType((Object)callSiteArray[1].callConstructor(OkHttpClient.class), OkHttpClient.class);
        callSiteArray[2].call((Object)client, (Object)clientTimeoutMillis, callSiteArray[3].callGetProperty(TimeUnit.class));
        if (insecureRegistry) {
            SSLContext sslContext = (SSLContext)ScriptBytecodeAdapter.castToType((Object)callSiteArray[4].call(SSLContext.class, (Object)"SSL"), SSLContext.class);
            TrustManager[] trustManagers = new TrustManager[]{(TrustManager)ScriptBytecodeAdapter.castToType((Object)callSiteArray[5].callConstructor(TrustAllX509TrustManager.class), TrustManager.class)};
            callSiteArray[6].call((Object)sslContext, null, (Object)trustManagers, callSiteArray[7].callConstructor(SecureRandom.class));
            callSiteArray[8].call((Object)client, callSiteArray[9].call((Object)sslContext));
        }
        Object object2 = callSiteArray[10].call(callSiteArray[11].call(callSiteArray[12].call(callSiteArray[13].call(callSiteArray[14].call(callSiteArray[15].callConstructor(RestAdapter.Builder.class), (Object)address), callSiteArray[16].callConstructor(OkClient.class, (Object)client)), callSiteArray[17].callGetProperty(RestAdapter.LogLevel.class))), DockerRegistryService.class);
        this.registryService = (DockerRegistryService)ScriptBytecodeAdapter.castToType((Object)object2, DockerRegistryService.class);
        Object object3 = callSiteArray[18].callConstructor(GsonConverter.class, callSiteArray[19].call(callSiteArray[20].callConstructor(GsonBuilder.class)));
        this.converter = (GsonConverter)ScriptBytecodeAdapter.castToType((Object)object3, GsonConverter.class);
        String string = address;
        this.address = ShortTypeHandling.castToString((Object)string);
        String string2 = catalogFile;
        this.catalogFile = ShortTypeHandling.castToString((Object)string2);
    }

    public DockerRegistryClient(String address, String email, String username, String password, String passwordCommand, long clientTimeoutMillis, int paginateSize, String catalogFile, boolean insecureRegistry) {
        CallSite[] callSiteArray = DockerRegistryClient.$getCallSiteArray();
        this(address, clientTimeoutMillis, paginateSize, catalogFile, insecureRegistry);
        Object object = callSiteArray[21].callConstructor(DockerBearerTokenService.class, (Object)username, (Object)password, (Object)passwordCommand);
        this.tokenService = (DockerBearerTokenService)ScriptBytecodeAdapter.castToType((Object)object, DockerBearerTokenService.class);
        String string = email;
        this.email = ShortTypeHandling.castToString((Object)string);
    }

    public DockerRegistryClient(String address, String email, String username, File passwordFile, long clientTimeoutMillis, int paginateSize, String catalogFile, boolean insecureRegistry) {
        CallSite[] callSiteArray = DockerRegistryClient.$getCallSiteArray();
        this(address, clientTimeoutMillis, paginateSize, catalogFile, insecureRegistry);
        Object object = callSiteArray[22].callConstructor(DockerBearerTokenService.class, (Object)username, (Object)passwordFile);
        this.tokenService = (DockerBearerTokenService)ScriptBytecodeAdapter.castToType((Object)object, DockerBearerTokenService.class);
        String string = email;
        this.email = ShortTypeHandling.castToString((Object)string);
    }

    public String getBasicAuth() {
        CallSite[] callSiteArray = DockerRegistryClient.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[23].callGroovyObjectGetPropertySafe((Object)this.tokenService));
    }

    public String getDigest(String name, String tag) {
        Object object;
        Object object2;
        CallSite[] callSiteArray = DockerRegistryClient.$getCallSiteArray();
        Object response = null;
        response = __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (object2 = callSiteArray[24].callCurrent((GroovyObject)this, (Object)name, (Object)tag)) : (object = this.getManifest(name, tag));
        Object headers = callSiteArray[25].callGetProperty(response);
        public class _getDigest_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getDigest_closure1(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _getDigest_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _getDigest_closure1.$getCallSiteArray();
                return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty(it), (Object)"Docker-Content-Digest");
            }

            public Object doCall() {
                CallSite[] callSiteArray = _getDigest_closure1.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getDigest_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "name";
                return new CallSiteArray(_getDigest_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getDigest_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object digest = callSiteArray[26].callSafe(headers, (Object)new _getDigest_closure1(this, this));
        return ShortTypeHandling.castToString((Object)callSiteArray[27].callGetPropertySafe(digest));
    }

    public Instant getCreationDate(String name, String tag) {
        CallSite[] callSiteArray = DockerRegistryClient.$getCallSiteArray();
        String key = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name, tag}, new String[]{"", ":", ""}));
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[28].call((Object)this.tagDateCache, (Object)key)) && ScriptBytecodeAdapter.compareNotEqual((Object)tag, (Object)"latest")) {
            return (Instant)ScriptBytecodeAdapter.castToType((Object)callSiteArray[29].call((Object)this.tagDateCache, (Object)key), Instant.class);
        }
        Map manifest = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[30].call((Object)this.converter, callSiteArray[31].callGetProperty(callSiteArray[32].callCurrent((GroovyObject)this, (Object)name, (Object)tag)), Map.class);
            manifest = (Map)ScriptBytecodeAdapter.castToType((Object)object, Map.class);
        } else {
            Object object = callSiteArray[33].call((Object)this.converter, callSiteArray[34].callGetProperty(this.getManifest(name, tag)), Map.class);
            manifest = (Map)ScriptBytecodeAdapter.castToType((Object)object, Map.class);
        }
        Instant dateCreated = (Instant)ScriptBytecodeAdapter.castToType((Object)callSiteArray[35].call(Instant.class, callSiteArray[36].callGetProperty(callSiteArray[37].call(callSiteArray[38].callConstructor(Gson.class), callSiteArray[39].callGetProperty(callSiteArray[40].call(callSiteArray[41].callGetProperty((Object)manifest), (Object)0)), Map.class))), Instant.class);
        Instant instant = dateCreated;
        callSiteArray[42].call((Object)this.tagDateCache, (Object)key, (Object)instant);
        return dateCreated;
    }

    /*
     * WARNING - void declaration
     */
    private Object getManifest(String name, String tag) {
        void var2_2;
        Reference name2 = new Reference((Object)name);
        Reference tag2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = DockerRegistryClient.$getCallSiteArray();
        public class _getManifest_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference name;
            private /* synthetic */ Reference tag;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getManifest_closure2(Object _outerInstance, Object _thisObject, Reference name, Reference tag) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _getManifest_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.name = reference2 = name;
                this.tag = reference = tag;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _getManifest_closure2.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), this.name.get(), this.tag.get(), callSiteArray[2].callGroovyObjectGetProperty(callSiteArray[3].callGroovyObjectGetProperty((Object)this)), callSiteArray[4].callGetProperty(DockerRegistryClient.class));
            }

            public String getName() {
                CallSite[] callSiteArray = _getManifest_closure2.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.name.get());
            }

            public String getTag() {
                CallSite[] callSiteArray = _getManifest_closure2.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.tag.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _getManifest_closure2.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getManifest_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "getManifest";
                stringArray[1] = "registryService";
                stringArray[2] = "basicAuthHeader";
                stringArray[3] = "tokenService";
                stringArray[4] = "userAgent";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[5];
                _getManifest_closure2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getManifest_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getManifest_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public class _getManifest_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference name;
            private /* synthetic */ Reference tag;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getManifest_closure3(Object _outerInstance, Object _thisObject, Reference name, Reference tag) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _getManifest_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.name = reference2 = name;
                this.tag = reference = tag;
            }

            public Object doCall(Object token) {
                CallSite[] callSiteArray = _getManifest_closure3.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), this.name.get(), this.tag.get(), token, callSiteArray[2].callGetProperty(DockerRegistryClient.class));
            }

            public String getName() {
                CallSite[] callSiteArray = _getManifest_closure3.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.name.get());
            }

            public String getTag() {
                CallSite[] callSiteArray = _getManifest_closure3.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.tag.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getManifest_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "getManifest";
                stringArray[1] = "registryService";
                stringArray[2] = "userAgent";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _getManifest_closure3.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getManifest_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getManifest_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return callSiteArray[43].callCurrent((GroovyObject)this, (Object)new _getManifest_closure2(this, this, name2, tag2), (Object)new _getManifest_closure3(this, this, name2, tag2), (Object)((String)name2.get()));
    }

    private static String parseLink(retrofit.client.Header header) {
        CallSite[] callSiteArray = DockerRegistryClient.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[44].call(callSiteArray[45].callGetProperty((Object)header), (Object)"link"))) {
            return ShortTypeHandling.castToString(null);
        }
        public class _parseLink_closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _parseLink_closure4(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _parseLink_closure4.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _parseLink_closure4.$getCallSiteArray();
                return callSiteArray[0].call(it);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _parseLink_closure4.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _parseLink_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "trim";
                return new CallSiteArray(_parseLink_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _parseLink_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object links = callSiteArray[46].call(callSiteArray[47].call(callSiteArray[48].callGetProperty((Object)header), (Object)";"), (Object)new _parseLink_closure4(DockerRegistryClient.class, DockerRegistryClient.class));
        public class _parseLink_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _parseLink_closure5(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _parseLink_closure5.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(String tok) {
                CallSite[] callSiteArray = _parseLink_closure5.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].call((Object)tok, (Object)" ", (Object)""), (Object)"rel=\"next\"");
            }

            public Object call(String tok) {
                CallSite[] callSiteArray = _parseLink_closure5.$getCallSiteArray();
                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return callSiteArray[2].callCurrent((GroovyObject)this, (Object)tok);
                }
                return this.doCall(tok);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _parseLink_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "equalsIgnoreCase";
                stringArray[1] = "replace";
                stringArray[2] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _parseLink_closure5.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_parseLink_closure5.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _parseLink_closure5.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[49].call(links, (Object)new _parseLink_closure5(DockerRegistryClient.class, DockerRegistryClient.class)))) {
            return ShortTypeHandling.castToString(null);
        }
        public class _parseLink_closure6
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _parseLink_closure6(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _parseLink_closure6.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(String tok) {
                CallSite[] callSiteArray = _parseLink_closure6.$getCallSiteArray();
                if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return DefaultTypeTransformation.booleanUnbox((Object)tok) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].call((Object)tok, (Object)0), (Object)"<") && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[1].call((Object)tok, callSiteArray[2].call(callSiteArray[3].call((Object)tok), (Object)1)), (Object)">");
                }
                return DefaultTypeTransformation.booleanUnbox((Object)tok) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[4].call((Object)tok, (Object)0), (Object)"<") && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[5].call((Object)tok, callSiteArray[6].call(callSiteArray[7].call((Object)tok), (Object)1)), (Object)">");
            }

            public Object call(String tok) {
                CallSite[] callSiteArray = _parseLink_closure6.$getCallSiteArray();
                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return callSiteArray[8].callCurrent((GroovyObject)this, (Object)tok);
                }
                return this.doCall(tok);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _parseLink_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "getAt";
                stringArray[1] = "getAt";
                stringArray[2] = "minus";
                stringArray[3] = "length";
                stringArray[4] = "getAt";
                stringArray[5] = "getAt";
                stringArray[6] = "minus";
                stringArray[7] = "length";
                stringArray[8] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[9];
                _parseLink_closure6.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_parseLink_closure6.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _parseLink_closure6.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object path = callSiteArray[50].call(links, (Object)new _parseLink_closure6(DockerRegistryClient.class, DockerRegistryClient.class));
        Object link = callSiteArray[51].callSafe(path, (Object)1, callSiteArray[52].call(callSiteArray[53].call(path), (Object)1));
        try {
            Object object;
            Object url = callSiteArray[54].callConstructor(URL.class, link);
            link = object = callSiteArray[55].call(callSiteArray[56].call(url), (Object)1);
        }
        catch (Exception e) {
        }
        return ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[57].call(link, (Object)"/")) ? callSiteArray[58].call(link, (Object)"/", (Object)"") : link));
    }

    private static String findNextLink(List<retrofit.client.Header> headers) {
        CallSite[] callSiteArray = DockerRegistryClient.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox(headers)) {
            return ShortTypeHandling.castToString(null);
        }
        public class _findNextLink_closure7
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _findNextLink_closure7(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _findNextLink_closure7.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object header) {
                CallSite[] callSiteArray = _findNextLink_closure7.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, header);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _findNextLink_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "parseLink";
                return new CallSiteArray(_findNextLink_closure7.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _findNextLink_closure7.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public class _findNextLink_closure8
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _findNextLink_closure8(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _findNextLink_closure8.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _findNextLink_closure8.$getCallSiteArray();
                return it;
            }

            public Object doCall() {
                CallSite[] callSiteArray = _findNextLink_closure8.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _findNextLink_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_findNextLink_closure8.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _findNextLink_closure8.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object paths = callSiteArray[59].call(callSiteArray[60].call(headers, (Object)new _findNextLink_closure7(DockerRegistryClient.class, DockerRegistryClient.class)), (Object)new _findNextLink_closure8(DockerRegistryClient.class, DockerRegistryClient.class));
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (!DefaultTypeTransformation.booleanUnbox((Object)paths) || ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[61].call(paths), (Object)0)) {
                return ShortTypeHandling.castToString(null);
            }
            if (ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[62].call(paths), (Object)1)) {
                throw (Throwable)callSiteArray[63].callConstructor(DockerRegistryOperationException.class, (Object)new GStringImpl(new Object[]{paths}, new String[]{"Ambiguous number of Link headers provided, the following paths were identified: ", ""}));
            }
        } else {
            if (!DefaultTypeTransformation.booleanUnbox((Object)paths) || ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[64].call(paths), (Object)0)) {
                return ShortTypeHandling.castToString(null);
            }
            if (ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[65].call(paths), (Object)1)) {
                throw (Throwable)callSiteArray[66].callConstructor(DockerRegistryOperationException.class, (Object)new GStringImpl(new Object[]{paths}, new String[]{"Ambiguous number of Link headers provided, the following paths were identified: ", ""}));
            }
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[67].call(paths, (Object)0));
    }

    public DockerRegistryCatalog getCatalog(String path) {
        Reference path2 = new Reference((Object)path);
        CallSite[] callSiteArray = DockerRegistryClient.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)this.catalogFile)) {
            Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[68].call((Object)log)) ? callSiteArray[69].call((Object)log, (Object)new GStringImpl(new Object[]{this.catalogFile}, new String[]{"Using catalog list at ", ""})) : null;
            String userDefinedCatalog = ShortTypeHandling.castToString((Object)callSiteArray[70].call(callSiteArray[71].callConstructor(File.class, (Object)this.catalogFile)));
            DockerRegistryCatalog dockerRegistryCatalog = (DockerRegistryCatalog)ScriptBytecodeAdapter.castToType((Object)callSiteArray[72].call(callSiteArray[73].callConstructor(Gson.class), (Object)userDefinedCatalog, DockerRegistryCatalog.class), DockerRegistryCatalog.class);
            try {
                return dockerRegistryCatalog;
            }
            catch (Exception e) {
                throw (Throwable)callSiteArray[74].callConstructor(DockerRegistryOperationException.class, callSiteArray[75].call((Object)new GStringImpl(new Object[]{this.catalogFile}, new String[]{"Unable to read catalog file ", ":"}), callSiteArray[76].call((Object)e)));
            }
        }
        Object response = null;
        try {
            Object object;
            public class _getCatalog_closure9
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference path;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _getCatalog_closure9(Object _outerInstance, Object _thisObject, Reference path) {
                    Reference reference;
                    CallSite[] callSiteArray = _getCatalog_closure9.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.path = reference = path;
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _getCatalog_closure9.$getCallSiteArray();
                    return DefaultTypeTransformation.booleanUnbox((Object)this.path.get()) ? callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), this.path.get(), callSiteArray[2].callGroovyObjectGetProperty(callSiteArray[3].callGroovyObjectGetProperty((Object)this)), callSiteArray[4].callGetProperty(DockerRegistryClient.class)) : callSiteArray[5].call(callSiteArray[6].callGroovyObjectGetProperty((Object)this), callSiteArray[7].callGroovyObjectGetProperty((Object)this), callSiteArray[8].callGroovyObjectGetProperty(callSiteArray[9].callGroovyObjectGetProperty((Object)this)), callSiteArray[10].callGetProperty(DockerRegistryClient.class));
                }

                public String getPath() {
                    CallSite[] callSiteArray = _getCatalog_closure9.$getCallSiteArray();
                    return ShortTypeHandling.castToString((Object)this.path.get());
                }

                public Object doCall() {
                    CallSite[] callSiteArray = _getCatalog_closure9.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getCatalog_closure9.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "get";
                    stringArray[1] = "registryService";
                    stringArray[2] = "basicAuthHeader";
                    stringArray[3] = "tokenService";
                    stringArray[4] = "userAgent";
                    stringArray[5] = "getCatalog";
                    stringArray[6] = "registryService";
                    stringArray[7] = "paginateSize";
                    stringArray[8] = "basicAuthHeader";
                    stringArray[9] = "tokenService";
                    stringArray[10] = "userAgent";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[11];
                    _getCatalog_closure9.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_getCatalog_closure9.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _getCatalog_closure9.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            public class _getCatalog_closure10
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference path;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _getCatalog_closure10(Object _outerInstance, Object _thisObject, Reference path) {
                    Reference reference;
                    CallSite[] callSiteArray = _getCatalog_closure10.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.path = reference = path;
                }

                public Object doCall(Object token) {
                    CallSite[] callSiteArray = _getCatalog_closure10.$getCallSiteArray();
                    return DefaultTypeTransformation.booleanUnbox((Object)this.path.get()) ? callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), this.path.get(), token, callSiteArray[2].callGetProperty(DockerRegistryClient.class)) : callSiteArray[3].call(callSiteArray[4].callGroovyObjectGetProperty((Object)this), callSiteArray[5].callGroovyObjectGetProperty((Object)this), token, callSiteArray[6].callGetProperty(DockerRegistryClient.class));
                }

                public String getPath() {
                    CallSite[] callSiteArray = _getCatalog_closure10.$getCallSiteArray();
                    return ShortTypeHandling.castToString((Object)this.path.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getCatalog_closure10.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "get";
                    stringArray[1] = "registryService";
                    stringArray[2] = "userAgent";
                    stringArray[3] = "getCatalog";
                    stringArray[4] = "registryService";
                    stringArray[5] = "paginateSize";
                    stringArray[6] = "userAgent";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[7];
                    _getCatalog_closure10.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_getCatalog_closure10.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _getCatalog_closure10.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            response = object = callSiteArray[77].callCurrent((GroovyObject)this, (Object)new _getCatalog_closure9(this, this, path2), (Object)new _getCatalog_closure10(this, this, path2), (Object)"_catalog");
        }
        catch (Exception e) {
            Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[78].call((Object)log)) ? callSiteArray[79].call((Object)log, callSiteArray[80].call((Object)new GStringImpl(new Object[]{(String)path2.get()}, new String[]{"Error encountered during catalog of ", ""}), callSiteArray[81].call((Object)e))) : null;
            DockerRegistryCatalog dockerRegistryCatalog = (DockerRegistryCatalog)ScriptBytecodeAdapter.castToType((Object)callSiteArray[82].callConstructor(DockerRegistryCatalog.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"repositories", ScriptBytecodeAdapter.createList((Object[])new Object[0])})), DockerRegistryCatalog.class);
            return dockerRegistryCatalog;
        }
        Object nextPath = callSiteArray[83].callStatic(DockerRegistryClient.class, callSiteArray[84].callGetPropertySafe(response));
        DockerRegistryCatalog catalog = (DockerRegistryCatalog)ScriptBytecodeAdapter.castToType((Object)callSiteArray[85].call((Object)this.converter, callSiteArray[86].callGetProperty(response), DockerRegistryCatalog.class), DockerRegistryCatalog.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)nextPath)) {
            Object nextCatalog = callSiteArray[87].callCurrent((GroovyObject)this, nextPath);
            callSiteArray[88].call(callSiteArray[89].callGetProperty((Object)catalog), callSiteArray[90].callGetProperty(nextCatalog));
        }
        return (DockerRegistryCatalog)ScriptBytecodeAdapter.castToType((Object)catalog, DockerRegistryCatalog.class);
    }

    /*
     * WARNING - void declaration
     */
    public DockerRegistryTags getTags(String repository, String path) {
        void var2_2;
        Reference repository2 = new Reference((Object)repository);
        Reference path2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = DockerRegistryClient.$getCallSiteArray();
        public class _getTags_closure11
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference path;
            private /* synthetic */ Reference repository;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getTags_closure11(Object _outerInstance, Object _thisObject, Reference path, Reference repository) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _getTags_closure11.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.path = reference2 = path;
                this.repository = reference = repository;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _getTags_closure11.$getCallSiteArray();
                return DefaultTypeTransformation.booleanUnbox((Object)this.path.get()) ? callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), this.path.get(), callSiteArray[2].callGroovyObjectGetProperty(callSiteArray[3].callGroovyObjectGetProperty((Object)this)), callSiteArray[4].callGetProperty(DockerRegistryClient.class)) : callSiteArray[5].call(callSiteArray[6].callGroovyObjectGetProperty((Object)this), this.repository.get(), callSiteArray[7].callGroovyObjectGetProperty(callSiteArray[8].callGroovyObjectGetProperty((Object)this)), callSiteArray[9].callGetProperty(DockerRegistryClient.class));
            }

            public String getPath() {
                CallSite[] callSiteArray = _getTags_closure11.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.path.get());
            }

            public String getRepository() {
                CallSite[] callSiteArray = _getTags_closure11.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.repository.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _getTags_closure11.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getTags_closure11.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "get";
                stringArray[1] = "registryService";
                stringArray[2] = "basicAuthHeader";
                stringArray[3] = "tokenService";
                stringArray[4] = "userAgent";
                stringArray[5] = "getTags";
                stringArray[6] = "registryService";
                stringArray[7] = "basicAuthHeader";
                stringArray[8] = "tokenService";
                stringArray[9] = "userAgent";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[10];
                _getTags_closure11.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getTags_closure11.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getTags_closure11.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public class _getTags_closure12
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference path;
            private /* synthetic */ Reference repository;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getTags_closure12(Object _outerInstance, Object _thisObject, Reference path, Reference repository) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _getTags_closure12.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.path = reference2 = path;
                this.repository = reference = repository;
            }

            public Object doCall(Object token) {
                CallSite[] callSiteArray = _getTags_closure12.$getCallSiteArray();
                return DefaultTypeTransformation.booleanUnbox((Object)this.path.get()) ? callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), this.path.get(), token, callSiteArray[2].callGetProperty(DockerRegistryClient.class)) : callSiteArray[3].call(callSiteArray[4].callGroovyObjectGetProperty((Object)this), this.repository.get(), token, callSiteArray[5].callGetProperty(DockerRegistryClient.class));
            }

            public String getPath() {
                CallSite[] callSiteArray = _getTags_closure12.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.path.get());
            }

            public String getRepository() {
                CallSite[] callSiteArray = _getTags_closure12.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.repository.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getTags_closure12.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "get";
                stringArray[1] = "registryService";
                stringArray[2] = "userAgent";
                stringArray[3] = "getTags";
                stringArray[4] = "registryService";
                stringArray[5] = "userAgent";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[6];
                _getTags_closure12.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getTags_closure12.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getTags_closure12.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object response = callSiteArray[91].callCurrent((GroovyObject)this, (Object)new _getTags_closure11(this, this, path2, repository2), (Object)new _getTags_closure12(this, this, path2, repository2), (Object)((String)repository2.get()));
        Object nextPath = callSiteArray[92].callStatic(DockerRegistryClient.class, callSiteArray[93].callGetPropertySafe(response));
        DockerRegistryTags tags = (DockerRegistryTags)ScriptBytecodeAdapter.castToType((Object)callSiteArray[94].call((Object)this.converter, callSiteArray[95].callGetProperty(response), DockerRegistryTags.class), DockerRegistryTags.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)nextPath)) {
            Object nextTags = callSiteArray[96].callCurrent((GroovyObject)this, (Object)((String)repository2.get()), nextPath);
            callSiteArray[97].call(callSiteArray[98].callGetProperty((Object)tags), callSiteArray[99].callGetProperty(nextTags));
        }
        return (DockerRegistryTags)ScriptBytecodeAdapter.castToType((Object)tags, DockerRegistryTags.class);
    }

    /*
     * Unable to fully structure code
     */
    public void checkV2Availability() {
        var1_1 = DockerRegistryClient.$getCallSiteArray();
        try {
            if (DockerRegistryClient.__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                var1_1[100].callCurrent((GroovyObject)this);
            } else {
                this.doCheckV2Availability();
            }
        }
        catch (RetrofitError error) {
            if (BytecodeInterface8.isOrigInt() && BytecodeInterface8.isOrigZ() && !DockerRegistryClient.__$stMC && !BytecodeInterface8.disabledStandardMetaClass()) ** GOTO lbl18
            if (!(DefaultTypeTransformation.booleanUnbox((Object)var1_1[101].callGroovyObjectGetProperty((Object)this.tokenService)) == false != false && ScriptBytecodeAdapter.compareEqual((Object)var1_1[102].callGetPropertySafe(var1_1[103].callGetProperty((Object)error)), (Object)401) != false)) ** GOTO lbl23
            return;
lbl18:
            // 1 sources

            if (!(DefaultTypeTransformation.booleanUnbox((Object)var1_1[104].callGroovyObjectGetProperty((Object)this.tokenService)) == false != false && ScriptBytecodeAdapter.compareEqual((Object)var1_1[105].callGetPropertySafe(var1_1[106].callGetProperty((Object)error)), (Object)401) != false)) ** GOTO lbl23
            return;
lbl23:
            // 2 sources

            response = (Response)ScriptBytecodeAdapter.castToType((Object)var1_1[107].callCurrent((GroovyObject)this, var1_1[108].callGroovyObjectGetProperty((Object)this.tokenService)), Response.class);
            if (DefaultTypeTransformation.booleanUnbox((Object)response) == false) {
                var1_1[109].call((Object)DockerRegistryClient.LOG, (Object)"checkV2Availability", (Object)error);
                throw (Throwable)error;
            }
        }
    }

    private Response doCheckV2Availability(String basicAuthHeader) {
        Reference basicAuthHeader2 = new Reference((Object)basicAuthHeader);
        CallSite[] callSiteArray = DockerRegistryClient.$getCallSiteArray();
        public class _doCheckV2Availability_closure13
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference basicAuthHeader;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _doCheckV2Availability_closure13(Object _outerInstance, Object _thisObject, Reference basicAuthHeader) {
                Reference reference;
                CallSite[] callSiteArray = _doCheckV2Availability_closure13.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.basicAuthHeader = reference = basicAuthHeader;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _doCheckV2Availability_closure13.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), this.basicAuthHeader.get(), callSiteArray[2].callGetProperty(DockerRegistryClient.class));
            }

            public String getBasicAuthHeader() {
                CallSite[] callSiteArray = _doCheckV2Availability_closure13.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.basicAuthHeader.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _doCheckV2Availability_closure13.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _doCheckV2Availability_closure13.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "checkVersion";
                stringArray[1] = "registryService";
                stringArray[2] = "userAgent";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _doCheckV2Availability_closure13.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_doCheckV2Availability_closure13.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _doCheckV2Availability_closure13.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public class _doCheckV2Availability_closure14
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _doCheckV2Availability_closure14(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _doCheckV2Availability_closure14.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object token) {
                CallSite[] callSiteArray = _doCheckV2Availability_closure14.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), token, callSiteArray[2].callGetProperty(DockerRegistryClient.class));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _doCheckV2Availability_closure14.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "checkVersion";
                stringArray[1] = "registryService";
                stringArray[2] = "userAgent";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _doCheckV2Availability_closure14.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_doCheckV2Availability_closure14.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _doCheckV2Availability_closure14.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (Response)ScriptBytecodeAdapter.castToType((Object)callSiteArray[110].callCurrent((GroovyObject)this, (Object)new _doCheckV2Availability_closure13(this, this, basicAuthHeader2), (Object)new _doCheckV2Availability_closure14(this, this), (Object)"v2 version check"), Response.class);
    }

    /*
     * Exception decompiling
     */
    public Response request(Closure<Response> withoutToken, Closure<Response> withToken, String target) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != DockerRegistryClient.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        CallSite[] callSiteArray = DockerRegistryClient.$getCallSiteArray();
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(DockerRegistryClient.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        CallSite[] callSiteArray = DockerRegistryClient.$getCallSiteArray();
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, DockerRegistryClient.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        CallSite[] callSiteArray = DockerRegistryClient.$getCallSiteArray();
        return ScriptBytecodeAdapter.getGroovyObjectProperty(DockerRegistryClient.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public DockerRegistryCatalog getCatalog() {
        CallSite[] callSiteArray = DockerRegistryClient.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.getCatalog(null);
        }
        return this.getCatalog(null);
    }

    public DockerRegistryTags getTags(String repository) {
        Reference repository2 = new Reference((Object)repository);
        CallSite[] callSiteArray = DockerRegistryClient.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.getTags((String)repository2.get(), null);
        }
        return this.getTags((String)repository2.get(), null);
    }

    private Response doCheckV2Availability() {
        CallSite[] callSiteArray = DockerRegistryClient.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.doCheckV2Availability(null);
        }
        return this.doCheckV2Availability(null);
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Object object = DockerRegistryClient.$getCallSiteArray()[145].call(LoggerFactory.class, DockerRegistryClient.class);
        LOG = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
        Object object2 = DockerRegistryClient.$getCallSiteArray()[146].call(DockerUserAgent.class);
        userAgent = ShortTypeHandling.castToString((Object)object2);
        Object object3 = DockerRegistryClient.$getCallSiteArray()[147].call(LoggerFactory.class, (Object)"com.netflix.spinnaker.clouddriver.docker.registry.api.v2.client.DockerRegistryClient");
        log = (Logger)ScriptBytecodeAdapter.castToType((Object)object3, Logger.class);
    }

    public DockerBearerTokenService getTokenService() {
        return this.tokenService;
    }

    public void setTokenService(DockerBearerTokenService dockerBearerTokenService) {
        this.tokenService = dockerBearerTokenService;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String string) {
        this.address = string;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String string) {
        this.email = string;
    }

    public DockerRegistryService getRegistryService() {
        return this.registryService;
    }

    public void setRegistryService(DockerRegistryService dockerRegistryService) {
        this.registryService = dockerRegistryService;
    }

    public GsonConverter getConverter() {
        return this.converter;
    }

    public void setConverter(GsonConverter gsonConverter) {
        this.converter = gsonConverter;
    }

    public String getCatalogFile() {
        return this.catalogFile;
    }

    public void setCatalogFile(String string) {
        this.catalogFile = string;
    }

    public static String getUserAgent() {
        return userAgent;
    }

    public final int getPaginateSize() {
        return this.paginateSize;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "<$constructor$>";
        stringArray[1] = "<$constructor$>";
        stringArray[2] = "setReadTimeout";
        stringArray[3] = "MILLISECONDS";
        stringArray[4] = "getInstance";
        stringArray[5] = "<$constructor$>";
        stringArray[6] = "init";
        stringArray[7] = "<$constructor$>";
        stringArray[8] = "setSslSocketFactory";
        stringArray[9] = "getSocketFactory";
        stringArray[10] = "create";
        stringArray[11] = "build";
        stringArray[12] = "setLogLevel";
        stringArray[13] = "setClient";
        stringArray[14] = "setEndpoint";
        stringArray[15] = "<$constructor$>";
        stringArray[16] = "<$constructor$>";
        stringArray[17] = "NONE";
        stringArray[18] = "<$constructor$>";
        stringArray[19] = "create";
        stringArray[20] = "<$constructor$>";
        stringArray[21] = "<$constructor$>";
        stringArray[22] = "<$constructor$>";
        stringArray[23] = "basicAuth";
        stringArray[24] = "getManifest";
        stringArray[25] = "headers";
        stringArray[26] = "find";
        stringArray[27] = "value";
        stringArray[28] = "containsKey";
        stringArray[29] = "getAt";
        stringArray[30] = "fromBody";
        stringArray[31] = "body";
        stringArray[32] = "getManifest";
        stringArray[33] = "fromBody";
        stringArray[34] = "body";
        stringArray[35] = "parse";
        stringArray[36] = "created";
        stringArray[37] = "fromJson";
        stringArray[38] = "<$constructor$>";
        stringArray[39] = "v1Compatibility";
        stringArray[40] = "getAt";
        stringArray[41] = "history";
        stringArray[42] = "putAt";
        stringArray[43] = "request";
        stringArray[44] = "equalsIgnoreCase";
        stringArray[45] = "name";
        stringArray[46] = "collect";
        stringArray[47] = "split";
        stringArray[48] = "value";
        stringArray[49] = "findAll";
        stringArray[50] = "find";
        stringArray[51] = "substring";
        stringArray[52] = "minus";
        stringArray[53] = "length";
        stringArray[54] = "<$constructor$>";
        stringArray[55] = "substring";
        stringArray[56] = "getFile";
        stringArray[57] = "startsWith";
        stringArray[58] = "replaceFirst";
        stringArray[59] = "findAll";
        stringArray[60] = "collect";
        stringArray[61] = "size";
        stringArray[62] = "size";
        stringArray[63] = "<$constructor$>";
        stringArray[64] = "size";
        stringArray[65] = "size";
        stringArray[66] = "<$constructor$>";
        stringArray[67] = "getAt";
        stringArray[68] = "isInfoEnabled";
        stringArray[69] = "info";
        stringArray[70] = "getText";
        stringArray[71] = "<$constructor$>";
        stringArray[72] = "fromJson";
        stringArray[73] = "<$constructor$>";
        stringArray[74] = "<$constructor$>";
        stringArray[75] = "plus";
        stringArray[76] = "getMessage";
        stringArray[77] = "request";
        stringArray[78] = "isWarnEnabled";
        stringArray[79] = "warn";
        stringArray[80] = "plus";
        stringArray[81] = "getMessage";
        stringArray[82] = "<$constructor$>";
        stringArray[83] = "findNextLink";
        stringArray[84] = "headers";
        stringArray[85] = "fromBody";
        stringArray[86] = "body";
        stringArray[87] = "getCatalog";
        stringArray[88] = "addAll";
        stringArray[89] = "repositories";
        stringArray[90] = "repositories";
        stringArray[91] = "request";
        stringArray[92] = "findNextLink";
        stringArray[93] = "headers";
        stringArray[94] = "fromBody";
        stringArray[95] = "body";
        stringArray[96] = "getTags";
        stringArray[97] = "addAll";
        stringArray[98] = "tags";
        stringArray[99] = "tags";
        stringArray[100] = "doCheckV2Availability";
        stringArray[101] = "basicAuthHeader";
        stringArray[102] = "status";
        stringArray[103] = "response";
        stringArray[104] = "basicAuthHeader";
        stringArray[105] = "status";
        stringArray[106] = "response";
        stringArray[107] = "doCheckV2Availability";
        stringArray[108] = "basicAuthHeader";
        stringArray[109] = "error";
        stringArray[110] = "request";
        stringArray[111] = "getToken";
        stringArray[112] = "bearer_token";
        stringArray[113] = "token";
        stringArray[114] = "access_token";
        stringArray[115] = "call";
        stringArray[116] = "call";
        stringArray[117] = "status";
        stringArray[118] = "response";
        stringArray[119] = "contains";
        stringArray[120] = "forEach";
        stringArray[121] = "headers";
        stringArray[122] = "response";
        stringArray[123] = "isWarnEnabled";
        stringArray[124] = "warn";
        stringArray[125] = "clearToken";
        stringArray[126] = "equalsIgnoreCase";
        stringArray[127] = "substring";
        stringArray[128] = "length";
        stringArray[129] = "getToken";
        stringArray[130] = "substring";
        stringArray[131] = "length";
        stringArray[132] = "bearer_token";
        stringArray[133] = "token";
        stringArray[134] = "access_token";
        stringArray[135] = "call";
        stringArray[136] = "equalsIgnoreCase";
        stringArray[137] = "substring";
        stringArray[138] = "length";
        stringArray[139] = "clearToken";
        stringArray[140] = "clearToken";
        stringArray[141] = "<$constructor$>";
        stringArray[142] = "isErrorEnabled";
        stringArray[143] = "error";
        stringArray[144] = "getMessage";
        stringArray[145] = "getLogger";
        stringArray[146] = "getUserAgent";
        stringArray[147] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[148];
        DockerRegistryClient.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(DockerRegistryClient.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = DockerRegistryClient.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    public static class Builder
    implements GroovyObject {
        private String address;
        private String email;
        private String username;
        private String password;
        private String passwordCommand;
        private File passwordFile;
        private File dockerconfigFile;
        private long clientTimeoutMillis;
        private int paginateSize;
        private String catalogFile;
        private boolean insecureRegistry;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public Builder() {
            MetaClass metaClass;
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public Builder address(String address) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            String string = address;
            this.address = ShortTypeHandling.castToString((Object)string);
            return this;
        }

        public Builder email(String email) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            String string = email;
            this.email = ShortTypeHandling.castToString((Object)string);
            return this;
        }

        public Builder username(String username) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            String string = username;
            this.username = ShortTypeHandling.castToString((Object)string);
            return this;
        }

        public Builder password(String password) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            String string = password;
            this.password = ShortTypeHandling.castToString((Object)string);
            return this;
        }

        public Builder passwordCommand(String passwordCommand) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            String string = passwordCommand;
            this.passwordCommand = ShortTypeHandling.castToString((Object)string);
            return this;
        }

        public Builder passwordFile(File passwordFile) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            File file = passwordFile;
            this.passwordFile = (File)ScriptBytecodeAdapter.castToType((Object)file, File.class);
            return this;
        }

        public Builder dockerconfigFile(File dockerconfigFile) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            File file = dockerconfigFile;
            this.dockerconfigFile = (File)ScriptBytecodeAdapter.castToType((Object)file, File.class);
            return this;
        }

        public Builder clientTimeoutMillis(long clientTimeoutMillis) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            long l = clientTimeoutMillis;
            this.clientTimeoutMillis = DefaultTypeTransformation.longUnbox((Object)l);
            return this;
        }

        public Builder paginateSize(int paginateSize) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            int n = paginateSize;
            this.paginateSize = DefaultTypeTransformation.intUnbox((Object)n);
            return this;
        }

        public Builder catalogFile(String catalogFile) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            String string = catalogFile;
            this.catalogFile = ShortTypeHandling.castToString((Object)string);
            return this;
        }

        public Builder insecureRegistry(boolean insecureRegistry) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            boolean bl = insecureRegistry;
            this.insecureRegistry = DefaultTypeTransformation.booleanUnbox((Object)bl);
            return this;
        }

        public DockerRegistryClient build() {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                if (DefaultTypeTransformation.booleanUnbox((Object)this.password) && DefaultTypeTransformation.booleanUnbox((Object)this.passwordFile) || DefaultTypeTransformation.booleanUnbox((Object)this.password) && DefaultTypeTransformation.booleanUnbox((Object)this.passwordCommand) || DefaultTypeTransformation.booleanUnbox((Object)this.passwordFile) && DefaultTypeTransformation.booleanUnbox((Object)this.passwordCommand)) {
                    throw (Throwable)callSiteArray[0].callConstructor(IllegalArgumentException.class, (Object)"Error, at most one of \"password\", \"passwordFile\", \"passwordCommand\" or \"dockerconfigFile\" can be specified");
                }
            } else if (DefaultTypeTransformation.booleanUnbox((Object)this.password) && DefaultTypeTransformation.booleanUnbox((Object)this.passwordFile) || DefaultTypeTransformation.booleanUnbox((Object)this.password) && DefaultTypeTransformation.booleanUnbox((Object)this.passwordCommand) || DefaultTypeTransformation.booleanUnbox((Object)this.passwordFile) && DefaultTypeTransformation.booleanUnbox((Object)this.passwordCommand)) {
                throw (Throwable)callSiteArray[1].callConstructor(IllegalArgumentException.class, (Object)"Error, at most one of \"password\", \"passwordFile\", \"passwordCommand\" or \"dockerconfigFile\" can be specified");
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)this.password) || DefaultTypeTransformation.booleanUnbox((Object)this.passwordCommand)) {
                return (DockerRegistryClient)ScriptBytecodeAdapter.castToType((Object)callSiteArray[2].callConstructor(DockerRegistryClient.class, ArrayUtil.createArray((Object)this.address, (Object)this.email, (Object)this.username, (Object)this.password, (Object)this.passwordCommand, (Object)this.clientTimeoutMillis, (Object)this.paginateSize, (Object)this.catalogFile, (Object)this.insecureRegistry)), DockerRegistryClient.class);
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)this.passwordFile)) {
                return (DockerRegistryClient)ScriptBytecodeAdapter.castToType((Object)callSiteArray[3].callConstructor(DockerRegistryClient.class, ArrayUtil.createArray((Object)this.address, (Object)this.email, (Object)this.username, (Object)this.passwordFile, (Object)this.clientTimeoutMillis, (Object)this.paginateSize, (Object)this.catalogFile, (Object)this.insecureRegistry)), DockerRegistryClient.class);
            }
            return (DockerRegistryClient)ScriptBytecodeAdapter.castToType((Object)callSiteArray[4].callConstructor(DockerRegistryClient.class, ArrayUtil.createArray((Object)this.address, (Object)this.clientTimeoutMillis, (Object)this.paginateSize, (Object)this.catalogFile, (Object)this.insecureRegistry)), DockerRegistryClient.class);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != Builder.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(Builder.class, DockerRegistryClient.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(Builder.class, DockerRegistryClient.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, DockerRegistryClient.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, DockerRegistryClient.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(Builder.class, DockerRegistryClient.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = Builder.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(Builder.class, DockerRegistryClient.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        public String getAddress() {
            return this.address;
        }

        public void setAddress(String string) {
            this.address = string;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String string) {
            this.email = string;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String string) {
            this.username = string;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String string) {
            this.password = string;
        }

        public String getPasswordCommand() {
            return this.passwordCommand;
        }

        public void setPasswordCommand(String string) {
            this.passwordCommand = string;
        }

        public File getPasswordFile() {
            return this.passwordFile;
        }

        public void setPasswordFile(File file) {
            this.passwordFile = file;
        }

        public File getDockerconfigFile() {
            return this.dockerconfigFile;
        }

        public void setDockerconfigFile(File file) {
            this.dockerconfigFile = file;
        }

        public long getClientTimeoutMillis() {
            return this.clientTimeoutMillis;
        }

        public void setClientTimeoutMillis(long l) {
            this.clientTimeoutMillis = l;
        }

        public int getPaginateSize() {
            return this.paginateSize;
        }

        public void setPaginateSize(int n) {
            this.paginateSize = n;
        }

        public String getCatalogFile() {
            return this.catalogFile;
        }

        public void setCatalogFile(String string) {
            this.catalogFile = string;
        }

        public boolean getInsecureRegistry() {
            return this.insecureRegistry;
        }

        public boolean isInsecureRegistry() {
            return this.insecureRegistry;
        }

        public void setInsecureRegistry(boolean bl) {
            this.insecureRegistry = bl;
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "<$constructor$>";
            stringArray[1] = "<$constructor$>";
            stringArray[2] = "<$constructor$>";
            stringArray[3] = "<$constructor$>";
            stringArray[4] = "<$constructor$>";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[5];
            Builder.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(Builder.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = Builder.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public interface DockerRegistryService {
        @GET(value="/v2/{repository}/tags/list")
        @Headers(value={"Docker-Distribution-API-Version: registry/2.0"})
        public Response getTags(@Path(encode=false, value="repository") String var1, @Header(value="Authorization") String var2, @Header(value="User-Agent") String var3);

        @GET(value="/v2/{name}/manifests/{reference}")
        @Headers(value={"Docker-Distribution-API-Version: registry/2.0"})
        public Response getManifest(@Path(encode=false, value="name") String var1, @Path(encode=false, value="reference") String var2, @Header(value="Authorization") String var3, @Header(value="User-Agent") String var4);

        @GET(value="/v2/_catalog")
        @Headers(value={"Docker-Distribution-API-Version: registry/2.0"})
        public Response getCatalog(@Query(value="n") int var1, @Header(value="Authorization") String var2, @Header(value="User-Agent") String var3);

        @GET(value="/{path}")
        @Headers(value={"Docker-Distribution-API-Version: registry/2.0"})
        public Response get(@Path(encode=false, value="path") String var1, @Header(value="Authorization") String var2, @Header(value="User-Agent") String var3);

        @GET(value="/v2/")
        @Headers(value={"User-Agent: Spinnaker-Clouddriver", "Docker-Distribution-API-Version: registry/2.0"})
        public Response checkVersion(@Header(value="Authorization") String var1, @Header(value="User-Agent") String var2);
    }
}

