/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v1.deploy;

import com.netflix.frigga.NameValidation;
import com.netflix.frigga.Names;
import com.netflix.spinnaker.clouddriver.kubernetes.v1.deploy.description.servergroup.KubernetesImageDescription;
import com.netflix.spinnaker.clouddriver.kubernetes.v1.deploy.exception.KubernetesIllegalArgumentException;
import com.netflix.spinnaker.clouddriver.kubernetes.v1.security.KubernetesV1Credentials;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.apps.ReplicaSet;
import io.fabric8.kubernetes.api.model.batch.Job;
import java.lang.ref.SoftReference;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.springframework.beans.factory.annotation.Value;

public class KubernetesUtil
implements GroovyObject {
    private static String SECURITY_GROUP_LABEL_PREFIX;
    private static String LOAD_BALANCER_LABEL_PREFIX;
    private static String SERVER_GROUP_LABEL;
    private static String DEPRECATED_SERVER_GROUP_KIND;
    private static String SERVER_GROUP_KIND;
    private static String DEPLOYMENT_KIND;
    private static String JOB_LABEL;
    private static String CONTROLLERS_STATEFULSET_KIND;
    private static String CONTROLLERS_DAEMONSET_KIND;
    @Value(value="kubernetes.defaultRegistry:gcr.io")
    private static String DEFAULT_REGISTRY;
    private static int SECURITY_GROUP_LABEL_PREFIX_LENGTH;
    private static int LOAD_BALANCER_LABEL_PREFIX_LENGTH;
    private static String ENABLE_DISABLE_ANNOTATION;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public KubernetesUtil() {
        MetaClass metaClass;
        CallSite[] callSiteArray = KubernetesUtil.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static String getNextSequence(String clusterName, String namespace, KubernetesV1Credentials credentials) {
        Reference clusterName2 = new Reference((Object)clusterName);
        CallSite[] callSiteArray = KubernetesUtil.$getCallSiteArray();
        Reference maxSeqNumber = new Reference((Object)-1);
        Object replicationControllers = callSiteArray[0].call(callSiteArray[1].callGetProperty((Object)credentials), (Object)namespace);
        public class _getNextSequence_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference clusterName;
            private /* synthetic */ Reference maxSeqNumber;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getNextSequence_closure1(Object _outerInstance, Object _thisObject, Reference clusterName, Reference maxSeqNumber) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _getNextSequence_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.clusterName = reference2 = clusterName;
                this.maxSeqNumber = reference = maxSeqNumber;
            }

            public Object doCall(Object replicationController) {
                CallSite[] callSiteArray = _getNextSequence_closure1.$getCallSiteArray();
                Object names = callSiteArray[0].call(Names.class, callSiteArray[1].call(callSiteArray[2].call(replicationController)));
                if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[3].callGetProperty(names), (Object)this.clusterName.get())) {
                    Object object = callSiteArray[4].call(Math.class, this.maxSeqNumber.get(), callSiteArray[5].callGetProperty(names));
                    this.maxSeqNumber.set(object);
                    return object;
                }
                return null;
            }

            public String getClusterName() {
                CallSite[] callSiteArray = _getNextSequence_closure1.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.clusterName.get());
            }

            public Object getMaxSeqNumber() {
                CallSite[] callSiteArray = _getNextSequence_closure1.$getCallSiteArray();
                return this.maxSeqNumber.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getNextSequence_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "parseName";
                stringArray[1] = "getName";
                stringArray[2] = "getMetadata";
                stringArray[3] = "cluster";
                stringArray[4] = "max";
                stringArray[5] = "sequence";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[6];
                _getNextSequence_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getNextSequence_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getNextSequence_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[2].call(replicationControllers, (Object)new _getNextSequence_closure1(KubernetesUtil.class, KubernetesUtil.class, clusterName2, maxSeqNumber));
        CallSite callSite = callSiteArray[3];
        Object object = callSiteArray[4].call(maxSeqNumber.get());
        maxSeqNumber.set(object);
        return ShortTypeHandling.castToString((Object)callSite.call(String.class, (Object)"%03d", object));
    }

    public static List<String> getImagePullSecrets(ReplicationController rc) {
        CallSite[] callSiteArray = KubernetesUtil.$getCallSiteArray();
        public class _getImagePullSecrets_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getImagePullSecrets_closure2(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _getImagePullSecrets_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _getImagePullSecrets_closure2.$getCallSiteArray();
                return callSiteArray[0].callGetProperty(it);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _getImagePullSecrets_closure2.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getImagePullSecrets_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "name";
                return new CallSiteArray(_getImagePullSecrets_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getImagePullSecrets_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[5].callSafe(callSiteArray[6].callGetPropertySafe(callSiteArray[7].callGetPropertySafe(callSiteArray[8].callGetPropertySafe(callSiteArray[9].callGetProperty((Object)rc)))), (Object)new _getImagePullSecrets_closure2(KubernetesUtil.class, KubernetesUtil.class)), List.class);
    }

    private static String extractRegistry(String image, KubernetesImageDescription description) {
        CallSite[] callSiteArray = KubernetesUtil.$getCallSiteArray();
        Object index = callSiteArray[10].call((Object)image, (Object)"/");
        if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)index, (Object)0)) {
            Object sPrefix = callSiteArray[11].call((Object)image, (Object)0, index);
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[12].call(sPrefix, (Object)"localhost")) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[13].call(sPrefix, (Object)"."))) {
                Object object = sPrefix;
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, KubernetesUtil.class, (GroovyObject)description, (String)"registry");
                Object object2 = callSiteArray[14].call((Object)image, callSiteArray[15].call(index, (Object)1));
                image = ShortTypeHandling.castToString((Object)object2);
            }
        }
        return image;
    }

    private static String extractDigestOrTag(String image, KubernetesImageDescription description) {
        CallSite[] callSiteArray = KubernetesUtil.$getCallSiteArray();
        Object digestIndex = callSiteArray[16].call((Object)image, (Object)"@");
        if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)digestIndex, (Object)0)) {
            Object object = callSiteArray[17].call((Object)image, callSiteArray[18].call(digestIndex, (Object)1));
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, KubernetesUtil.class, (GroovyObject)description, (String)"digest");
            Object object2 = callSiteArray[19].call((Object)image, (Object)0, digestIndex);
            image = ShortTypeHandling.castToString((Object)object2);
        } else {
            Object tagIndex = callSiteArray[20].call((Object)image, (Object)":");
            if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)tagIndex, (Object)0)) {
                Object object = callSiteArray[21].call((Object)image, callSiteArray[22].call(tagIndex, (Object)1));
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, KubernetesUtil.class, (GroovyObject)description, (String)"tag");
                Object object3 = callSiteArray[23].call((Object)image, (Object)0, tagIndex);
                image = ShortTypeHandling.castToString((Object)object3);
            }
        }
        return image;
    }

    private static void populateFieldsFromUri(KubernetesImageDescription image) {
        CallSite[] callSiteArray = KubernetesUtil.$getCallSiteArray();
        Object uri = callSiteArray[24].callGroovyObjectGetProperty((Object)image);
        if (DefaultTypeTransformation.booleanUnbox((Object)uri)) {
            Object object;
            Object object2;
            uri = object2 = callSiteArray[25].callStatic(KubernetesUtil.class, uri, (Object)image);
            uri = object = callSiteArray[26].callStatic(KubernetesUtil.class, uri, (Object)image);
            Object object3 = uri;
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object3, KubernetesUtil.class, (GroovyObject)image, (String)"repository");
        }
    }

    public static KubernetesImageDescription buildImageDescription(String image) {
        CallSite[] callSiteArray = KubernetesUtil.$getCallSiteArray();
        Object result = callSiteArray[27].callConstructor(KubernetesImageDescription.class);
        String string = image;
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)result, (String)"uri");
        callSiteArray[28].callStatic(KubernetesUtil.class, result);
        return (KubernetesImageDescription)ScriptBytecodeAdapter.castToType((Object)result, KubernetesImageDescription.class);
    }

    public static Void normalizeImageDescription(KubernetesImageDescription image) {
        CallSite[] callSiteArray = KubernetesUtil.$getCallSiteArray();
        callSiteArray[29].callStatic(KubernetesUtil.class, (Object)image);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[30].callGroovyObjectGetProperty((Object)image))) {
            String string = DEFAULT_REGISTRY;
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string, KubernetesUtil.class, (GroovyObject)image, (String)"registry");
        }
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[31].callGroovyObjectGetProperty((Object)image)) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[32].callGroovyObjectGetProperty((Object)image))) {
                String string = "latest";
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string, KubernetesUtil.class, (GroovyObject)image, (String)"tag");
            }
        } else if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[33].callGroovyObjectGetProperty((Object)image)) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[34].callGroovyObjectGetProperty((Object)image))) {
            String string = "latest";
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string, KubernetesUtil.class, (GroovyObject)image, (String)"tag");
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[35].callGroovyObjectGetProperty((Object)image))) {
            throw (Throwable)callSiteArray[36].callConstructor(IllegalArgumentException.class, (Object)"Image descriptions must provide a repository.");
        }
        return (Void)ScriptBytecodeAdapter.castToType(null, Void.class);
    }

    public static String getImageId(KubernetesImageDescription image) {
        CallSite[] callSiteArray = KubernetesUtil.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[37].callStatic(KubernetesUtil.class, callSiteArray[38].callGroovyObjectGetProperty((Object)image), callSiteArray[39].callGroovyObjectGetProperty((Object)image), callSiteArray[40].callGroovyObjectGetProperty((Object)image), callSiteArray[41].callGroovyObjectGetProperty((Object)image)));
    }

    public static String getImageId(String registry, String repository, String tag, String digest) {
        CallSite[] callSiteArray = KubernetesUtil.$getCallSiteArray();
        GStringImpl tagSuffix = DefaultTypeTransformation.booleanUnbox((Object)digest) ? new GStringImpl(new Object[]{digest}, new String[]{"@", ""}) : new GStringImpl(new Object[]{tag}, new String[]{":", ""});
        if (DefaultTypeTransformation.booleanUnbox((Object)registry)) {
            return ShortTypeHandling.castToString((Object)callSiteArray[42].call((Object)new GStringImpl(new Object[]{registry, repository, tagSuffix}, new String[]{"", "/", "", ""})));
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[43].call((Object)new GStringImpl(new Object[]{repository, tagSuffix}, new String[]{"", "", ""})));
    }

    public static Object getImageIdWithoutRegistry(KubernetesImageDescription image) {
        CallSite[] callSiteArray = KubernetesUtil.$getCallSiteArray();
        GStringImpl tagSuffix = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[44].callGroovyObjectGetProperty((Object)image)) ? new GStringImpl(new Object[]{callSiteArray[45].callGroovyObjectGetProperty((Object)image)}, new String[]{"@", ""}) : new GStringImpl(new Object[]{callSiteArray[46].callGroovyObjectGetProperty((Object)image)}, new String[]{":", ""});
        return callSiteArray[47].call((Object)new GStringImpl(new Object[]{callSiteArray[48].callGroovyObjectGetProperty((Object)image), tagSuffix}, new String[]{"", "", ""}));
    }

    public static String validateNamespace(KubernetesV1Credentials credentials, String namespace) {
        CallSite[] callSiteArray = KubernetesUtil.$getCallSiteArray();
        String string = namespace;
        String resolvedNamespace = DefaultTypeTransformation.booleanUnbox((Object)string) ? string : "default";
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[49].call((Object)credentials, (Object)resolvedNamespace))) {
            GStringImpl gStringImpl;
            GStringImpl gStringImpl2;
            GStringImpl error = new GStringImpl(new Object[]{callSiteArray[50].call((Object)credentials)}, new String[]{"Registered namespaces are ", "."});
            error = DefaultTypeTransformation.booleanUnbox((Object)namespace) ? (gStringImpl2 = new GStringImpl(new Object[]{namespace, error}, new String[]{"Namespace '", "' was not registered with provided credentials. ", ""})) : (gStringImpl = new GStringImpl(new Object[]{error}, new String[]{"No provided namespace assumed to mean 'default' was not registered with provided credentials. ", ""}));
            throw (Throwable)callSiteArray[51].callConstructor(KubernetesIllegalArgumentException.class, (Object)error);
        }
        return ShortTypeHandling.castToString((Object)resolvedNamespace);
    }

    public static Map<String, String> getPodLoadBalancerStates(Pod pod) {
        CallSite[] callSiteArray = KubernetesUtil.$getCallSiteArray();
        public class _getPodLoadBalancerStates_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getPodLoadBalancerStates_closure3(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _getPodLoadBalancerStates_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object key, Object val) {
                CallSite[] callSiteArray = _getPodLoadBalancerStates_closure3.$getCallSiteArray();
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].callCurrent((GroovyObject)this, key))) {
                    return ScriptBytecodeAdapter.createMap((Object[])new Object[]{key, val});
                }
                return ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
            }

            public Object call(Object key, Object val) {
                CallSite[] callSiteArray = _getPodLoadBalancerStates_closure3.$getCallSiteArray();
                return callSiteArray[1].callCurrent((GroovyObject)this, key, val);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getPodLoadBalancerStates_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "isLoadBalancerLabel";
                stringArray[1] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _getPodLoadBalancerStates_closure3.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getPodLoadBalancerStates_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getPodLoadBalancerStates_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (Map)ScriptBytecodeAdapter.asType((Object)callSiteArray[52].callSafe(callSiteArray[53].callGetPropertySafe(callSiteArray[54].callGetProperty((Object)pod)), (Object)new _getPodLoadBalancerStates_closure3(KubernetesUtil.class, KubernetesUtil.class)), Map.class);
    }

    public static List<String> getLoadBalancers(Map<String, String> labels) {
        CallSite[] callSiteArray = KubernetesUtil.$getCallSiteArray();
        public class _getLoadBalancers_closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getLoadBalancers_closure4(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _getLoadBalancers_closure4.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object key, Object val) {
                CallSite[] callSiteArray = _getLoadBalancers_closure4.$getCallSiteArray();
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].callCurrent((GroovyObject)this, key))) {
                    return callSiteArray[1].call(key, callSiteArray[2].callGroovyObjectGetProperty((Object)this), callSiteArray[3].call(key));
                }
                return null;
            }

            public Object call(Object key, Object val) {
                CallSite[] callSiteArray = _getLoadBalancers_closure4.$getCallSiteArray();
                return callSiteArray[4].callCurrent((GroovyObject)this, key, val);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getLoadBalancers_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "isLoadBalancerLabel";
                stringArray[1] = "substring";
                stringArray[2] = "LOAD_BALANCER_LABEL_PREFIX_LENGTH";
                stringArray[3] = "length";
                stringArray[4] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[5];
                _getLoadBalancers_closure4.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getLoadBalancers_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getLoadBalancers_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[55].call(labels, (Object)new _getLoadBalancers_closure4(KubernetesUtil.class, KubernetesUtil.class)), List.class);
    }

    public static List<String> getLoadBalancers(Pod pod) {
        CallSite[] callSiteArray = KubernetesUtil.$getCallSiteArray();
        Object object = callSiteArray[57].callGetPropertySafe(callSiteArray[58].callGetProperty((Object)pod));
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[56].callStatic(KubernetesUtil.class, DefaultTypeTransformation.booleanUnbox((Object)object) ? object : ScriptBytecodeAdapter.createMap((Object[])new Object[0])), List.class);
    }

    public static List<String> getLoadBalancers(ReplicaSet rs) {
        CallSite[] callSiteArray = KubernetesUtil.$getCallSiteArray();
        Object object = callSiteArray[60].callGetPropertySafe(callSiteArray[61].callGetPropertySafe(callSiteArray[62].callGetPropertySafe(callSiteArray[63].callGetProperty((Object)rs))));
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[59].callStatic(KubernetesUtil.class, DefaultTypeTransformation.booleanUnbox((Object)object) ? object : ScriptBytecodeAdapter.createMap((Object[])new Object[0])), List.class);
    }

    public static List<String> getLoadBalancers(ReplicationController rc) {
        CallSite[] callSiteArray = KubernetesUtil.$getCallSiteArray();
        Object object = callSiteArray[65].callGetPropertySafe(callSiteArray[66].callGetPropertySafe(callSiteArray[67].callGetPropertySafe(callSiteArray[68].callGetProperty((Object)rc))));
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[64].callStatic(KubernetesUtil.class, DefaultTypeTransformation.booleanUnbox((Object)object) ? object : ScriptBytecodeAdapter.createMap((Object[])new Object[0])), List.class);
    }

    public static List<String> getLoadBalancers(Job job) {
        CallSite[] callSiteArray = KubernetesUtil.$getCallSiteArray();
        Object object = callSiteArray[70].callGetPropertySafe(callSiteArray[71].callGetPropertySafe(callSiteArray[72].callGetPropertySafe(callSiteArray[73].callGetProperty((Object)job))));
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[69].callStatic(KubernetesUtil.class, DefaultTypeTransformation.booleanUnbox((Object)object) ? object : ScriptBytecodeAdapter.createMap((Object[])new Object[0])), List.class);
    }

    public static Boolean isLoadBalancerLabel(String key) {
        CallSite[] callSiteArray = KubernetesUtil.$getCallSiteArray();
        return (Boolean)ScriptBytecodeAdapter.castToType((Object)callSiteArray[74].call((Object)key, (Object)LOAD_BALANCER_LABEL_PREFIX), Boolean.class);
    }

    public static String loadBalancerKey(String loadBalancer) {
        CallSite[] callSiteArray = KubernetesUtil.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[75].call(String.class, callSiteArray[76].call((Object)new GStringImpl(new Object[]{LOAD_BALANCER_LABEL_PREFIX}, new String[]{"", "%s"})), (Object)loadBalancer));
    }

    public static String combineAppStackDetail(String appName, String stack, String detail) {
        String string;
        CallSite[] callSiteArray = KubernetesUtil.$getCallSiteArray();
        callSiteArray[77].call(NameValidation.class, (Object)appName, (Object)"appName");
        stack = string = ScriptBytecodeAdapter.compareNotEqual((Object)stack, null) ? stack : "";
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareNotEqual((Object)detail, null) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[78].call((Object)detail))) {
                return ShortTypeHandling.castToString((Object)callSiteArray[79].call(callSiteArray[80].call(callSiteArray[81].call(callSiteArray[82].call((Object)appName, (Object)"-"), (Object)stack), (Object)"-"), (Object)detail));
            }
        } else if (ScriptBytecodeAdapter.compareNotEqual((Object)detail, null) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[83].call((Object)detail))) {
            return ShortTypeHandling.castToString((Object)callSiteArray[84].call(callSiteArray[85].call(callSiteArray[86].call(callSiteArray[87].call((Object)appName, (Object)"-"), (Object)stack), (Object)"-"), (Object)detail));
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[88].call((Object)stack))) {
            return ShortTypeHandling.castToString((Object)callSiteArray[89].call(callSiteArray[90].call((Object)appName, (Object)"-"), (Object)stack));
        }
        return appName;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != KubernetesUtil.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        String string8;
        String string9;
        String string10;
        ENABLE_DISABLE_ANNOTATION = string10 = "service.spinnaker.io/enabled";
        CONTROLLERS_DAEMONSET_KIND = string9 = "DaemonSet";
        CONTROLLERS_STATEFULSET_KIND = string8 = "StatefulSet";
        JOB_LABEL = string7 = "job";
        DEPLOYMENT_KIND = string6 = "Deployment";
        SERVER_GROUP_KIND = string5 = "ReplicaSet";
        DEPRECATED_SERVER_GROUP_KIND = string4 = "ReplicationController";
        SERVER_GROUP_LABEL = string3 = "replication-controller";
        LOAD_BALANCER_LABEL_PREFIX = string2 = "load-balancer-";
        SECURITY_GROUP_LABEL_PREFIX = string = "security-group-";
        Object object = KubernetesUtil.$getCallSiteArray()[91].call((Object)SECURITY_GROUP_LABEL_PREFIX);
        SECURITY_GROUP_LABEL_PREFIX_LENGTH = DefaultTypeTransformation.intUnbox((Object)object);
        Object object2 = KubernetesUtil.$getCallSiteArray()[92].call((Object)LOAD_BALANCER_LABEL_PREFIX);
        LOAD_BALANCER_LABEL_PREFIX_LENGTH = DefaultTypeTransformation.intUnbox((Object)object2);
    }

    public static String getSECURITY_GROUP_LABEL_PREFIX() {
        return SECURITY_GROUP_LABEL_PREFIX;
    }

    public static void setSECURITY_GROUP_LABEL_PREFIX(String string) {
        SECURITY_GROUP_LABEL_PREFIX = string;
    }

    public static String getLOAD_BALANCER_LABEL_PREFIX() {
        return LOAD_BALANCER_LABEL_PREFIX;
    }

    public static void setLOAD_BALANCER_LABEL_PREFIX(String string) {
        LOAD_BALANCER_LABEL_PREFIX = string;
    }

    public static String getSERVER_GROUP_LABEL() {
        return SERVER_GROUP_LABEL;
    }

    public static void setSERVER_GROUP_LABEL(String string) {
        SERVER_GROUP_LABEL = string;
    }

    public static String getDEPRECATED_SERVER_GROUP_KIND() {
        return DEPRECATED_SERVER_GROUP_KIND;
    }

    public static void setDEPRECATED_SERVER_GROUP_KIND(String string) {
        DEPRECATED_SERVER_GROUP_KIND = string;
    }

    public static String getSERVER_GROUP_KIND() {
        return SERVER_GROUP_KIND;
    }

    public static void setSERVER_GROUP_KIND(String string) {
        SERVER_GROUP_KIND = string;
    }

    public static String getDEPLOYMENT_KIND() {
        return DEPLOYMENT_KIND;
    }

    public static void setDEPLOYMENT_KIND(String string) {
        DEPLOYMENT_KIND = string;
    }

    public static String getJOB_LABEL() {
        return JOB_LABEL;
    }

    public static void setJOB_LABEL(String string) {
        JOB_LABEL = string;
    }

    public static String getCONTROLLERS_STATEFULSET_KIND() {
        return CONTROLLERS_STATEFULSET_KIND;
    }

    public static void setCONTROLLERS_STATEFULSET_KIND(String string) {
        CONTROLLERS_STATEFULSET_KIND = string;
    }

    public static String getCONTROLLERS_DAEMONSET_KIND() {
        return CONTROLLERS_DAEMONSET_KIND;
    }

    public static void setCONTROLLERS_DAEMONSET_KIND(String string) {
        CONTROLLERS_DAEMONSET_KIND = string;
    }

    public static String getDEFAULT_REGISTRY() {
        return DEFAULT_REGISTRY;
    }

    public static void setDEFAULT_REGISTRY(String string) {
        DEFAULT_REGISTRY = string;
    }

    public static String getENABLE_DISABLE_ANNOTATION() {
        return ENABLE_DISABLE_ANNOTATION;
    }

    public static void setENABLE_DISABLE_ANNOTATION(String string) {
        ENABLE_DISABLE_ANNOTATION = string;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "getReplicationControllers";
        stringArray[1] = "apiAdaptor";
        stringArray[2] = "forEach";
        stringArray[3] = "format";
        stringArray[4] = "next";
        stringArray[5] = "collect";
        stringArray[6] = "imagePullSecrets";
        stringArray[7] = "spec";
        stringArray[8] = "template";
        stringArray[9] = "spec";
        stringArray[10] = "indexOf";
        stringArray[11] = "substring";
        stringArray[12] = "startsWith";
        stringArray[13] = "contains";
        stringArray[14] = "substring";
        stringArray[15] = "plus";
        stringArray[16] = "indexOf";
        stringArray[17] = "substring";
        stringArray[18] = "plus";
        stringArray[19] = "substring";
        stringArray[20] = "indexOf";
        stringArray[21] = "substring";
        stringArray[22] = "plus";
        stringArray[23] = "substring";
        stringArray[24] = "uri";
        stringArray[25] = "extractRegistry";
        stringArray[26] = "extractDigestOrTag";
        stringArray[27] = "<$constructor$>";
        stringArray[28] = "normalizeImageDescription";
        stringArray[29] = "populateFieldsFromUri";
        stringArray[30] = "registry";
        stringArray[31] = "tag";
        stringArray[32] = "digest";
        stringArray[33] = "tag";
        stringArray[34] = "digest";
        stringArray[35] = "repository";
        stringArray[36] = "<$constructor$>";
        stringArray[37] = "getImageId";
        stringArray[38] = "registry";
        stringArray[39] = "repository";
        stringArray[40] = "tag";
        stringArray[41] = "digest";
        stringArray[42] = "toString";
        stringArray[43] = "toString";
        stringArray[44] = "digest";
        stringArray[45] = "digest";
        stringArray[46] = "tag";
        stringArray[47] = "toString";
        stringArray[48] = "repository";
        stringArray[49] = "isRegisteredNamespace";
        stringArray[50] = "getDeclaredNamespaces";
        stringArray[51] = "<$constructor$>";
        stringArray[52] = "collectEntries";
        stringArray[53] = "labels";
        stringArray[54] = "metadata";
        stringArray[55] = "findResults";
        stringArray[56] = "getLoadBalancers";
        stringArray[57] = "labels";
        stringArray[58] = "metadata";
        stringArray[59] = "getLoadBalancers";
        stringArray[60] = "labels";
        stringArray[61] = "metadata";
        stringArray[62] = "template";
        stringArray[63] = "spec";
        stringArray[64] = "getLoadBalancers";
        stringArray[65] = "labels";
        stringArray[66] = "metadata";
        stringArray[67] = "template";
        stringArray[68] = "spec";
        stringArray[69] = "getLoadBalancers";
        stringArray[70] = "labels";
        stringArray[71] = "metadata";
        stringArray[72] = "template";
        stringArray[73] = "spec";
        stringArray[74] = "startsWith";
        stringArray[75] = "format";
        stringArray[76] = "toString";
        stringArray[77] = "notEmpty";
        stringArray[78] = "isEmpty";
        stringArray[79] = "plus";
        stringArray[80] = "plus";
        stringArray[81] = "plus";
        stringArray[82] = "plus";
        stringArray[83] = "isEmpty";
        stringArray[84] = "plus";
        stringArray[85] = "plus";
        stringArray[86] = "plus";
        stringArray[87] = "plus";
        stringArray[88] = "isEmpty";
        stringArray[89] = "plus";
        stringArray[90] = "plus";
        stringArray[91] = "length";
        stringArray[92] = "length";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[93];
        KubernetesUtil.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(KubernetesUtil.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = KubernetesUtil.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

