/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v1.security;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import io.fabric8.kubernetes.api.model.AuthInfo;
import io.fabric8.kubernetes.api.model.Cluster;
import io.fabric8.kubernetes.api.model.Context;
import io.fabric8.kubernetes.api.model.NamedContext;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.internal.KubeConfigUtils;
import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.nio.file.Files;
import java.util.List;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;

public class KubernetesConfigParser
implements GroovyObject {
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public KubernetesConfigParser() {
        MetaClass metaClass;
        CallSite[] callSiteArray = KubernetesConfigParser.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static Config parse(String kubeconfigFile, String context, String cluster, String user, List<String> namespaces, Boolean serviceAccount) {
        CallSite[] callSiteArray = KubernetesConfigParser.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (DefaultTypeTransformation.booleanUnbox((Object)serviceAccount)) {
                return (Config)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].callStatic(KubernetesConfigParser.class), Config.class);
            }
            return (Config)ScriptBytecodeAdapter.castToType((Object)callSiteArray[1].callStatic(KubernetesConfigParser.class, ArrayUtil.createArray((Object)kubeconfigFile, (Object)context, (Object)cluster, (Object)user, namespaces)), Config.class);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)serviceAccount)) {
            return KubernetesConfigParser.withServiceAccount();
        }
        return (Config)ScriptBytecodeAdapter.castToType((Object)callSiteArray[2].callStatic(KubernetesConfigParser.class, ArrayUtil.createArray((Object)kubeconfigFile, (Object)context, (Object)cluster, (Object)user, namespaces)), Config.class);
    }

    public static Config withServiceAccount() {
        CallSite[] callSiteArray = KubernetesConfigParser.$getCallSiteArray();
        Config config = (Config)ScriptBytecodeAdapter.castToType((Object)callSiteArray[3].callConstructor(Config.class), Config.class);
        boolean serviceAccountCaCertExists = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[4].call(Files.class, callSiteArray[5].call(callSiteArray[6].callConstructor(File.class, callSiteArray[7].callGetProperty(Config.class)))));
        if (!serviceAccountCaCertExists) {
            throw (Throwable)callSiteArray[10].callConstructor(IllegalStateException.class, (Object)new GStringImpl(new Object[]{callSiteArray[11].callGetProperty(Config.class)}, new String[]{"Could not find CA cert for service account at ", ""}));
        }
        callSiteArray[8].call((Object)config, callSiteArray[9].callGetProperty(Config.class));
        try {
            String serviceTokenCandidate = ShortTypeHandling.castToString((Object)callSiteArray[12].callConstructor(String.class, callSiteArray[13].call(Files.class, callSiteArray[14].call(callSiteArray[15].callConstructor(File.class, callSiteArray[16].callGetProperty(Config.class))))));
            if (!ScriptBytecodeAdapter.compareNotEqual((Object)serviceTokenCandidate, null)) {
                throw (Throwable)callSiteArray[24].callConstructor(IllegalStateException.class, (Object)new GStringImpl(new Object[]{callSiteArray[25].callGetProperty(Config.class)}, new String[]{"Did not find service account token at ", ""}));
            }
            String error = "Configured service account doesn't have access. Service account may have been revoked.";
            callSiteArray[17].call((Object)config, (Object)serviceTokenCandidate);
            callSiteArray[18].call(callSiteArray[19].call((Object)config), (Object)401, callSiteArray[20].call((Object)"Unauthorized! ", (Object)error));
            callSiteArray[21].call(callSiteArray[22].call((Object)config), (Object)403, callSiteArray[23].call((Object)"Forbidden! ", (Object)error));
        }
        catch (IOException e) {
            throw (Throwable)callSiteArray[26].callConstructor(IllegalStateException.class, (Object)new GStringImpl(new Object[]{callSiteArray[27].callGetProperty(Config.class)}, new String[]{"Could not read service account token at ", ""}), (Object)e);
        }
        return config;
    }

    public static Config withKubeConfig(String kubeconfigFile, String context, String cluster, String user, List<String> namespaces) {
        String string;
        CallSite[] callSiteArray = KubernetesConfigParser.$getCallSiteArray();
        Object kubeConfig = callSiteArray[28].call(KubeConfigUtils.class, callSiteArray[29].callConstructor(File.class, (Object)kubeconfigFile));
        Config config = (Config)ScriptBytecodeAdapter.castToType((Object)callSiteArray[30].callConstructor(Config.class), Config.class);
        String string2 = context;
        Reference resolvedContext = new Reference((Object)ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)string2) ? string2 : callSiteArray[31].callGetProperty(kubeConfig))));
        public class _withKubeConfig_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference resolvedContext;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _withKubeConfig_closure1(Object _outerInstance, Object _thisObject, Reference resolvedContext) {
                Reference reference;
                CallSite[] callSiteArray = _withKubeConfig_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.resolvedContext = reference = resolvedContext;
            }

            public Object doCall(NamedContext it) {
                CallSite[] callSiteArray = _withKubeConfig_closure1.$getCallSiteArray();
                return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty((Object)it), (Object)this.resolvedContext.get());
            }

            public Object call(NamedContext it) {
                CallSite[] callSiteArray = _withKubeConfig_closure1.$getCallSiteArray();
                return callSiteArray[1].callCurrent((GroovyObject)this, (Object)it);
            }

            public String getResolvedContext() {
                CallSite[] callSiteArray = _withKubeConfig_closure1.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.resolvedContext.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _withKubeConfig_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "name";
                stringArray[1] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _withKubeConfig_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_withKubeConfig_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _withKubeConfig_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Context currentContext = (Context)ScriptBytecodeAdapter.castToType((Object)callSiteArray[32].callSafe(callSiteArray[33].call(callSiteArray[34].callGetProperty(kubeConfig), (Object)new _withKubeConfig_closure1(KubernetesConfigParser.class, KubernetesConfigParser.class, resolvedContext))), Context.class);
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (!DefaultTypeTransformation.booleanUnbox((Object)context) && !DefaultTypeTransformation.booleanUnbox((Object)currentContext)) {
                throw (Throwable)callSiteArray[35].callConstructor(IllegalArgumentException.class, callSiteArray[36].call((Object)new GStringImpl(new Object[]{context, kubeconfigFile}, new String[]{"Context ", " was not found in ", ""})));
            }
        } else if (!DefaultTypeTransformation.booleanUnbox((Object)context) && !DefaultTypeTransformation.booleanUnbox((Object)currentContext)) {
            throw (Throwable)callSiteArray[37].callConstructor(IllegalArgumentException.class, callSiteArray[38].call((Object)new GStringImpl(new Object[]{context, kubeconfigFile}, new String[]{"Context ", " was not found in ", ""})));
        }
        String string3 = DefaultTypeTransformation.booleanUnbox((Object)(string = user)) ? string : callSiteArray[39].callGetProperty((Object)currentContext);
        ScriptBytecodeAdapter.setProperty((Object)string3, null, (Object)currentContext, (String)"user");
        String string4 = cluster;
        String string5 = DefaultTypeTransformation.booleanUnbox((Object)string4) ? string4 : callSiteArray[40].callGetProperty((Object)currentContext);
        ScriptBytecodeAdapter.setProperty((Object)string5, null, (Object)currentContext, (String)"cluster");
        if (DefaultTypeTransformation.booleanUnbox(namespaces)) {
            Object object = callSiteArray[41].call(namespaces, (Object)0);
            ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)currentContext, (String)"namespace");
        } else if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[42].callGetProperty((Object)currentContext))) {
            String string6 = "default";
            ScriptBytecodeAdapter.setProperty((Object)string6, null, (Object)currentContext, (String)"namespace");
        }
        Cluster currentCluster = (Cluster)ScriptBytecodeAdapter.castToType((Object)callSiteArray[43].call(KubeConfigUtils.class, kubeConfig, (Object)currentContext), Cluster.class);
        callSiteArray[44].call((Object)config, (Object)"v1");
        Object object = callSiteArray[45].call(System.class, (Object)"HTTP_PROXY");
        String httpProxy = ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)object) ? object : callSiteArray[46].call(System.class, (Object)"http_proxy")));
        Object object2 = callSiteArray[47].call(System.class, (Object)"HTTPS_PROXY");
        String httpsProxy = ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)object2) ? object2 : callSiteArray[48].call(System.class, (Object)"https_proxy")));
        Object object3 = callSiteArray[49].call(System.class, (Object)"NO_PROXY");
        String noProxy = ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)object3) ? object3 : callSiteArray[50].call(System.class, (Object)"no_proxy")));
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareNotEqual((Object)httpProxy, null) && ScriptBytecodeAdapter.compareNotEqual((Object)httpProxy, (Object)"")) {
                callSiteArray[51].call((Object)config, (Object)httpProxy);
            }
        } else if (ScriptBytecodeAdapter.compareNotEqual((Object)httpProxy, null) && ScriptBytecodeAdapter.compareNotEqual((Object)httpProxy, (Object)"")) {
            callSiteArray[52].call((Object)config, (Object)httpProxy);
        }
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareNotEqual((Object)httpsProxy, null) && ScriptBytecodeAdapter.compareNotEqual((Object)httpsProxy, (Object)"")) {
                callSiteArray[53].call((Object)config, (Object)httpsProxy);
            }
        } else if (ScriptBytecodeAdapter.compareNotEqual((Object)httpsProxy, null) && ScriptBytecodeAdapter.compareNotEqual((Object)httpsProxy, (Object)"")) {
            callSiteArray[54].call((Object)config, (Object)httpsProxy);
        }
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareNotEqual((Object)noProxy, null) && ScriptBytecodeAdapter.compareNotEqual((Object)noProxy, (Object)"")) {
                String[] noProxyList = (String[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[55].call((Object)noProxy, (Object)","), String[].class);
                callSiteArray[56].call((Object)config, (Object)noProxyList);
            }
        } else if (ScriptBytecodeAdapter.compareNotEqual((Object)noProxy, null) && ScriptBytecodeAdapter.compareNotEqual((Object)noProxy, (Object)"")) {
            String[] noProxyList = (String[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[57].call((Object)noProxy, (Object)","), String[].class);
            callSiteArray[58].call((Object)config, (Object)noProxyList);
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)currentCluster, null)) {
            callSiteArray[59].call((Object)config, callSiteArray[60].call(callSiteArray[61].call((Object)currentCluster), (Object)(DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[62].call(callSiteArray[63].call((Object)currentCluster), (Object)"/")) ? "" : "/")));
            callSiteArray[64].call((Object)config, callSiteArray[65].call((Object)currentContext));
            callSiteArray[66].call((Object)config, (Object)(ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[67].call((Object)currentCluster), null) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[68].call((Object)currentCluster)) ? 1 : 0));
            callSiteArray[69].call((Object)config, callSiteArray[70].call((Object)currentCluster));
            callSiteArray[71].call((Object)config, callSiteArray[72].call((Object)currentCluster));
            AuthInfo currentAuthInfo = (AuthInfo)ScriptBytecodeAdapter.castToType((Object)callSiteArray[73].call(KubeConfigUtils.class, kubeConfig, (Object)currentContext), AuthInfo.class);
            if (ScriptBytecodeAdapter.compareNotEqual((Object)currentAuthInfo, null)) {
                callSiteArray[74].call((Object)config, callSiteArray[75].call((Object)currentAuthInfo));
                callSiteArray[76].call((Object)config, callSiteArray[77].call((Object)currentAuthInfo));
                callSiteArray[78].call((Object)config, callSiteArray[79].call((Object)currentAuthInfo));
                callSiteArray[80].call((Object)config, callSiteArray[81].call((Object)currentAuthInfo));
                callSiteArray[82].call((Object)config, callSiteArray[83].call((Object)currentAuthInfo));
                callSiteArray[84].call((Object)config, callSiteArray[85].call((Object)currentAuthInfo));
                callSiteArray[86].call((Object)config, callSiteArray[87].call((Object)currentAuthInfo));
                callSiteArray[88].call(callSiteArray[89].call((Object)config), (Object)401, (Object)"Unauthorized! Token may have expired! Please log-in again.");
                callSiteArray[90].call(callSiteArray[91].call((Object)config), (Object)403, callSiteArray[92].call((Object)new GStringImpl(new Object[]{callSiteArray[93].callGetProperty((Object)currentContext)}, new String[]{"Forbidden! User ", " doesn't have permission."})));
            }
        }
        return config;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != KubernetesConfigParser.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "withServiceAccount";
        stringArray[1] = "withKubeConfig";
        stringArray[2] = "withKubeConfig";
        stringArray[3] = "<$constructor$>";
        stringArray[4] = "isRegularFile";
        stringArray[5] = "toPath";
        stringArray[6] = "<$constructor$>";
        stringArray[7] = "KUBERNETES_SERVICE_ACCOUNT_CA_CRT_PATH";
        stringArray[8] = "setCaCertFile";
        stringArray[9] = "KUBERNETES_SERVICE_ACCOUNT_CA_CRT_PATH";
        stringArray[10] = "<$constructor$>";
        stringArray[11] = "KUBERNETES_SERVICE_ACCOUNT_CA_CRT_PATH";
        stringArray[12] = "<$constructor$>";
        stringArray[13] = "readAllBytes";
        stringArray[14] = "toPath";
        stringArray[15] = "<$constructor$>";
        stringArray[16] = "KUBERNETES_SERVICE_ACCOUNT_TOKEN_PATH";
        stringArray[17] = "setOauthToken";
        stringArray[18] = "put";
        stringArray[19] = "getErrorMessages";
        stringArray[20] = "plus";
        stringArray[21] = "put";
        stringArray[22] = "getErrorMessages";
        stringArray[23] = "plus";
        stringArray[24] = "<$constructor$>";
        stringArray[25] = "KUBERNETES_SERVICE_ACCOUNT_TOKEN_PATH";
        stringArray[26] = "<$constructor$>";
        stringArray[27] = "KUBERNETES_SERVICE_ACCOUNT_TOKEN_PATH";
        stringArray[28] = "parseConfig";
        stringArray[29] = "<$constructor$>";
        stringArray[30] = "<$constructor$>";
        stringArray[31] = "currentContext";
        stringArray[32] = "getContext";
        stringArray[33] = "find";
        stringArray[34] = "contexts";
        stringArray[35] = "<$constructor$>";
        stringArray[36] = "toString";
        stringArray[37] = "<$constructor$>";
        stringArray[38] = "toString";
        stringArray[39] = "user";
        stringArray[40] = "cluster";
        stringArray[41] = "getAt";
        stringArray[42] = "namespace";
        stringArray[43] = "getCluster";
        stringArray[44] = "setApiVersion";
        stringArray[45] = "getenv";
        stringArray[46] = "getenv";
        stringArray[47] = "getenv";
        stringArray[48] = "getenv";
        stringArray[49] = "getenv";
        stringArray[50] = "getenv";
        stringArray[51] = "setHttpProxy";
        stringArray[52] = "setHttpProxy";
        stringArray[53] = "setHttpsProxy";
        stringArray[54] = "setHttpsProxy";
        stringArray[55] = "split";
        stringArray[56] = "setNoProxy";
        stringArray[57] = "split";
        stringArray[58] = "setNoProxy";
        stringArray[59] = "setMasterUrl";
        stringArray[60] = "plus";
        stringArray[61] = "getServer";
        stringArray[62] = "endsWith";
        stringArray[63] = "getServer";
        stringArray[64] = "setNamespace";
        stringArray[65] = "getNamespace";
        stringArray[66] = "setTrustCerts";
        stringArray[67] = "getInsecureSkipTlsVerify";
        stringArray[68] = "getInsecureSkipTlsVerify";
        stringArray[69] = "setCaCertFile";
        stringArray[70] = "getCertificateAuthority";
        stringArray[71] = "setCaCertData";
        stringArray[72] = "getCertificateAuthorityData";
        stringArray[73] = "getUserAuthInfo";
        stringArray[74] = "setClientCertFile";
        stringArray[75] = "getClientCertificate";
        stringArray[76] = "setClientCertData";
        stringArray[77] = "getClientCertificateData";
        stringArray[78] = "setClientKeyFile";
        stringArray[79] = "getClientKey";
        stringArray[80] = "setClientKeyData";
        stringArray[81] = "getClientKeyData";
        stringArray[82] = "setOauthToken";
        stringArray[83] = "getToken";
        stringArray[84] = "setUsername";
        stringArray[85] = "getUsername";
        stringArray[86] = "setPassword";
        stringArray[87] = "getPassword";
        stringArray[88] = "put";
        stringArray[89] = "getErrorMessages";
        stringArray[90] = "put";
        stringArray[91] = "getErrorMessages";
        stringArray[92] = "toString";
        stringArray[93] = "user";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[94];
        KubernetesConfigParser.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(KubernetesConfigParser.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = KubernetesConfigParser.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

