/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v1.security;

import com.google.common.collect.Lists;
import com.netflix.servo.util.VisibleForTesting;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.docker.registry.security.DockerRegistryNamedAccountCredentials;
import com.netflix.spinnaker.clouddriver.kubernetes.config.LinkedDockerRegistryConfiguration;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesApiClientConfig;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesCredentials;
import com.netflix.spinnaker.clouddriver.kubernetes.v1.api.KubernetesApiAdaptor;
import com.netflix.spinnaker.clouddriver.kubernetes.v1.api.KubernetesClientApiAdapter;
import com.netflix.spinnaker.clouddriver.kubernetes.v1.security.KubernetesConfigParser;
import com.netflix.spinnaker.clouddriver.security.AccountCredentialsRepository;
import io.fabric8.kubernetes.api.model.DoneableSecret;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceBuilder;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretBuilder;
import io.fabric8.kubernetes.api.model.SecretFluent;
import io.fabric8.kubernetes.client.Config;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesV1Credentials
implements KubernetesCredentials {
    private final KubernetesApiAdaptor apiAdaptor;
    private KubernetesClientApiAdapter apiClientAdaptor;
    private final List<String> namespaces;
    private final List<String> omitNamespaces;
    private final List<LinkedDockerRegistryConfiguration> dockerRegistries;
    private final HashMap<String, Set<String>> imagePullSecrets = new HashMap();
    private final Logger LOG;
    private final AccountCredentialsRepository repository;
    private final HashSet<String> dynamicRegistries = new HashSet();
    private final boolean configureImagePullSecrets;
    private List<String> oldNamespaces;

    public KubernetesV1Credentials(String name, String kubeconfigFile, String context, String cluster, String user, String userAgent, Boolean serviceAccount, boolean configureImagePullSecrets, List<String> namespaces, List<String> omitNamespaces, List<LinkedDockerRegistryConfiguration> dockerRegistries, Registry spectatorRegistry, AccountCredentialsRepository accountCredentialsRepository) {
        if (dockerRegistries == null || dockerRegistries.size() == 0) {
            throw new IllegalArgumentException("Docker registries for Kubernetes account " + name + " are required.");
        }
        Config config = KubernetesConfigParser.parse(kubeconfigFile, context, cluster, user, namespaces, serviceAccount);
        config.setUserAgent(userAgent);
        KubernetesApiClientConfig configClient = new KubernetesApiClientConfig(kubeconfigFile, context, cluster, user, userAgent, serviceAccount);
        this.apiAdaptor = new KubernetesApiAdaptor(name, config, spectatorRegistry);
        this.apiClientAdaptor = new KubernetesClientApiAdapter(name, configClient, spectatorRegistry);
        this.namespaces = namespaces != null ? namespaces : new ArrayList();
        this.omitNamespaces = omitNamespaces != null ? omitNamespaces : new ArrayList();
        this.dockerRegistries = dockerRegistries;
        this.repository = accountCredentialsRepository;
        this.LOG = LoggerFactory.getLogger(KubernetesV1Credentials.class);
        this.configureImagePullSecrets = configureImagePullSecrets;
        this.configureDockerRegistries();
    }

    @VisibleForTesting
    private KubernetesV1Credentials(KubernetesApiAdaptor apiAdaptor, List<String> namespaces, List<String> omitNamespaces, List<LinkedDockerRegistryConfiguration> dockerRegistries, AccountCredentialsRepository repository) {
        this.apiAdaptor = apiAdaptor;
        this.namespaces = namespaces != null ? namespaces : new ArrayList();
        this.omitNamespaces = omitNamespaces != null ? omitNamespaces : new ArrayList();
        this.dockerRegistries = dockerRegistries;
        this.repository = repository;
        this.LOG = LoggerFactory.getLogger(KubernetesV1Credentials.class);
        this.configureImagePullSecrets = true;
        this.configureDockerRegistries();
    }

    private void configureDockerRegistries() {
        this.oldNamespaces = this.namespaces;
        for (LinkedDockerRegistryConfiguration dockerRegistryConfiguration : this.dockerRegistries) {
            if (dockerRegistryConfiguration.getNamespaces() != null && !dockerRegistryConfiguration.getNamespaces().isEmpty()) continue;
            this.dynamicRegistries.add(dockerRegistryConfiguration.getAccountName());
        }
        try {
            List<String> knownNamespaces = !this.namespaces.isEmpty() ? this.namespaces : this.apiAdaptor.getNamespacesByName();
            this.reconfigureRegistries(knownNamespaces);
        }
        catch (Exception e) {
            this.LOG.warn("Could not determine kubernetes namespaces. Will try again later.", (Throwable)e);
        }
    }

    @Override
    public List<String> getDeclaredNamespaces() {
        try {
            if (this.namespaces != null && !this.namespaces.isEmpty()) {
                this.reconfigureRegistries(this.namespaces);
                return this.namespaces;
            }
            List<String> addedNamespaces = this.apiAdaptor.getNamespacesByName();
            addedNamespaces.removeAll(this.omitNamespaces);
            ArrayList<String> resultNamespaces = new ArrayList<String>(addedNamespaces);
            addedNamespaces.removeAll(this.oldNamespaces);
            this.reconfigureRegistries(resultNamespaces);
            this.oldNamespaces = resultNamespaces;
            return resultNamespaces;
        }
        catch (Exception e) {
            this.LOG.warn("Could not determine kubernetes namespaces. Will try again later.", (Throwable)e);
            return Lists.newArrayList();
        }
    }

    private void reconfigureRegistries(List<String> allNamespaces) {
        List<String> affectedNamespaces = new ArrayList<String>(allNamespaces);
        if (!this.configureImagePullSecrets) {
            return;
        }
        ArrayList<String> initializedNamespaces = new ArrayList<String>(this.imagePullSecrets.keySet());
        affectedNamespaces.removeAll(initializedNamespaces);
        for (int i = 0; i < this.dockerRegistries.size(); ++i) {
            DockerRegistryNamedAccountCredentials account;
            LinkedDockerRegistryConfiguration registry = this.dockerRegistries.get(i);
            List<String> registryNamespaces = registry.getNamespaces();
            if (!this.dynamicRegistries.contains(registry.getAccountName())) {
                affectedNamespaces = registryNamespaces;
            } else {
                registry.setNamespaces(allNamespaces);
            }
            if (affectedNamespaces != null && !affectedNamespaces.isEmpty()) {
                this.LOG.debug("Adding secrets for docker registry {} in {}", (Object)registry.getAccountName(), affectedNamespaces);
            }
            if ((account = (DockerRegistryNamedAccountCredentials)this.repository.getOne(registry.getAccountName())) == null) {
                this.LOG.warn("The account " + registry.getAccountName() + " was not yet loaded inside Clouddriver. If you are seeing this message repeatedly, it likely cannot be loaded.");
                continue;
            }
            for (String namespace : affectedNamespaces) {
                Namespace res = this.apiAdaptor.getNamespace(namespace);
                if (res == null) {
                    NamespaceBuilder namespaceBuilder = new NamespaceBuilder();
                    Namespace newNamespace = ((NamespaceBuilder)((NamespaceFluent.MetadataNested)namespaceBuilder.withNewMetadata().withName(namespace)).endMetadata()).build();
                    this.apiAdaptor.createNamespace(newNamespace);
                }
                SecretBuilder secretBuilder = new SecretBuilder();
                String secretName = registry.getAccountName();
                secretBuilder = (SecretBuilder)((SecretFluent.MetadataNested)((SecretFluent.MetadataNested)secretBuilder.withNewMetadata().withName(secretName)).withNamespace(namespace)).endMetadata();
                HashMap<String, String> secretData = new HashMap<String, String>(1);
                String dockerCfg = String.format("{ \"%s\": { \"auth\": \"%s\", \"email\": \"%s\" } }", account.getAddress(), account.getBasicAuth(), account.getEmail());
                try {
                    dockerCfg = new String(Base64.getEncoder().encode(dockerCfg.getBytes("UTF-8")), "UTF-8");
                }
                catch (UnsupportedEncodingException uee) {
                    throw new IllegalStateException("Unable to encode docker config ", uee);
                }
                secretData.put(".dockercfg", dockerCfg);
                secretBuilder = (SecretBuilder)((SecretBuilder)secretBuilder.withData(secretData)).withType("kubernetes.io/dockercfg");
                try {
                    Secret newSecret = secretBuilder.build();
                    Secret oldSecret = this.apiAdaptor.getSecret(namespace, secretName);
                    if (oldSecret != null) {
                        if (oldSecret.getData().equals(newSecret.getData())) {
                            this.LOG.debug("Skipping creation of duplicate secret " + secretName + " in namespace " + namespace);
                        } else {
                            ((DoneableSecret)this.apiAdaptor.editSecret(namespace, secretName).addToData(newSecret.getData())).done();
                        }
                    } else {
                        this.apiAdaptor.createSecret(namespace, secretBuilder.build());
                    }
                }
                catch (ConstraintViolationException cve) {
                    throw new IllegalStateException("Unable to build secret: " + cve.getMessage() + " due to violations " + cve.getConstraintViolations(), cve);
                }
                HashSet<String> existingSecrets = this.imagePullSecrets.get(namespace);
                existingSecrets = existingSecrets != null ? existingSecrets : new HashSet<String>();
                existingSecrets.add(secretName);
                this.imagePullSecrets.put(namespace, existingSecrets);
            }
        }
    }

    public KubernetesApiAdaptor getApiAdaptor() {
        return this.apiAdaptor;
    }

    public KubernetesClientApiAdapter getClientApiAdaptor() {
        return this.apiClientAdaptor;
    }

    public List<LinkedDockerRegistryConfiguration> getDockerRegistries() {
        return this.dockerRegistries;
    }

    public Map<String, Set<String>> getImagePullSecrets() {
        return this.imagePullSecrets;
    }

    public Boolean isRegisteredNamespace(String namespace) {
        return this.getDeclaredNamespaces().contains(namespace);
    }

    public Boolean isRegisteredImagePullSecret(String secret, String namespace) {
        Set<String> secrets = this.imagePullSecrets.get(namespace);
        if (secrets == null) {
            return false;
        }
        return secrets.contains(secret);
    }
}

