/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.caching;

import com.netflix.spinnaker.cats.agent.Agent;
import com.netflix.spinnaker.cats.agent.AgentSchedulerAware;
import com.netflix.spinnaker.cats.provider.Provider;
import com.netflix.spinnaker.clouddriver.kubernetes.KubernetesCloudProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;

class KubernetesV2Provider
extends AgentSchedulerAware
implements Provider {
    public static final String PROVIDER_NAME = KubernetesCloudProvider.getID();
    private Collection<Agent> agents = KubernetesV2Provider.emptyAgentCollection();
    private Collection<Agent> nextAgentSet = KubernetesV2Provider.emptyAgentCollection();

    private static Collection<Agent> emptyAgentCollection() {
        return Collections.newSetFromMap(new ConcurrentHashMap());
    }

    public void addAllAgents(Collection<Agent> agents) {
        this.nextAgentSet.addAll(agents);
    }

    public void clearNewAgentSet() {
        this.nextAgentSet.clear();
    }

    public void switchToNewAgents() {
        Collection<Agent> nextAgentSetCopy = KubernetesV2Provider.emptyAgentCollection();
        nextAgentSetCopy.addAll(this.nextAgentSet);
        this.agents = nextAgentSetCopy;
        this.clearNewAgentSet();
    }

    public String getProviderName() {
        return PROVIDER_NAME;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KubernetesV2Provider)) {
            return false;
        }
        KubernetesV2Provider other = (KubernetesV2Provider)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Collection<Agent> this$agents = this.getAgents();
        Collection<Agent> other$agents = other.getAgents();
        if (this$agents == null ? other$agents != null : !((Object)this$agents).equals(other$agents)) {
            return false;
        }
        Collection<Agent> this$nextAgentSet = this.getNextAgentSet();
        Collection<Agent> other$nextAgentSet = other.getNextAgentSet();
        return !(this$nextAgentSet == null ? other$nextAgentSet != null : !((Object)this$nextAgentSet).equals(other$nextAgentSet));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KubernetesV2Provider;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Collection<Agent> $agents = this.getAgents();
        result = result * 59 + ($agents == null ? 43 : ((Object)$agents).hashCode());
        Collection<Agent> $nextAgentSet = this.getNextAgentSet();
        result = result * 59 + ($nextAgentSet == null ? 43 : ((Object)$nextAgentSet).hashCode());
        return result;
    }

    public Collection<Agent> getAgents() {
        return this.agents;
    }

    public Collection<Agent> getNextAgentSet() {
        return this.nextAgentSet;
    }

    public KubernetesV2Provider setAgents(Collection<Agent> agents) {
        this.agents = agents;
        return this;
    }

    public KubernetesV2Provider setNextAgentSet(Collection<Agent> nextAgentSet) {
        this.nextAgentSet = nextAgentSet;
        return this;
    }

    public String toString() {
        return "KubernetesV2Provider(agents=" + this.getAgents() + ", nextAgentSet=" + this.getNextAgentSet() + ")";
    }
}

