/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.caching;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.clouddriver.kubernetes.KubernetesCloudProvider;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.Keys;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.provider.KubernetesCacheUtils;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesResourceProperties;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesResourcePropertyRegistry;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesSpinnakerKindMap;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.search.SearchProvider;
import com.netflix.spinnaker.clouddriver.search.SearchResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class KubernetesV2SearchProvider
implements SearchProvider {
    private static final Logger log = LoggerFactory.getLogger(KubernetesV2SearchProvider.class);
    private final KubernetesCacheUtils cacheUtils;
    private final ObjectMapper mapper;
    private final KubernetesSpinnakerKindMap kindMap;
    private final KubernetesResourcePropertyRegistry registry;
    private final List<String> defaultTypes;
    private final Set<String> logicalTypes;
    private final Set<String> allCaches;

    @Autowired
    public KubernetesV2SearchProvider(KubernetesCacheUtils cacheUtils, KubernetesSpinnakerKindMap kindMap, ObjectMapper objectMapper, KubernetesResourcePropertyRegistry registry) {
        this.cacheUtils = cacheUtils;
        this.mapper = objectMapper;
        this.kindMap = kindMap;
        this.registry = registry;
        this.defaultTypes = kindMap.allKubernetesKinds().stream().map(KubernetesKind::toString).collect(Collectors.toList());
        this.logicalTypes = Arrays.stream(Keys.LogicalKind.values()).map(Keys.LogicalKind::toString).collect(Collectors.toSet());
        this.allCaches = new HashSet<String>(this.defaultTypes);
        this.allCaches.addAll(this.logicalTypes);
    }

    public String getPlatform() {
        return KubernetesCloudProvider.getID();
    }

    public SearchResultSet search(String query, Integer pageNumber, Integer pageSize) {
        return this.search(query, this.defaultTypes, pageNumber, pageSize);
    }

    public SearchResultSet search(String query, Integer pageNumber, Integer pageSize, Map<String, String> filters) {
        return this.search(query, this.defaultTypes, pageNumber, pageSize, filters);
    }

    public SearchResultSet search(String query, List<String> types, Integer pageNumber, Integer pageSize) {
        return this.search(query, types, pageNumber, pageSize, Collections.emptyMap());
    }

    public SearchResultSet search(String query, List<String> types, Integer pageNumber, Integer pageSize, Map<String, String> filters) {
        log.info("Querying {} for term {}", types, (Object)query);
        List<Map<String, Object>> results = KubernetesV2SearchProvider.paginateResults(this.getMatches(query, types, filters), pageSize, pageNumber);
        return SearchResultSet.builder().pageNumber(pageNumber).pageSize(pageSize).platform(this.getPlatform()).query(query).totalMatches(Integer.valueOf(results.size())).results(results).build();
    }

    private Map<String, Object> convertKeyToMap(String key) {
        Map<String, Object> result;
        String type;
        Optional<Keys.CacheKey> optional = Keys.parseKey(key);
        if (!optional.isPresent()) {
            return null;
        }
        Keys.CacheKey parsedKey = optional.get();
        if (parsedKey instanceof Keys.InfrastructureCacheKey) {
            Keys.InfrastructureCacheKey infraKey = (Keys.InfrastructureCacheKey)parsedKey;
            type = this.kindMap.translateKubernetesKind(infraKey.getKubernetesKind()).toString();
            KubernetesResourceProperties properties = this.registry.get(infraKey.getAccount(), infraKey.getKubernetesKind());
            if (properties == null) {
                log.warn("No hydrator for type {}, this is possibly a developer error", (Object)infraKey.getKubernetesKind());
                return null;
            }
            result = properties.getHandler().hydrateSearchResult(infraKey, this.cacheUtils);
        } else if (parsedKey instanceof Keys.LogicalKey) {
            Keys.LogicalKey logicalKey = (Keys.LogicalKey)parsedKey;
            result = (Map<String, Object>)this.mapper.convertValue((Object)parsedKey, (TypeReference)new TypeReference<Map<String, Object>>(){});
            result.put(logicalKey.getLogicalKind().singular(), logicalKey.getName());
            type = parsedKey.getGroup();
        } else {
            log.warn("Unknown key type " + parsedKey + ", ignoring.");
            return null;
        }
        result.put("type", type);
        return result;
    }

    private Map<String, List<String>> getKeysRelatedToLogicalMatches(String matchQuery) {
        return this.logicalTypes.stream().map(type -> this.cacheUtils.getAllDataMatchingPattern((String)type, matchQuery).stream().map(e -> e.getRelationships().values().stream().flatMap(Collection::stream).filter(Objects::nonNull).map(k -> new ImmutablePair(k, (Object)e.getId()))).flatMap(x -> x)).flatMap(x -> x).collect(Collectors.groupingBy(Pair::getLeft, Collectors.reducing(Collections.emptyList(), i -> Collections.singletonList(i.getRight()), (a, b) -> {
            ArrayList res = new ArrayList();
            res.addAll(a);
            res.addAll(b);
            return res;
        })));
    }

    private List<Map<String, Object>> getMatches(String query, List<String> types, Map<String, String> filters) {
        String matchQuery = String.format("*%s*", query.toLowerCase());
        HashSet<String> typesToSearch = new HashSet<String>(types);
        HashSet<String> typesToMatch = new HashSet<String>(types);
        typesToSearch.addAll(types.stream().map(t -> {
            try {
                return KubernetesSpinnakerKindMap.SpinnakerKind.fromString(t);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }).filter(Objects::nonNull).map(this.kindMap::translateSpinnakerKind).flatMap(Collection::stream).map(KubernetesKind::toString).collect(Collectors.toSet()));
        typesToSearch.retainAll(this.allCaches);
        List<Map<String, Object>> results = typesToSearch.stream().map(type -> this.cacheUtils.getAllKeysMatchingPattern((String)type, matchQuery)).flatMap(Collection::stream).map(this::convertKeyToMap).filter(Objects::nonNull).collect(Collectors.toList());
        Map<String, List<String>> keyToAllLogicalKeys = this.getKeysRelatedToLogicalMatches(matchQuery);
        results.addAll(keyToAllLogicalKeys.entrySet().stream().map(kv -> {
            Map<String, Object> result = this.convertKeyToMap((String)kv.getKey());
            if (result == null) {
                return null;
            }
            ((List)kv.getValue()).stream().map(Keys::parseKey).filter(Optional::isPresent).map(Optional::get).filter(Keys.LogicalKey.class::isInstance).map(k -> (Keys.LogicalKey)k).forEach(k -> result.put(k.getLogicalKind().singular(), k.getName()));
            return result;
        }).filter(Objects::nonNull).collect(Collectors.toList()));
        results = results.stream().filter(r -> typesToMatch.contains(r.get("type")) || typesToMatch.contains(r.get("group"))).collect(Collectors.toList());
        return results;
    }

    private static <T> List<T> paginateResults(List<T> matches, Integer pageSize, Integer pageNumber) {
        Integer startingIndex = pageSize * (pageNumber - 1);
        Integer endIndex = Math.min(pageSize * pageNumber, matches.size());
        return startingIndex < endIndex ? matches.subList(startingIndex, endIndex) : new ArrayList();
    }
}

