/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.cats.agent.AgentDataType;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesNamedAccountCredentials;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent.KubernetesV2OnDemandCachingAgent;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesResourcePropertyRegistry;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.security.KubernetesV2Credentials;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class CustomKubernetesCachingAgentFactory {
    public static KubernetesV2OnDemandCachingAgent create(KubernetesKind kind, KubernetesNamedAccountCredentials<KubernetesV2Credentials> namedAccountCredentials, KubernetesResourcePropertyRegistry propertyRegistry, ObjectMapper objectMapper, Registry registry, int agentIndex, int agentCount, Long agentInterval) {
        return new Agent(kind, namedAccountCredentials, propertyRegistry, objectMapper, registry, agentIndex, agentCount, agentInterval);
    }

    private static class Agent
    extends KubernetesV2OnDemandCachingAgent {
        private final KubernetesKind kind;

        Agent(KubernetesKind kind, KubernetesNamedAccountCredentials<KubernetesV2Credentials> namedAccountCredentials, KubernetesResourcePropertyRegistry propertyRegistry, ObjectMapper objectMapper, Registry registry, int agentIndex, int agentCount, Long agentInterval) {
            super(namedAccountCredentials, propertyRegistry, objectMapper, registry, agentIndex, agentCount, agentInterval);
            this.kind = kind;
        }

        @Override
        protected KubernetesKind primaryKind() {
            return this.kind;
        }

        public final Collection<AgentDataType> getProvidedDataTypes() {
            return Collections.unmodifiableSet(new HashSet<AgentDataType>(Collections.singletonList(AgentDataType.Authority.AUTHORITATIVE.forType(this.kind.toString()))));
        }

        @Override
        public String getAgentType() {
            return String.format("%s/CustomKubernetes(%s)[%d/%d]", this.accountName, this.kind, this.agentIndex + 1, this.agentCount);
        }
    }
}

