/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.model;

import com.netflix.spinnaker.clouddriver.kubernetes.KubernetesCloudProvider;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.Keys;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.model.KubernetesV2LoadBalancer;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.model.KubernetesV2ServerGroup;
import com.netflix.spinnaker.clouddriver.model.Cluster;
import com.netflix.spinnaker.clouddriver.model.LoadBalancer;
import com.netflix.spinnaker.clouddriver.model.ServerGroup;
import com.netflix.spinnaker.moniker.Moniker;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class KubernetesV2Cluster
implements Cluster {
    String name;
    Moniker moniker;
    String type = KubernetesCloudProvider.getID();
    String accountName;
    Set<ServerGroup> serverGroups = new HashSet<ServerGroup>();
    Set<LoadBalancer> loadBalancers = new HashSet<LoadBalancer>();
    String application;

    public KubernetesV2Cluster(String rawKey) {
        Keys.ClusterCacheKey key = (Keys.ClusterCacheKey)Keys.parseKey(rawKey).get();
        this.name = key.getName();
        this.accountName = key.getAccount();
        this.application = key.getApplication();
        this.moniker = Moniker.builder().cluster(this.name).app(this.application).build();
    }

    public KubernetesV2Cluster(String rawKey, List<KubernetesV2ServerGroup> serverGroups, List<KubernetesV2LoadBalancer> loadBalancers) {
        this(rawKey);
        this.serverGroups = serverGroups.stream().map(sg -> sg).collect(Collectors.toSet());
        this.loadBalancers = loadBalancers.stream().map(sg -> sg).collect(Collectors.toSet());
    }

    public String getName() {
        return this.name;
    }

    public Moniker getMoniker() {
        return this.moniker;
    }

    public String getType() {
        return this.type;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public Set<ServerGroup> getServerGroups() {
        return this.serverGroups;
    }

    public Set<LoadBalancer> getLoadBalancers() {
        return this.loadBalancers;
    }

    public String getApplication() {
        return this.application;
    }

    public KubernetesV2Cluster setName(String name) {
        this.name = name;
        return this;
    }

    public KubernetesV2Cluster setMoniker(Moniker moniker) {
        this.moniker = moniker;
        return this;
    }

    public KubernetesV2Cluster setType(String type) {
        this.type = type;
        return this;
    }

    public KubernetesV2Cluster setAccountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    public KubernetesV2Cluster setServerGroups(Set<ServerGroup> serverGroups) {
        this.serverGroups = serverGroups;
        return this;
    }

    public KubernetesV2Cluster setLoadBalancers(Set<LoadBalancer> loadBalancers) {
        this.loadBalancers = loadBalancers;
        return this;
    }

    public KubernetesV2Cluster setApplication(String application) {
        this.application = application;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KubernetesV2Cluster)) {
            return false;
        }
        KubernetesV2Cluster other = (KubernetesV2Cluster)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Moniker this$moniker = this.getMoniker();
        Moniker other$moniker = other.getMoniker();
        if (this$moniker == null ? other$moniker != null : !this$moniker.equals(other$moniker)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$accountName = this.getAccountName();
        String other$accountName = other.getAccountName();
        if (this$accountName == null ? other$accountName != null : !this$accountName.equals(other$accountName)) {
            return false;
        }
        Set<ServerGroup> this$serverGroups = this.getServerGroups();
        Set<ServerGroup> other$serverGroups = other.getServerGroups();
        if (this$serverGroups == null ? other$serverGroups != null : !((Object)this$serverGroups).equals(other$serverGroups)) {
            return false;
        }
        Set<LoadBalancer> this$loadBalancers = this.getLoadBalancers();
        Set<LoadBalancer> other$loadBalancers = other.getLoadBalancers();
        if (this$loadBalancers == null ? other$loadBalancers != null : !((Object)this$loadBalancers).equals(other$loadBalancers)) {
            return false;
        }
        String this$application = this.getApplication();
        String other$application = other.getApplication();
        return !(this$application == null ? other$application != null : !this$application.equals(other$application));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KubernetesV2Cluster;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Moniker $moniker = this.getMoniker();
        result = result * 59 + ($moniker == null ? 43 : $moniker.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $accountName = this.getAccountName();
        result = result * 59 + ($accountName == null ? 43 : $accountName.hashCode());
        Set<ServerGroup> $serverGroups = this.getServerGroups();
        result = result * 59 + ($serverGroups == null ? 43 : ((Object)$serverGroups).hashCode());
        Set<LoadBalancer> $loadBalancers = this.getLoadBalancers();
        result = result * 59 + ($loadBalancers == null ? 43 : ((Object)$loadBalancers).hashCode());
        String $application = this.getApplication();
        result = result * 59 + ($application == null ? 43 : $application.hashCode());
        return result;
    }

    public String toString() {
        return "KubernetesV2Cluster(name=" + this.getName() + ", moniker=" + this.getMoniker() + ", type=" + this.getType() + ", accountName=" + this.getAccountName() + ", serverGroups=" + this.getServerGroups() + ", loadBalancers=" + this.getLoadBalancers() + ", application=" + this.getApplication() + ")";
    }
}

