/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.provider;

import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesNamedAccountCredentials;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.model.KubernetesV2Manifest;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesResourceProperties;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesResourcePropertyRegistry;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifestAnnotater;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.KubernetesHandler;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.security.KubernetesV2Credentials;
import com.netflix.spinnaker.clouddriver.model.ManifestProvider;
import com.netflix.spinnaker.clouddriver.security.AccountCredentials;
import com.netflix.spinnaker.clouddriver.security.AccountCredentialsRepository;
import com.netflix.spinnaker.moniker.Moniker;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public abstract class KubernetesV2AbstractManifestProvider
implements ManifestProvider<KubernetesV2Manifest> {
    private static final Logger log = LoggerFactory.getLogger(KubernetesV2AbstractManifestProvider.class);

    protected abstract AccountCredentialsRepository getCredentialsRepository();

    protected abstract KubernetesResourcePropertyRegistry getRegistry();

    protected Optional<KubernetesV2Credentials> getCredentials(String account) {
        AccountCredentials credentials = this.getCredentialsRepository().getOne(account);
        if (credentials == null || !(credentials instanceof KubernetesNamedAccountCredentials)) {
            return Optional.empty();
        }
        if (!(credentials.getCredentials() instanceof KubernetesV2Credentials)) {
            return Optional.empty();
        }
        return Optional.ofNullable((KubernetesV2Credentials)credentials.getCredentials());
    }

    protected boolean isAccountRelevant(String account) {
        return this.getCredentials(account).isPresent();
    }

    protected boolean makesLiveCalls(String account) {
        return this.getCredentials(account).map(KubernetesV2Credentials::isLiveManifestCalls).orElseThrow(() -> new IllegalArgumentException("Account " + account + " is not a Kubernetess v2 account"));
    }

    protected KubernetesV2Manifest buildManifest(String account, KubernetesManifest manifest, List<KubernetesManifest> events, List<Map> metrics) {
        String namespace = manifest.getNamespace();
        KubernetesKind kind = manifest.getKind();
        KubernetesResourceProperties properties = this.getRegistry().get(account, kind);
        if (properties == null) {
            return null;
        }
        Function<KubernetesManifest, String> lastEventTimestamp = m -> m.getOrDefault("lastTimestamp", m.getOrDefault("firstTimestamp", "n/a"));
        events = events.stream().sorted(Comparator.comparing(lastEventTimestamp)).collect(Collectors.toList());
        Moniker moniker = KubernetesManifestAnnotater.getMoniker(manifest);
        KubernetesHandler handler = properties.getHandler();
        new KubernetesV2Manifest();
        return KubernetesV2Manifest.builder().account(account).name(manifest.getFullResourceName()).location(namespace).manifest(manifest).moniker(moniker).status(handler.status(manifest)).artifacts(handler.listArtifacts(manifest)).events(events).warnings(handler.listWarnings(manifest)).metrics(metrics).build();
    }
}

