/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.provider;

import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.clouddriver.kubernetes.KubernetesCloudProvider;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesNamedAccountCredentials;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.Keys;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent.KubernetesCacheDataConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.model.KubernetesV2Instance;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.provider.KubernetesCacheUtils;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesSpinnakerKindMap;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.job.KubectlJobExecutor;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.security.KubernetesV2Credentials;
import com.netflix.spinnaker.clouddriver.model.ContainerLog;
import com.netflix.spinnaker.clouddriver.model.InstanceProvider;
import com.netflix.spinnaker.clouddriver.security.AccountCredentialsRepository;
import com.netflix.spinnaker.clouddriver.security.ProviderVersion;
import io.kubernetes.client.models.V1Container;
import io.kubernetes.client.models.V1Pod;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class KubernetesV2InstanceProvider
implements InstanceProvider<KubernetesV2Instance, List<ContainerLog>> {
    private static final Logger log = LoggerFactory.getLogger(KubernetesV2InstanceProvider.class);
    private final KubernetesCacheUtils cacheUtils;
    private final KubernetesSpinnakerKindMap kindMap;
    private final AccountCredentialsRepository accountCredentialsRepository;
    private final KubectlJobExecutor jobExecutor;

    @Autowired
    KubernetesV2InstanceProvider(KubernetesCacheUtils cacheUtils, KubernetesSpinnakerKindMap kindMap, AccountCredentialsRepository accountCredentialsRepository, KubectlJobExecutor jobExecutor) {
        this.cacheUtils = cacheUtils;
        this.kindMap = kindMap;
        this.accountCredentialsRepository = accountCredentialsRepository;
        this.jobExecutor = jobExecutor;
    }

    public String getCloudProvider() {
        return KubernetesCloudProvider.getID();
    }

    public KubernetesV2Instance getInstance(String account, String location, String fullName) {
        Pair<KubernetesKind, String> parsedName;
        try {
            parsedName = KubernetesManifest.fromFullResourceName(fullName);
        }
        catch (Exception e) {
            return null;
        }
        KubernetesKind kind = (KubernetesKind)parsedName.getLeft();
        String name = (String)parsedName.getRight();
        String key = Keys.infrastructure(kind, account, location, name);
        Optional<CacheData> optionalInstanceData = this.cacheUtils.getSingleEntry(kind.toString(), key);
        if (!optionalInstanceData.isPresent()) {
            return null;
        }
        CacheData instanceData = optionalInstanceData.get();
        return KubernetesV2Instance.fromCacheData(instanceData);
    }

    public List<ContainerLog> getConsoleOutput(String account, String location, String fullName) {
        Pair<KubernetesKind, String> parsedName;
        KubernetesNamedAccountCredentials credentials;
        try {
            credentials = (KubernetesNamedAccountCredentials)this.accountCredentialsRepository.getOne(account);
        }
        catch (Exception e) {
            log.warn("Failure getting account {}", (Object)account);
            return null;
        }
        if (credentials == null || credentials.getProviderVersion() != ProviderVersion.v2) {
            return null;
        }
        try {
            parsedName = KubernetesManifest.fromFullResourceName(fullName);
        }
        catch (Exception e) {
            return null;
        }
        String name = (String)parsedName.getRight();
        V1Pod pod = KubernetesCacheDataConverter.getResource(((KubernetesV2Credentials)credentials.getCredentials()).get(KubernetesKind.POD, location, name), V1Pod.class);
        ArrayList<ContainerLog> result = new ArrayList<ContainerLog>();
        for (V1Container container : pod.getSpec().getContainers()) {
            ContainerLog log = new ContainerLog();
            log.setName(container.getName());
            try {
                log.setOutput(((KubernetesV2Credentials)credentials.getCredentials()).logs(location, name, container.getName()));
            }
            catch (KubectlJobExecutor.KubectlException e) {
                log.setOutput(e.getMessage());
            }
            result.add(log);
        }
        return result;
    }
}

