/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.provider;

import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.Keys;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.model.KubernetesV2ServerGroupManager;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.provider.KubernetesCacheUtils;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.provider.data.KubernetesV2ServerGroupManagerCacheData;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesResourcePropertyRegistry;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesSpinnakerKindMap;
import com.netflix.spinnaker.clouddriver.model.ServerGroupManagerProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class KubernetesV2ServerGroupManagerProvider
implements ServerGroupManagerProvider<KubernetesV2ServerGroupManager> {
    private final KubernetesResourcePropertyRegistry registry;
    private final KubernetesCacheUtils cacheUtils;

    @Autowired
    public KubernetesV2ServerGroupManagerProvider(KubernetesResourcePropertyRegistry registry, KubernetesCacheUtils cacheUtils) {
        this.registry = registry;
        this.cacheUtils = cacheUtils;
    }

    public Set<KubernetesV2ServerGroupManager> getServerGroupManagersByApplication(String application) {
        CacheData applicationDatum = this.cacheUtils.getSingleEntry(Keys.LogicalKind.APPLICATIONS.toString(), Keys.application(application)).orElse(null);
        if (applicationDatum == null) {
            return null;
        }
        Collection<CacheData> serverGroupManagerData = this.cacheUtils.getAllRelationshipsOfSpinnakerKind(Collections.singletonList(applicationDatum), KubernetesSpinnakerKindMap.SpinnakerKind.SERVER_GROUP_MANAGERS);
        Collection<CacheData> serverGroupData = this.cacheUtils.getAllRelationshipsOfSpinnakerKind(serverGroupManagerData, KubernetesSpinnakerKindMap.SpinnakerKind.SERVER_GROUPS);
        Map<String, List<CacheData>> managerToServerGroupMap = this.cacheUtils.mapByRelationship(serverGroupData, KubernetesSpinnakerKindMap.SpinnakerKind.SERVER_GROUP_MANAGERS);
        return serverGroupManagerData.stream().map(cd -> (KubernetesV2ServerGroupManager)this.cacheUtils.resourceModelFromCacheData(KubernetesV2ServerGroupManagerCacheData.builder().serverGroupManagerData((CacheData)cd).serverGroupData(managerToServerGroupMap.getOrDefault(cd.getId(), new ArrayList())).build())).collect(Collectors.toSet());
    }
}

