/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.description;

import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesResourceProperties;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesResourcePropertyRegistry;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.KubernetesHandler;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryUtils {
    private static final Logger log = LoggerFactory.getLogger(RegistryUtils.class);

    private static Optional<KubernetesHandler> lookupHandler(KubernetesResourcePropertyRegistry propertyRegistry, String account, KubernetesKind kind) {
        if (kind == null) {
            return Optional.empty();
        }
        KubernetesResourceProperties properties = propertyRegistry.get(account, kind);
        if (properties == null) {
            return Optional.empty();
        }
        KubernetesHandler handler = properties.getHandler();
        if (handler == null) {
            return Optional.empty();
        }
        return Optional.of(handler);
    }

    public static void removeSensitiveKeys(KubernetesResourcePropertyRegistry propertyRegistry, String account, KubernetesManifest manifest) {
        RegistryUtils.lookupHandler(propertyRegistry, account, manifest.getKind()).ifPresent(h -> h.removeSensitiveKeys(manifest));
    }

    public static void addRelationships(KubernetesResourcePropertyRegistry propertyRegistry, String account, KubernetesKind kind, Map<KubernetesKind, List<KubernetesManifest>> allResources, Map<KubernetesManifest, List<KubernetesManifest>> relationshipMap) {
        RegistryUtils.lookupHandler(propertyRegistry, account, kind).ifPresent(h -> h.addRelationships(allResources, relationshipMap));
    }
}

