/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler;

import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.OperationResult;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.job.KubectlJobExecutor;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.security.KubernetesSelectorList;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.security.KubernetesV2Credentials;
import io.kubernetes.client.models.V1DeleteOptions;

public interface CanDeploy {
    default public OperationResult deploy(KubernetesV2Credentials credentials, KubernetesManifest manifest, boolean recreate) {
        if (recreate) {
            try {
                credentials.delete(manifest.getKind(), manifest.getNamespace(), manifest.getName(), new KubernetesSelectorList(), new V1DeleteOptions());
            }
            catch (KubectlJobExecutor.KubectlException kubectlException) {
                // empty catch block
            }
        }
        credentials.deploy(manifest);
        return new OperationResult().addManifest(manifest);
    }
}

