/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler;

import com.netflix.spinnaker.clouddriver.kubernetes.v2.artifact.ArtifactReplacerFactory;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent.KubernetesCacheDataConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent.KubernetesCoreCachingAgent;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent.KubernetesV2CachingAgent;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesSpinnakerKindMap;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.CanDelete;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.KubernetesHandler;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.ServerGroupHandler;
import com.netflix.spinnaker.clouddriver.model.Manifest;
import io.kubernetes.client.models.V2alpha1CronJob;
import io.kubernetes.client.models.V2alpha1CronJobStatus;
import org.springframework.stereotype.Component;

@Component
public class KubernetesCronJobHandler
extends KubernetesHandler
implements CanDelete,
ServerGroupHandler {
    public KubernetesCronJobHandler() {
        this.registerReplacer(ArtifactReplacerFactory.dockerImageReplacer());
        this.registerReplacer(ArtifactReplacerFactory.configMapVolumeReplacer());
        this.registerReplacer(ArtifactReplacerFactory.secretVolumeReplacer());
        this.registerReplacer(ArtifactReplacerFactory.configMapEnvFromReplacer());
        this.registerReplacer(ArtifactReplacerFactory.secretEnvFromReplacer());
        this.registerReplacer(ArtifactReplacerFactory.configMapKeyValueFromReplacer());
        this.registerReplacer(ArtifactReplacerFactory.secretKeyValueFromReplacer());
    }

    @Override
    public int deployPriority() {
        return KubernetesHandler.DeployPriority.WORKLOAD_CONTROLLER_PRIORITY.getValue();
    }

    @Override
    public KubernetesKind kind() {
        return KubernetesKind.CRON_JOB;
    }

    @Override
    public boolean versioned() {
        return false;
    }

    @Override
    public KubernetesSpinnakerKindMap.SpinnakerKind spinnakerKind() {
        return KubernetesSpinnakerKindMap.SpinnakerKind.SERVER_GROUPS;
    }

    @Override
    public Manifest.Status status(KubernetesManifest manifest) {
        V2alpha1CronJob v2alpha1CronJob = KubernetesCacheDataConverter.getResource(manifest, V2alpha1CronJob.class);
        return this.status(v2alpha1CronJob);
    }

    @Override
    public Class<? extends KubernetesV2CachingAgent> cachingAgentClass() {
        return KubernetesCoreCachingAgent.class;
    }

    private Manifest.Status status(V2alpha1CronJob job) {
        Manifest.Status result = new Manifest.Status();
        V2alpha1CronJobStatus status = job.getStatus();
        if (status == null) {
            result.unstable("No status reported yet").unavailable("No availability reported");
            return result;
        }
        return result;
    }
}

