/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesNamedAccountCredentials;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.artifact.ArtifactReplacer;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.Keys;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent.KubernetesV2CachingAgent;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.provider.KubernetesCacheUtils;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesResourcePropertyRegistry;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesSpinnakerKindMap;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.CanDelete;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.CanDeploy;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.CanPatch;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.security.KubernetesV2Credentials;
import com.netflix.spinnaker.clouddriver.model.Manifest;
import com.netflix.spinnaker.clouddriver.model.ManifestProvider;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KubernetesHandler
implements CanDeploy,
CanDelete,
CanPatch {
    private static final Logger log = LoggerFactory.getLogger(KubernetesHandler.class);
    protected static final ObjectMapper objectMapper = new ObjectMapper();
    private final ArtifactReplacer artifactReplacer = new ArtifactReplacer();

    public abstract int deployPriority();

    @Override
    public abstract KubernetesKind kind();

    public abstract boolean versioned();

    public abstract KubernetesSpinnakerKindMap.SpinnakerKind spinnakerKind();

    public abstract Manifest.Status status(KubernetesManifest var1);

    public List<Manifest.Warning> listWarnings(KubernetesManifest manifest) {
        return new ArrayList<Manifest.Warning>();
    }

    public List<String> sensitiveKeys() {
        return new ArrayList<String>();
    }

    protected void registerReplacer(ArtifactReplacer.Replacer replacer) {
        this.artifactReplacer.addReplacer(replacer);
    }

    public ArtifactReplacer.ReplaceResult replaceArtifacts(KubernetesManifest manifest, List<Artifact> artifacts, String account) {
        return this.artifactReplacer.replaceAll(manifest, artifacts, manifest.getNamespace(), account);
    }

    public ArtifactReplacer.ReplaceResult replaceArtifacts(KubernetesManifest manifest, List<Artifact> artifacts, String namespace, String account) {
        return this.artifactReplacer.replaceAll(manifest, artifacts, namespace, account);
    }

    protected Class<? extends KubernetesV2CachingAgent> cachingAgentClass() {
        return null;
    }

    public Set<Artifact> listArtifacts(KubernetesManifest manifest) {
        return this.artifactReplacer.findAll(manifest);
    }

    public KubernetesV2CachingAgent buildCachingAgent(KubernetesNamedAccountCredentials<KubernetesV2Credentials> namedAccountCredentials, KubernetesResourcePropertyRegistry propertyRegistry, ObjectMapper objectMapper, Registry registry, int agentIndex, int agentCount, Long agentInterval) {
        Constructor<? extends KubernetesV2CachingAgent> constructor;
        Class<? extends KubernetesV2CachingAgent> clazz = this.cachingAgentClass();
        if (clazz == null) {
            log.error("No caching agent was registered for {} -- no resources will be cached", (Object)this.kind());
        }
        try {
            constructor = clazz.getDeclaredConstructor(KubernetesNamedAccountCredentials.class, KubernetesResourcePropertyRegistry.class, ObjectMapper.class, Registry.class, Integer.TYPE, Integer.TYPE, Long.class);
        }
        catch (NoSuchMethodException e) {
            log.warn("Missing canonical constructor for {} caching agent", (Object)this.kind(), (Object)e);
            return null;
        }
        try {
            constructor.setAccessible(true);
            return constructor.newInstance(namedAccountCredentials, propertyRegistry, objectMapper, registry, agentIndex, agentCount, agentInterval);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            log.warn("Can't invoke caching agent constructor for {} caching agent", (Object)this.kind(), (Object)e);
            return null;
        }
    }

    public void removeSensitiveKeys(KubernetesManifest manifest) {
        List<String> sensitiveKeys = this.sensitiveKeys();
        sensitiveKeys.forEach(manifest::remove);
    }

    public Map<String, Object> hydrateSearchResult(Keys.InfrastructureCacheKey key, KubernetesCacheUtils cacheUtils) {
        Map result = (Map)objectMapper.convertValue((Object)key, (TypeReference)new TypeReference<Map<String, Object>>(){});
        result.put("region", key.getNamespace());
        result.put("name", KubernetesManifest.getFullResourceName(key.getKubernetesKind(), key.getName()));
        return result;
    }

    public void addRelationships(Map<KubernetesKind, List<KubernetesManifest>> allResources, Map<KubernetesManifest, List<KubernetesManifest>> relationshipMap) {
    }

    public Comparator<KubernetesManifest> comparatorFor(ManifestProvider.Sort sort) {
        switch (sort) {
            case AGE: {
                return this.ageComparator();
            }
            case SIZE: {
                return this.sizeComparator();
            }
        }
        throw new IllegalArgumentException("No comparator for " + sort + " found");
    }

    protected Comparator<KubernetesManifest> ageComparator() {
        return Comparator.comparing(KubernetesManifest::getCreationTimestamp);
    }

    protected Comparator<KubernetesManifest> sizeComparator() {
        return Comparator.comparing(m -> m.getReplicas() == null ? -1.0 : m.getReplicas());
    }

    public static enum DeployPriority {
        LOWEST_PRIORITY(1000),
        WORKLOAD_ATTACHMENT_PRIORITY(110),
        WORKLOAD_CONTROLLER_PRIORITY(100),
        WORKLOAD_PRIORITY(100),
        WORKLOAD_MODIFIER_PRIORITY(90),
        PDB_PRIORITY(90),
        API_SERVICE_PRIORITY(80),
        NETWORK_RESOURCE_PRIORITY(70),
        MOUNTABLE_DATA_PRIORITY(50),
        MOUNTABLE_DATA_BACKING_RESOURCE_PRIORITY(40),
        SERVICE_ACCOUNT_PRIORITY(40),
        STORAGE_CLASS_PRIORITY(40),
        ADMISSION_PRIORITY(40),
        RESOURCE_DEFINITION_PRIORITY(30),
        ROLE_BINDING_PRIORITY(30),
        ROLE_PRIORITY(20),
        NAMESPACE_PRIORITY(0);

        private final int value;

        private DeployPriority(int value) {
            this.value = value;
        }

        public static DeployPriority fromString(String val) {
            if (val == null) {
                return null;
            }
            return Arrays.stream(DeployPriority.values()).filter(v -> v.toString().equalsIgnoreCase(val)).findFirst().orElseThrow(() -> new IllegalArgumentException("No such priority '" + val + "'"));
        }

        public int getValue() {
            return this.value;
        }
    }
}

