/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.op.job;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import com.netflix.spinnaker.clouddriver.jobs.JobExecutor;
import com.netflix.spinnaker.clouddriver.jobs.JobRequest;
import com.netflix.spinnaker.clouddriver.jobs.JobResult;
import com.netflix.spinnaker.clouddriver.jobs.local.ReaderConsumer;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.JsonPatch;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesPatchOptions;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesPodMetric;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.security.KubernetesSelectorList;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.security.KubernetesV2Credentials;
import io.kubernetes.client.models.V1DeleteOptions;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class KubectlJobExecutor {
    private static final Logger log = LoggerFactory.getLogger(KubectlJobExecutor.class);
    @Value(value="${kubernetes.kubectl.executable:kubectl}")
    String executable;
    @Value(value="${kubernetes.oAuth.executable:oauth2l}")
    String oAuthExecutable;
    private static final String NO_RESOURCE_TYPE_ERROR = "doesn't have a resource type";
    private final JobExecutor jobExecutor;
    private final Gson gson = new Gson();

    @Autowired
    KubectlJobExecutor(JobExecutor jobExecutor) {
        this.jobExecutor = jobExecutor;
    }

    public String configCurrentContext(KubernetesV2Credentials credentials) {
        List<String> command = this.kubectlAuthPrefix(credentials);
        command.add("config");
        command.add("current-context");
        JobResult status = this.jobExecutor.runJob(new JobRequest(command));
        if (status.getResult() != JobResult.Result.SUCCESS) {
            throw new KubectlException("Failed get current configuration context");
        }
        return (String)status.getOutput();
    }

    public String defaultNamespace(KubernetesV2Credentials credentials) {
        String configCurrentContext = this.configCurrentContext(credentials);
        if (StringUtils.isEmpty((CharSequence)configCurrentContext)) {
            return "";
        }
        List<String> command = this.kubectlAuthPrefix(credentials);
        command.add("config");
        command.add("view");
        command.add("-o");
        String jsonPath = "{.contexts[?(@.name==\"" + configCurrentContext + "\")].context.namespace}";
        command.add("\"jsonPath=" + jsonPath + "\"");
        JobResult status = this.jobExecutor.runJob(new JobRequest(command));
        if (status.getResult() != JobResult.Result.SUCCESS) {
            throw new KubectlException("Failed get current configuration context");
        }
        return (String)status.getOutput();
    }

    public String logs(KubernetesV2Credentials credentials, String namespace, String podName, String containerName) {
        List<String> command = this.kubectlNamespacedAuthPrefix(credentials, namespace);
        command.add("logs");
        command.add(podName);
        command.add("-c=" + containerName);
        JobResult status = this.jobExecutor.runJob(new JobRequest(command));
        if (status.getResult() != JobResult.Result.SUCCESS) {
            throw new KubectlException("Failed to get logs from " + podName + "/" + containerName + " in " + namespace + ": " + status.getError());
        }
        return (String)status.getOutput();
    }

    public String jobLogs(KubernetesV2Credentials credentials, String namespace, String jobName) {
        List<String> command = this.kubectlNamespacedAuthPrefix(credentials, namespace);
        command.add("logs");
        command.add("job/" + jobName);
        JobResult status = this.jobExecutor.runJob(new JobRequest(command));
        if (status.getResult() != JobResult.Result.SUCCESS) {
            throw new KubectlException("Failed to get logs from job/" + jobName + " in " + namespace + ": " + status.getError());
        }
        return (String)status.getOutput();
    }

    public List<String> delete(KubernetesV2Credentials credentials, KubernetesKind kind, String namespace, String name, KubernetesSelectorList labelSelectors, V1DeleteOptions deleteOptions) {
        List<String> command = this.kubectlNamespacedAuthPrefix(credentials, namespace);
        command.add("delete");
        command = this.kubectlLookupInfo(command, kind, name, labelSelectors);
        command.add("--ignore-not-found=true");
        if (deleteOptions.isOrphanDependents() != null) {
            command.add("--cascade=" + (deleteOptions.isOrphanDependents() == false));
        }
        if (deleteOptions.getGracePeriodSeconds() != null) {
            command.add("--grace-period=" + deleteOptions.getGracePeriodSeconds());
        }
        if (StringUtils.isNotEmpty((CharSequence)deleteOptions.getPropagationPolicy())) {
            throw new IllegalArgumentException("Propagation policy is not yet supported as a delete option");
        }
        JobResult status = this.jobExecutor.runJob(new JobRequest(command));
        if (status.getResult() != JobResult.Result.SUCCESS) {
            String id = StringUtils.isNotEmpty((CharSequence)name) ? kind + "/" + name : labelSelectors.toString();
            throw new KubectlException("Failed to delete " + id + " from " + namespace + ": " + status.getError());
        }
        if (StringUtils.isEmpty((CharSequence)((CharSequence)status.getOutput())) || ((String)status.getOutput()).equals("No output from command.") || ((String)status.getOutput()).startsWith("No resources found")) {
            return new ArrayList<String>();
        }
        return Arrays.stream(((String)status.getOutput()).split("\n")).map(m -> m.substring(m.indexOf("\"") + 1)).map(m -> m.substring(0, m.lastIndexOf("\""))).collect(Collectors.toList());
    }

    public Void scale(KubernetesV2Credentials credentials, KubernetesKind kind, String namespace, String name, int replicas) {
        List<String> command = this.kubectlNamespacedAuthPrefix(credentials, namespace);
        command.add("scale");
        command = this.kubectlLookupInfo(command, kind, name, null);
        command.add("--replicas=" + replicas);
        JobResult status = this.jobExecutor.runJob(new JobRequest(command));
        if (status.getResult() != JobResult.Result.SUCCESS) {
            throw new KubectlException("Failed to scale " + kind + "/" + name + " from " + namespace + ": " + status.getError());
        }
        return null;
    }

    public List<Integer> historyRollout(KubernetesV2Credentials credentials, KubernetesKind kind, String namespace, String name) {
        List<String> command = this.kubectlNamespacedAuthPrefix(credentials, namespace);
        command.add("rollout");
        command.add("history");
        command.add(kind.toString() + "/" + name);
        JobResult status = this.jobExecutor.runJob(new JobRequest(command));
        if (status.getResult() != JobResult.Result.SUCCESS) {
            throw new KubectlException("Failed to get rollout history of " + kind + "/" + name + " from " + namespace + ": " + status.getError());
        }
        String stdout = (String)status.getOutput();
        if (StringUtils.isEmpty((CharSequence)stdout)) {
            return new ArrayList<Integer>();
        }
        List splitOutput = Arrays.stream(stdout.split("\n")).collect(Collectors.toList());
        if (splitOutput.size() <= 2) {
            return new ArrayList<Integer>();
        }
        splitOutput = splitOutput.subList(2, splitOutput.size());
        return splitOutput.stream().map(l -> l.split("[ \t]")).filter(l -> ((String[])l).length > 0).map(l -> l[0]).map(Integer::valueOf).collect(Collectors.toList());
    }

    public Void undoRollout(KubernetesV2Credentials credentials, KubernetesKind kind, String namespace, String name, int revision) {
        List<String> command = this.kubectlNamespacedAuthPrefix(credentials, namespace);
        command.add("rollout");
        command.add("undo");
        command.add(kind.toString() + "/" + name);
        command.add("--to-revision=" + revision);
        JobResult status = this.jobExecutor.runJob(new JobRequest(command));
        if (status.getResult() != JobResult.Result.SUCCESS) {
            throw new KubectlException("Failed to undo rollout " + kind + "/" + name + " from " + namespace + ": " + status.getError());
        }
        return null;
    }

    public Void pauseRollout(KubernetesV2Credentials credentials, KubernetesKind kind, String namespace, String name) {
        List<String> command = this.kubectlNamespacedAuthPrefix(credentials, namespace);
        command.add("rollout");
        command.add("pause");
        command.add(kind.toString() + "/" + name);
        JobResult status = this.jobExecutor.runJob(new JobRequest(command));
        if (status.getResult() != JobResult.Result.SUCCESS) {
            throw new KubectlException("Failed to pause rollout " + kind + "/" + name + " from " + namespace + ": " + status.getError());
        }
        return null;
    }

    public Void resumeRollout(KubernetesV2Credentials credentials, KubernetesKind kind, String namespace, String name) {
        List<String> command = this.kubectlNamespacedAuthPrefix(credentials, namespace);
        command.add("rollout");
        command.add("resume");
        command.add(kind.toString() + "/" + name);
        JobResult status = this.jobExecutor.runJob(new JobRequest(command));
        if (status.getResult() != JobResult.Result.SUCCESS) {
            throw new KubectlException("Failed to resume rollout " + kind + "/" + name + " from " + namespace + ": " + status.getError());
        }
        return null;
    }

    public KubernetesManifest get(KubernetesV2Credentials credentials, KubernetesKind kind, String namespace, String name) {
        List<String> command = this.kubectlNamespacedGet(credentials, Collections.singletonList(kind), namespace);
        command.add(name);
        JobResult status = this.jobExecutor.runJob(new JobRequest(command));
        if (status.getResult() != JobResult.Result.SUCCESS) {
            if (status.getError().contains("(NotFound)")) {
                return null;
            }
            if (status.getError().contains(NO_RESOURCE_TYPE_ERROR)) {
                throw new NoResourceTypeException(status.getError());
            }
            throw new KubectlException("Failed to read " + kind + " from " + namespace + ": " + status.getError());
        }
        try {
            return (KubernetesManifest)this.gson.fromJson((String)status.getOutput(), KubernetesManifest.class);
        }
        catch (JsonSyntaxException e) {
            throw new KubectlException("Failed to parse kubectl output: " + e.getMessage(), e);
        }
    }

    public List<KubernetesManifest> eventsFor(KubernetesV2Credentials credentials, KubernetesKind kind, String namespace, String name) {
        List<String> command = this.kubectlNamespacedGet(credentials, Collections.singletonList(KubernetesKind.EVENT), namespace);
        command.add("--field-selector");
        command.add(String.format("involvedObject.name=%s,involvedObject.kind=%s", name, StringUtils.capitalize((String)kind.toString())));
        JobResult status = this.jobExecutor.runJob(new JobRequest(command), this.parseManifestList());
        if (status.getResult() != JobResult.Result.SUCCESS) {
            if (status.getError().contains(NO_RESOURCE_TYPE_ERROR)) {
                throw new NoResourceTypeException(status.getError());
            }
            throw new KubectlException("Failed to read events from " + namespace + ": " + status.getError());
        }
        if (status.getError().contains("No resources found")) {
            return new ArrayList<KubernetesManifest>();
        }
        return (List)status.getOutput();
    }

    public List<KubernetesManifest> list(KubernetesV2Credentials credentials, List<KubernetesKind> kinds, String namespace, KubernetesSelectorList selectors) {
        JobResult status;
        List<String> command = this.kubectlNamespacedGet(credentials, kinds, namespace);
        if (selectors.isNotEmpty()) {
            command.add("-l=" + selectors.toString());
        }
        if ((status = this.jobExecutor.runJob(new JobRequest(command), this.parseManifestList())).getResult() != JobResult.Result.SUCCESS) {
            if (status.getError().contains(NO_RESOURCE_TYPE_ERROR)) {
                throw new NoResourceTypeException(status.getError());
            }
            throw new KubectlException("Failed to read " + kinds + " from " + namespace + ": " + status.getError());
        }
        if (status.getError().contains("No resources found")) {
            return new ArrayList<KubernetesManifest>();
        }
        return (List)status.getOutput();
    }

    public Void deploy(KubernetesV2Credentials credentials, KubernetesManifest manifest) {
        List<String> command = this.kubectlAuthPrefix(credentials);
        String manifestAsJson = this.gson.toJson((Object)manifest);
        command.add("apply");
        command.add("-f");
        command.add("-");
        JobResult status = this.jobExecutor.runJob(new JobRequest(command, (InputStream)new ByteArrayInputStream(manifestAsJson.getBytes())));
        if (status.getResult() != JobResult.Result.SUCCESS) {
            throw new KubectlException("Deploy failed: " + status.getError());
        }
        return null;
    }

    private void logDebugMessages(String jobId, JobResult<String> jobResult) {
        if (jobResult != null) {
            log.info("{} stdout:\n{}", (Object)jobId, jobResult.getOutput());
            log.info("{} stderr:\n{}", (Object)jobId, (Object)jobResult.getError());
        } else {
            log.info("{} job status not set");
        }
    }

    private List<String> kubectlAuthPrefix(KubernetesV2Credentials credentials) {
        ArrayList<String> command = new ArrayList<String>();
        if (StringUtils.isNotEmpty((CharSequence)credentials.getKubectlExecutable())) {
            command.add(credentials.getKubectlExecutable());
        } else {
            command.add(this.executable);
        }
        if (credentials.getKubectlRequestTimeoutSeconds() != null) {
            command.add("--request-timeout=" + credentials.getKubectlRequestTimeoutSeconds());
        }
        if (credentials.isDebug()) {
            command.add("-v");
            command.add("9");
        }
        if (!credentials.isServiceAccount()) {
            String context;
            String kubeconfigFile;
            if (credentials.getOAuthServiceAccount() != null && !credentials.getOAuthServiceAccount().isEmpty()) {
                command.add("--token=" + this.getOAuthToken(credentials));
            }
            if (StringUtils.isNotEmpty((CharSequence)(kubeconfigFile = credentials.getKubeconfigFile()))) {
                command.add("--kubeconfig=" + kubeconfigFile);
            }
            if (StringUtils.isNotEmpty((CharSequence)(context = credentials.getContext()))) {
                command.add("--context=" + context);
            }
        }
        return command;
    }

    private List<String> kubectlLookupInfo(List<String> command, KubernetesKind kind, String name, KubernetesSelectorList labelSelectors) {
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            command.add(kind + "/" + name);
        } else {
            command.add(kind.toString());
        }
        if (labelSelectors != null && !labelSelectors.isEmpty()) {
            command.add("-l=" + labelSelectors);
        }
        return command;
    }

    private List<String> kubectlNamespacedAuthPrefix(KubernetesV2Credentials credentials, String namespace) {
        List<String> command = this.kubectlAuthPrefix(credentials);
        if (StringUtils.isEmpty((CharSequence)namespace)) {
            namespace = credentials.getDefaultNamespace();
        }
        if (StringUtils.isNotEmpty((CharSequence)namespace)) {
            command.add("--namespace=" + namespace);
        }
        return command;
    }

    private List<String> kubectlNamespacedGet(KubernetesV2Credentials credentials, List<KubernetesKind> kind, String namespace) {
        List<String> command = this.kubectlNamespacedAuthPrefix(credentials, namespace);
        command.add("-o");
        command.add("json");
        command.add("get");
        command.add(String.join((CharSequence)",", kind.stream().map(KubernetesKind::toString).collect(Collectors.toList())));
        return command;
    }

    private String getOAuthToken(KubernetesV2Credentials credentials) {
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.oAuthExecutable);
        command.add("fetch");
        command.add("--json");
        command.add(credentials.getOAuthServiceAccount());
        command.addAll(credentials.getOAuthScopes());
        JobResult status = this.jobExecutor.runJob(new JobRequest(command));
        if (status.getResult() != JobResult.Result.SUCCESS) {
            throw new KubectlException("Could not fetch OAuth token: " + status.getError());
        }
        return (String)status.getOutput();
    }

    public Collection<KubernetesPodMetric> topPod(KubernetesV2Credentials credentials, String namespace) {
        List<String> command = this.kubectlNamespacedAuthPrefix(credentials, namespace);
        command.add("top");
        command.add("po");
        command.add("--containers");
        JobResult status = this.jobExecutor.runJob(new JobRequest(command));
        if (status.getResult() != JobResult.Result.SUCCESS) {
            throw new KubectlException("Could not read metrics: " + status.getError());
        }
        HashMap<String, KubernetesPodMetric> result = new HashMap<String, KubernetesPodMetric>();
        String output = ((String)status.getOutput()).trim();
        if (StringUtils.isEmpty((CharSequence)output)) {
            log.warn("No output from `kubectl top` command, no metrics to report.");
            return new ArrayList<KubernetesPodMetric>();
        }
        String[] lines = output.split("\n");
        if (lines.length <= 1) {
            return new ArrayList<KubernetesPodMetric>();
        }
        Object[] header = lines[0].trim().split("\\s+");
        if (header.length <= 2) {
            log.warn("Unexpected metric format -- no metrics to report based on table header {}.", header);
            return new ArrayList<KubernetesPodMetric>();
        }
        String[] metricKeys = (String[])Arrays.copyOfRange(header, 2, header.length);
        for (int i = 1; i < lines.length; ++i) {
            String[] entry = lines[i].trim().split("\\s+");
            if (entry.length != header.length) {
                log.warn("Entry {} does not match column width of {}, skipping", (Object)entry, (Object)header);
            }
            String podName = entry[0];
            String containerName = entry[1];
            HashMap<String, String> metrics = new HashMap<String, String>();
            for (int j = 0; j < metricKeys.length; ++j) {
                metrics.put(metricKeys[j], entry[j + 2]);
            }
            KubernetesPodMetric.ContainerMetric containerMetric = KubernetesPodMetric.ContainerMetric.builder().containerName(containerName).metrics(metrics).build();
            KubernetesPodMetric podMetric = result.getOrDefault(podName, KubernetesPodMetric.builder().podName(podName).containerMetrics(new ArrayList<KubernetesPodMetric.ContainerMetric>()).build());
            podMetric.getContainerMetrics().add(containerMetric);
            result.put(podName, podMetric);
        }
        return result.values();
    }

    public Void patch(KubernetesV2Credentials credentials, KubernetesKind kind, String namespace, String name, KubernetesPatchOptions options, List<JsonPatch> patches) {
        return this.patch(credentials, kind, namespace, name, options, this.gson.toJson(patches));
    }

    public Void patch(KubernetesV2Credentials credentials, KubernetesKind kind, String namespace, String name, KubernetesPatchOptions options, KubernetesManifest manifest) {
        return this.patch(credentials, kind, namespace, name, options, this.gson.toJson((Object)manifest));
    }

    private Void patch(KubernetesV2Credentials credentials, KubernetesKind kind, String namespace, String name, KubernetesPatchOptions options, String patchBody) {
        String mergeStrategy;
        List<String> command = this.kubectlNamespacedAuthPrefix(credentials, namespace);
        command.add("patch");
        command.add(kind.toString());
        command.add(name);
        if (options.isRecord()) {
            command.add("--record");
        }
        if (StringUtils.isNotEmpty((CharSequence)(mergeStrategy = options.getMergeStrategy().toString()))) {
            command.add("--type");
            command.add(mergeStrategy);
        }
        command.add("--patch");
        command.add(patchBody);
        JobResult status = this.jobExecutor.runJob(new JobRequest(command));
        if (status.getResult() != JobResult.Result.SUCCESS) {
            String errMsg = status.getError();
            if (StringUtils.isEmpty((CharSequence)errMsg)) {
                errMsg = (String)status.getOutput();
            }
            if (errMsg.contains("not patched")) {
                log.warn("No change occurred after patching {} {}:{}, ignoring", new Object[]{kind, namespace, name});
                return null;
            }
            throw new KubectlException("Patch failed: " + errMsg);
        }
        return null;
    }

    private ReaderConsumer<List<KubernetesManifest>> parseManifestList() {
        return r -> {
            try (JsonReader reader = new JsonReader((Reader)r);){
                ArrayList<KubernetesManifest> manifestList = new ArrayList<KubernetesManifest>();
                reader.beginObject();
                while (reader.hasNext()) {
                    if (reader.nextName().equals("items")) {
                        reader.beginArray();
                        while (reader.hasNext()) {
                            KubernetesManifest manifest = (KubernetesManifest)this.gson.fromJson(reader, KubernetesManifest.class);
                            manifestList.add(manifest);
                        }
                        reader.endArray();
                        continue;
                    }
                    reader.skipValue();
                }
                reader.endObject();
                ArrayList<KubernetesManifest> arrayList = manifestList;
                return arrayList;
            }
        };
    }

    public static class KubectlException
    extends RuntimeException {
        public KubectlException(String message) {
            super(message);
        }

        public KubectlException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class NoResourceTypeException
    extends RuntimeException {
        public NoResourceTypeException(String message) {
            super(message);
        }
    }
}

