/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.op.manifest;

import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.JsonPatch;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesCoordinates;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesPatchOptions;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesResourcePropertyRegistry;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesEnableDisableManifestDescription;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifestAnnotater;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifestTraffic;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.OperationResult;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.CanLoadBalance;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.HasPods;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.security.KubernetesV2Credentials;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import java.util.List;
import org.apache.commons.lang.WordUtils;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbstractKubernetesEnableDisableManifestOperation
implements AtomicOperation<OperationResult> {
    private final KubernetesEnableDisableManifestDescription description;
    private final KubernetesV2Credentials credentials;
    private final KubernetesResourcePropertyRegistry registry;
    private final String accountName;
    private final String OP_NAME = this.getVerbName().toUpperCase() + "_MANIFEST";

    protected abstract String getVerbName();

    protected abstract List<JsonPatch> patchResource(CanLoadBalance var1, KubernetesManifest var2, KubernetesManifest var3);

    public AbstractKubernetesEnableDisableManifestOperation(KubernetesEnableDisableManifestDescription description, KubernetesResourcePropertyRegistry registry) {
        this.description = description;
        this.credentials = (KubernetesV2Credentials)description.getCredentials().getCredentials();
        this.accountName = description.getCredentials().getName();
        this.registry = registry;
    }

    private static Task getTask() {
        return (Task)TaskRepository.threadLocalTask.get();
    }

    public List<String> determineLoadBalancers(KubernetesManifest target) {
        AbstractKubernetesEnableDisableManifestOperation.getTask().updateStatus(this.OP_NAME, "Getting load balancer list to " + this.getVerbName() + "...");
        List<String> result = this.description.getLoadBalancers();
        if (result != null && !result.isEmpty()) {
            AbstractKubernetesEnableDisableManifestOperation.getTask().updateStatus(this.OP_NAME, "Using supplied list [" + String.join((CharSequence)", ", result) + "]");
        } else {
            KubernetesManifestTraffic traffic = KubernetesManifestAnnotater.getTraffic(target);
            result = traffic.getLoadBalancers();
            AbstractKubernetesEnableDisableManifestOperation.getTask().updateStatus(this.OP_NAME, "Using annotated list [" + String.join((CharSequence)", ", result) + "]");
        }
        return result;
    }

    private void op(String loadBalancerName, KubernetesManifest target) {
        Pair<KubernetesKind, String> name;
        try {
            name = KubernetesManifest.fromFullResourceName(loadBalancerName);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Load balancers must be specified in the form '<kind> <name>', e.g. 'service my-service'", e);
        }
        CanLoadBalance loadBalancerHandler = CanLoadBalance.lookupProperties(this.registry, this.accountName, name);
        KubernetesManifest loadBalancer = this.credentials.get((KubernetesKind)name.getLeft(), target.getNamespace(), (String)name.getRight());
        List<JsonPatch> patch = this.patchResource(loadBalancerHandler, loadBalancer, target);
        AbstractKubernetesEnableDisableManifestOperation.getTask().updateStatus(this.OP_NAME, "Patching target for '" + loadBalancerName + '\"');
        this.credentials.patch(target.getKind(), target.getNamespace(), target.getName(), KubernetesPatchOptions.json(), patch);
        HasPods podHandler = null;
        try {
            podHandler = HasPods.lookupProperties(this.registry, this.accountName, target.getKind());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (podHandler != null) {
            AbstractKubernetesEnableDisableManifestOperation.getTask().updateStatus(this.OP_NAME, "Patching pods for '" + loadBalancerName + '\"');
            List<KubernetesManifest> pods = podHandler.pods(this.credentials, target);
            for (KubernetesManifest pod : pods) {
                patch = this.patchResource(loadBalancerHandler, loadBalancer, pod);
                this.credentials.patch(pod.getKind(), pod.getNamespace(), pod.getName(), KubernetesPatchOptions.json(), patch);
            }
        }
    }

    public OperationResult operate(List priorOutputs) {
        AbstractKubernetesEnableDisableManifestOperation.getTask().updateStatus(this.OP_NAME, "Starting " + this.getVerbName() + " operation...");
        KubernetesCoordinates coordinates = this.description.getPointCoordinates();
        KubernetesManifest target = this.credentials.get(coordinates.getKind(), coordinates.getNamespace(), coordinates.getName());
        this.determineLoadBalancers(target).forEach(l -> this.op((String)l, target));
        AbstractKubernetesEnableDisableManifestOperation.getTask().updateStatus(this.OP_NAME, WordUtils.capitalize((String)this.getVerbName()) + " operation for " + coordinates + " succeeded");
        return null;
    }
}

