/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.op.manifest;

import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesCoordinates;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesResourceProperties;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesResourcePropertyRegistry;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesResumeRolloutManifestDescription;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.CanResumeRollout;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.handler.KubernetesHandler;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.security.KubernetesV2Credentials;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import java.util.List;

public class KubernetesResumeRolloutManifestOperation
implements AtomicOperation<Void> {
    private final KubernetesResumeRolloutManifestDescription description;
    private final KubernetesV2Credentials credentials;
    private final KubernetesResourcePropertyRegistry registry;
    private final String accountName;
    private static final String OP_NAME = "RESUME_ROLLOUT_KUBERNETES_MANIFEST";

    public KubernetesResumeRolloutManifestOperation(KubernetesResumeRolloutManifestDescription description, KubernetesResourcePropertyRegistry registry) {
        this.description = description;
        this.credentials = (KubernetesV2Credentials)description.getCredentials().getCredentials();
        this.accountName = description.getCredentials().getName();
        this.registry = registry;
    }

    private static Task getTask() {
        return (Task)TaskRepository.threadLocalTask.get();
    }

    public Void operate(List priorOutputs) {
        KubernetesResumeRolloutManifestOperation.getTask().updateStatus(OP_NAME, "Starting resume rollout operation...");
        KubernetesCoordinates coordinates = this.description.getPointCoordinates();
        KubernetesResumeRolloutManifestOperation.getTask().updateStatus(OP_NAME, "Looking up resource properties...");
        KubernetesResourceProperties properties = this.registry.get(this.accountName, coordinates.getKind());
        KubernetesHandler deployer = properties.getHandler();
        if (!(deployer instanceof CanResumeRollout)) {
            throw new IllegalArgumentException("Resource with " + coordinates + " does not support resume rollout");
        }
        CanResumeRollout canResumeRollout = (CanResumeRollout)((Object)deployer);
        KubernetesResumeRolloutManifestOperation.getTask().updateStatus(OP_NAME, "Calling resume rollout operation...");
        canResumeRollout.resumeRollout(this.credentials, coordinates.getNamespace(), coordinates.getName());
        return null;
    }
}

