/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.security;

import com.netflix.spinnaker.clouddriver.kubernetes.v2.security.KubernetesSelector;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.security.MatchExpression;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class KubernetesSelectorList {
    private final List<KubernetesSelector> selectors = new ArrayList<KubernetesSelector>();

    public KubernetesSelectorList() {
    }

    public KubernetesSelectorList(List<KubernetesSelector> selectors) {
        this.selectors.addAll(selectors);
    }

    public KubernetesSelectorList(KubernetesSelector ... selectors) {
        this.selectors.addAll(Arrays.asList(selectors));
    }

    public boolean isNotEmpty() {
        return !this.selectors.isEmpty();
    }

    public KubernetesSelectorList addSelector(KubernetesSelector selector) {
        this.selectors.add(selector);
        return this;
    }

    public KubernetesSelectorList addSelectors(KubernetesSelectorList selectors) {
        this.selectors.addAll(selectors.selectors);
        return this;
    }

    public boolean isEmpty() {
        return this.selectors.isEmpty();
    }

    public String toString() {
        return String.join((CharSequence)",", this.selectors.stream().map(KubernetesSelector::toString).collect(Collectors.toList()));
    }

    public static KubernetesSelectorList fromMatchLabels(Map<String, String> matchLabels) {
        return new KubernetesSelectorList(matchLabels.entrySet().stream().map(kv -> new KubernetesSelector(KubernetesSelector.Kind.EQUALS, (String)kv.getKey(), Collections.singletonList(kv.getValue()))).collect(Collectors.toList()));
    }

    public static KubernetesSelectorList fromMatchExpressions(List<MatchExpression> matchExpressions) {
        return new KubernetesSelectorList(matchExpressions.stream().map(KubernetesSelectorList::fromMatchExpression).collect(Collectors.toList()));
    }

    public static KubernetesSelector fromMatchExpression(MatchExpression matchExpression) {
        KubernetesSelector.Kind kind;
        switch (matchExpression.getOperator()) {
            case In: {
                kind = KubernetesSelector.Kind.CONTAINS;
                break;
            }
            case NotIn: {
                kind = KubernetesSelector.Kind.NOT_CONTAINS;
                break;
            }
            case Exists: {
                kind = KubernetesSelector.Kind.EXISTS;
                break;
            }
            case DoesNotExist: {
                kind = KubernetesSelector.Kind.NOT_EXISTS;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown operator: " + (Object)((Object)matchExpression.getOperator()));
            }
        }
        return new KubernetesSelector(kind, matchExpression.getKey(), matchExpression.getValues());
    }

    public List<KubernetesSelector> getSelectors() {
        return this.selectors;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KubernetesSelectorList)) {
            return false;
        }
        KubernetesSelectorList other = (KubernetesSelectorList)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<KubernetesSelector> this$selectors = this.getSelectors();
        List<KubernetesSelector> other$selectors = other.getSelectors();
        return !(this$selectors == null ? other$selectors != null : !((Object)this$selectors).equals(other$selectors));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KubernetesSelectorList;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<KubernetesSelector> $selectors = this.getSelectors();
        result = result * 59 + ($selectors == null ? 43 : ((Object)$selectors).hashCode());
        return result;
    }
}

