/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.validator.servergroup;

import com.netflix.spinnaker.clouddriver.deploy.DescriptionValidator;
import com.netflix.spinnaker.clouddriver.kubernetes.KubernetesOperation;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.servergroup.KubernetesResizeServerGroupDescription;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.validator.KubernetesValidationUtil;
import com.netflix.spinnaker.clouddriver.security.AccountCredentialsProvider;
import com.netflix.spinnaker.clouddriver.security.ProviderVersion;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;

@KubernetesOperation(value="resizeServerGroup")
@Component
public class KubernetesResizeServerGroupValidator
extends DescriptionValidator<KubernetesResizeServerGroupDescription> {
    @Autowired
    AccountCredentialsProvider provider;

    public void validate(List priorDescriptions, KubernetesResizeServerGroupDescription description, Errors errors) {
        KubernetesValidationUtil util = new KubernetesValidationUtil("deployKubernetesManifest", errors);
        if (!util.validateV2Credentials(this.provider, description.getAccount(), description.getCoordinates().getKind(), description.getCoordinates().getNamespace())) {
            return;
        }
        util.validateNotEmpty("capacity", description.getCapacity());
    }

    public boolean acceptsVersion(ProviderVersion version) {
        return version == ProviderVersion.v2;
    }
}

