/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.provider;

import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.clouddriver.kubernetes.KubernetesCloudProvider;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.Keys;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.model.KubernetesV2LoadBalancer;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.provider.KubernetesCacheUtils;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesSpinnakerKindMap;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.model.LoadBalancerProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class KubernetesV2LoadBalancerProvider
implements LoadBalancerProvider<KubernetesV2LoadBalancer> {
    private static final Logger log = LoggerFactory.getLogger(KubernetesV2LoadBalancerProvider.class);
    private final KubernetesCacheUtils cacheUtils;
    private final KubernetesSpinnakerKindMap kindMap;

    @Autowired
    KubernetesV2LoadBalancerProvider(KubernetesCacheUtils cacheUtils, KubernetesSpinnakerKindMap kindMap) {
        this.cacheUtils = cacheUtils;
        this.kindMap = kindMap;
    }

    public String getCloudProvider() {
        return KubernetesCloudProvider.getID();
    }

    public List<LoadBalancerProvider.Item> list() {
        return new ArrayList<LoadBalancerProvider.Item>();
    }

    public LoadBalancerProvider.Item get(String name) {
        throw new NotImplementedException("Not a valid operation");
    }

    public List<LoadBalancerProvider.Details> byAccountAndRegionAndName(String account, String namespace, String fullName) {
        Pair<KubernetesKind, String> parsedName;
        try {
            parsedName = KubernetesManifest.fromFullResourceName(fullName);
        }
        catch (Exception e) {
            return null;
        }
        KubernetesKind kind = (KubernetesKind)parsedName.getLeft();
        String name = (String)parsedName.getRight();
        String key = Keys.infrastructure(kind, account, name, name);
        Optional<CacheData> optionalLoadBalancerData = this.cacheUtils.getSingleEntry(kind.toString(), key);
        if (!optionalLoadBalancerData.isPresent()) {
            return null;
        }
        CacheData loadBalancerData = optionalLoadBalancerData.get();
        return new ArrayList<LoadBalancerProvider.Details>(this.fromLoadBalancerCacheData(Collections.singletonList(loadBalancerData)));
    }

    public Set<KubernetesV2LoadBalancer> getApplicationLoadBalancers(String application) {
        List<CacheData> loadBalancerData = this.kindMap.translateSpinnakerKind(KubernetesSpinnakerKindMap.SpinnakerKind.LOAD_BALANCERS).stream().map(kind -> this.cacheUtils.getTransitiveRelationship(Keys.LogicalKind.APPLICATIONS.toString(), Collections.singletonList(Keys.application(application)), kind.toString())).flatMap(Collection::stream).collect(Collectors.toList());
        return this.fromLoadBalancerCacheData(loadBalancerData);
    }

    private Set<KubernetesV2LoadBalancer> fromLoadBalancerCacheData(List<CacheData> loadBalancerData) {
        List<CacheData> serverGroupData = this.kindMap.translateSpinnakerKind(KubernetesSpinnakerKindMap.SpinnakerKind.SERVER_GROUPS).stream().map(kind -> this.cacheUtils.loadRelationshipsFromCache(loadBalancerData, kind.toString())).flatMap(Collection::stream).collect(Collectors.toList());
        List<CacheData> instanceData = this.kindMap.translateSpinnakerKind(KubernetesSpinnakerKindMap.SpinnakerKind.INSTANCES).stream().map(kind -> this.cacheUtils.loadRelationshipsFromCache(serverGroupData, kind.toString())).flatMap(Collection::stream).collect(Collectors.toList());
        Map<String, List<CacheData>> loadBalancerToServerGroups = this.cacheUtils.mapByRelationship(serverGroupData, KubernetesSpinnakerKindMap.SpinnakerKind.LOAD_BALANCERS);
        Map<String, List<CacheData>> serverGroupToInstances = this.cacheUtils.mapByRelationship(instanceData, KubernetesSpinnakerKindMap.SpinnakerKind.SERVER_GROUPS);
        return loadBalancerData.stream().map(cd -> KubernetesV2LoadBalancer.fromCacheData(cd, loadBalancerToServerGroups.getOrDefault(cd.getId(), new ArrayList()), serverGroupToInstances)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private class Item
    implements LoadBalancerProvider.Item {
        String name;
        List<LoadBalancerProvider.ByAccount> byAccounts = new ArrayList<LoadBalancerProvider.ByAccount>();

        public String getName() {
            return this.name;
        }

        public List<LoadBalancerProvider.ByAccount> getByAccounts() {
            return this.byAccounts;
        }

        public Item setName(String name) {
            this.name = name;
            return this;
        }

        public Item setByAccounts(List<LoadBalancerProvider.ByAccount> byAccounts) {
            this.byAccounts = byAccounts;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Item)) {
                return false;
            }
            Item other = (Item)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            List<LoadBalancerProvider.ByAccount> this$byAccounts = this.getByAccounts();
            List<LoadBalancerProvider.ByAccount> other$byAccounts = other.getByAccounts();
            return !(this$byAccounts == null ? other$byAccounts != null : !((Object)this$byAccounts).equals(other$byAccounts));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Item;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            List<LoadBalancerProvider.ByAccount> $byAccounts = this.getByAccounts();
            result = result * 59 + ($byAccounts == null ? 43 : ((Object)$byAccounts).hashCode());
            return result;
        }

        public String toString() {
            return "KubernetesV2LoadBalancerProvider.Item(name=" + this.getName() + ", byAccounts=" + this.getByAccounts() + ")";
        }
    }
}

