/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.description;

import com.netflix.spinnaker.clouddriver.kubernetes.v2.artifact.KubernetesUnversionedArtifactConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.artifact.KubernetesVersionedArtifactConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesResourceProperties;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesSpinnakerKindMap;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.deployer.KubernetesHandler;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class KubernetesResourcePropertyRegistry {
    private ConcurrentHashMap<KubernetesKind, KubernetesResourceProperties> map = new ConcurrentHashMap();

    @Autowired
    public KubernetesResourcePropertyRegistry(List<KubernetesHandler> handlers, KubernetesSpinnakerKindMap kindMap, KubernetesVersionedArtifactConverter versionedArtifactConverter, KubernetesUnversionedArtifactConverter unversionedArtifactConverter) {
        for (KubernetesHandler handler : handlers) {
            KubernetesResourceProperties properties = KubernetesResourceProperties.builder().handler(handler).versioned(handler.versioned()).versionedConverter(versionedArtifactConverter).unversionedConverter(unversionedArtifactConverter).build();
            kindMap.addRelationship(handler.spinnakerKind(), handler.kind());
            this.put(handler.kind(), properties);
        }
    }

    public KubernetesResourceProperties get(KubernetesKind kind) {
        return this.map.get(kind);
    }

    public void put(KubernetesKind kind, KubernetesResourceProperties properties) {
        this.map.put(kind, properties);
    }

    public Collection<KubernetesResourceProperties> values() {
        return this.map.values();
    }
}

