/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.op.deployer;

import com.netflix.spinnaker.clouddriver.kubernetes.v2.artifact.ArtifactReplacer;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.artifact.ArtifactTypes;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.Keys;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent.KubernetesCacheDataConverter;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent.KubernetesStatefulSetCachingAgent;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent.KubernetesV2CachingAgent;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.view.provider.KubernetesCacheUtils;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesSpinnakerKindMap;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesKind;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.manifest.KubernetesManifest;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.deployer.CanDelete;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.deployer.CanPauseRollout;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.deployer.CanResize;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.deployer.CanResumeRollout;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.deployer.CanScale;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.deployer.CanUndoRollout;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.deployer.KubernetesHandler;
import com.netflix.spinnaker.clouddriver.model.Manifest;
import io.kubernetes.client.models.V1beta2StatefulSet;
import io.kubernetes.client.models.V1beta2StatefulSetStatus;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class KubernetesStatefulSetHandler
extends KubernetesHandler
implements CanResize,
CanDelete,
CanScale,
CanPauseRollout,
CanResumeRollout,
CanUndoRollout {
    public KubernetesStatefulSetHandler() {
        this.registerReplacer(ArtifactReplacer.Replacer.builder().replacePath("$.spec.template.spec.containers.[?( @.image == \"{%name%}\" )].image").findPath("$.spec.template.spec.containers.*.image").type(ArtifactTypes.DOCKER_IMAGE).build());
    }

    @Override
    public KubernetesKind kind() {
        return KubernetesKind.STATEFUL_SET;
    }

    @Override
    public boolean versioned() {
        return false;
    }

    @Override
    public KubernetesSpinnakerKindMap.SpinnakerKind spinnakerKind() {
        return KubernetesSpinnakerKindMap.SpinnakerKind.SERVER_GROUPS;
    }

    @Override
    public Class<? extends KubernetesV2CachingAgent> cachingAgentClass() {
        return KubernetesStatefulSetCachingAgent.class;
    }

    @Override
    public Manifest.Status status(KubernetesManifest manifest) {
        V1beta2StatefulSet v1beta2StatefulSet = KubernetesCacheDataConverter.getResource(manifest, V1beta2StatefulSet.class);
        return this.status(v1beta2StatefulSet);
    }

    public static String serviceName(KubernetesManifest manifest) {
        Map spec = (Map)manifest.get("spec");
        return (String)spec.get("serviceName");
    }

    @Override
    public Map<String, Object> hydrateSearchResult(Keys.InfrastructureCacheKey key, KubernetesCacheUtils cacheUtils) {
        Map<String, Object> result = super.hydrateSearchResult(key, cacheUtils);
        result.put("serverGroup", result.get("name"));
        return result;
    }

    private Manifest.Status status(V1beta2StatefulSet statefulSet) {
        Manifest.Status result = new Manifest.Status();
        V1beta2StatefulSetStatus status = statefulSet.getStatus();
        if (status == null) {
            result.unstable("No status reported yet").unavailable("No availability reported");
            return result;
        }
        int desiredReplicas = statefulSet.getSpec().getReplicas();
        Integer existing = status.getReplicas();
        if (existing == null || desiredReplicas > existing) {
            return result.unstable("Waiting for at least the desired replica count to be met");
        }
        if (!status.getCurrentRevision().equals(status.getUpdateRevision())) {
            return result.unstable("Waiting for the updated revision to match the current revision");
        }
        existing = status.getCurrentReplicas();
        if (existing == null || desiredReplicas > existing) {
            return result.unstable("Waiting for all updated replicas to be scheduled");
        }
        existing = status.getReadyReplicas();
        if (existing == null || desiredReplicas > existing) {
            return result.unstable("Waiting for all updated replicas to be ready");
        }
        return result;
    }
}

