/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.KubernetesCachingAgent;
import com.netflix.spinnaker.clouddriver.kubernetes.caching.KubernetesCachingAgentDispatcher;
import com.netflix.spinnaker.clouddriver.kubernetes.security.KubernetesNamedAccountCredentials;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.caching.agent.KubernetesV2CachingAgent;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesResourceProperties;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.description.KubernetesResourcePropertyRegistry;
import com.netflix.spinnaker.clouddriver.kubernetes.v2.op.deployer.KubernetesHandler;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class KubernetesV2CachingAgentDispatcher
implements KubernetesCachingAgentDispatcher {
    private static final Logger log = LoggerFactory.getLogger(KubernetesV2CachingAgentDispatcher.class);
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private Registry registry;
    @Autowired
    private KubernetesResourcePropertyRegistry propertyRegistry;

    @Override
    public List<KubernetesCachingAgent> buildAllCachingAgents(KubernetesNamedAccountCredentials credentials) {
        return IntStream.range(0, credentials.getCacheThreads()).boxed().map(i -> this.propertyRegistry.values().stream().map(KubernetesResourceProperties::getHandler).map(KubernetesHandler::cachingAgentClass).filter(Objects::nonNull).map(c -> {
            try {
                return c.getDeclaredConstructor(KubernetesNamedAccountCredentials.class, ObjectMapper.class, Registry.class, Integer.TYPE, Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                log.warn("Missing canonical constructor", (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).map(c -> {
            try {
                return (KubernetesV2CachingAgent)c.newInstance(credentials, this.objectMapper, this.registry, i, credentials.getCacheThreads());
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                log.warn("Can't invoke caching agent constructor", (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull)).flatMap(s -> s).collect(Collectors.toList());
    }
}

