/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.TypeState;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.ValueNode;

public class FilterTypeFlow
extends TypeFlow<ValueNode> {
    private final AnalysisType type;
    private final boolean isExact;
    private final boolean isAssignable;
    private final boolean includeNull;

    public FilterTypeFlow(ValueNode node, AnalysisType type, boolean isAssignable, boolean includeNull) {
        this(node, type, false, isAssignable, includeNull);
    }

    public FilterTypeFlow(ValueNode node, AnalysisType type, boolean isExact, boolean isAssignable, boolean includeNull) {
        super(node, null);
        this.type = type;
        this.isExact = isExact;
        this.isAssignable = isAssignable;
        this.includeNull = includeNull;
    }

    public FilterTypeFlow(MethodFlowsGraph methodFlows, FilterTypeFlow original) {
        super(original, methodFlows);
        this.type = original.type;
        this.isExact = original.isExact;
        this.isAssignable = original.isAssignable;
        this.includeNull = original.includeNull;
    }

    @Override
    public TypeFlow<ValueNode> copy(BigBang bb, MethodFlowsGraph methodFlows) {
        return new FilterTypeFlow(methodFlows, this);
    }

    @Override
    public TypeState filter(BigBang bb, TypeState update) {
        if (update.isUnknown()) {
            AnalysisMethod method = (AnalysisMethod)((ValueNode)this.source).graph().method();
            bb.reportIllegalUnknownUse(method, (Node)this.source, "Illegal: Filter of UnknownTypeState objects.");
            return TypeState.forEmpty();
        }
        TypeState result = this.isExact ? (this.isAssignable ? TypeState.forIntersection(bb, update, TypeState.forExactType(bb, this.type, this.includeNull)) : TypeState.forSubtraction(bb, update, TypeState.forExactType(bb, this.type, !this.includeNull))) : (this.isAssignable ? TypeState.forIntersection(bb, update, this.type.getTypeFlow(bb, this.includeNull).getState()) : TypeState.forSubtraction(bb, update, this.type.getTypeFlow(bb, !this.includeNull).getState()));
        return result;
    }

    @Override
    public boolean addState(BigBang bb, TypeState add) {
        assert (this.isClone());
        return super.addState(bb, add);
    }

    public AnalysisType getType() {
        return this.type;
    }

    public boolean isExact() {
        return this.isExact;
    }

    public boolean isAssignable() {
        return this.isAssignable;
    }

    public boolean includeNull() {
        return this.includeNull;
    }

    @Override
    public String toString() {
        return "FilterTypeFlow<" + this.type + ", isAssignable: " + this.isAssignable + ", includeNull: " + this.includeNull + ">";
    }
}

