/**
 * Project Name:qiho-center-api File Name:ItemDto.java Package Name:com.qiho.center.api.dto Date:2017年5月17日下午7:34:14
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package com.qiho.center.api.dto;

import java.util.Map;

import com.google.common.collect.Maps;

/**
 * ClassName:ItemDto <br/>
 * 商品基本信息DTO <br/>
 * Date: 2017年5月17日 下午7:34:14 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
public class ItemDto extends ItemSimpleDto {

    /**
     */
    private static final long   serialVersionUID = -7072767221775176567L;

    /** 商品库存 */
    private Long                stock;
    /** 有效库存 */
    private Long                enableStock;

    /** 商品最小价格， 单位：分 */
    private Integer             minPrice;

    /** 最小原价，单位：分 */
    private Integer             minOriginalPrice;

    /** 是否已推荐 */
    private Boolean             isRecommend;

    /** 扩展信息 */
    private Map<String, String> extParam;

    /**
     * stock.
     *
     * @return the stock
     */
    public Long getStock() {
        return stock;
    }

    /**
     * stock.
     *
     * @param stock the stock to set
     */
    public void setStock(Long stock) {
        this.stock = stock;
    }


    public Long getEnableStock() {
        return enableStock;
    }

    public void setEnableStock(Long enableStock) {
        this.enableStock = enableStock;
    }

    /**
     * 添加扩展信息
     *
     * @author zhanglihui
     * @param key
     * @param value
     */
    public void addExtParamValue(String key, String value) {
        if (extParam == null) {
            extParam = Maps.newHashMap();
        }
        extParam.put(key, value);
    }

    /**
     * 根据key获取扩展信息
     *
     * @author zhanglihui
     * @param key
     * @return 扩展信息
     */
    public String getExtParamValue(String key) {
        if (extParam == null) {
            return null;
        }
        return extParam.get(key);
    }

    /**
     * extParam.
     *
     * @param extParam the extParam to set
     */
    public void setExtParam(Map<String, String> extParam) {
        this.extParam = extParam;
    }

    /**
     * extParam.
     *
     * @return the extParam
     */
    public Map<String, String> getExtParam() {
        return extParam;
    }

    /**
     * minPrice.
     *
     * @return the minPrice
     */
    public Integer getMinPrice() {
        return minPrice;
    }

    /**
     * minPrice.
     *
     * @param minPrice the minPrice to set
     */
    public void setMinPrice(Integer minPrice) {
        this.minPrice = minPrice;
    }

    /**
     * minOriginalPrice.
     *
     * @return the minOriginalPrice
     */
    public Integer getMinOriginalPrice() {
        return minOriginalPrice;
    }

    /**
     * minOriginalPrice.
     *
     * @param minOriginalPrice the minOriginalPrice to set
     */
    public void setMinOriginalPrice(Integer minOriginalPrice) {
        this.minOriginalPrice = minOriginalPrice;
    }

    /**
     * isRecommend.
     *
     * @return the isRecommend
     */
    public Boolean getIsRecommend() {
        return isRecommend;
    }

    /**
     * isRecommend.
     *
     * @param isRecommend the isRecommend to set
     */
    public void setIsRecommend(Boolean isRecommend) {
        this.isRecommend = isRecommend;
    }

}
