/**
 * Project Name:qiho-center-api File Name:OrderItemDto.java Package Name:com.qiho.center.api.dto Date:2017年6月2日下午6:43:33
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package com.qiho.center.api.dto;

import com.qiho.center.api.enums.DeliveryEnum;

/**
 * ClassName:OrderItemDto <br/>
 * 订单商品详情. <br/>
 * Date: 2017年6月2日 下午6:43:33 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
public class OrderItemDto extends BaseDto {

    /**
     */
    private static final long serialVersionUID = 9157305315118569345L;

    /** 订单ID */
    private String            orderId;

    /** 商品ID */
    private Long              itemId;

    /** 商品名称 */
    private String            itemName;

    /** 商品简称 */
    private String            itemShortName;

    /** 商品货号 */
    private String            itemNo;

    /** skuId */
    private Long              skuId;

    /** sku名称 */
    private String            skuName;

    /** 商品编码 */
    private String            skuNo;

    /** 售价，单位：分 */
    private Integer           sellingPrice;

    /** 原价，单位：分 */
    private Integer           originalPrice;

    /** 商品数量 */
    private Integer           quantity;

    /** 发货方式，{@link DeliveryEnum} */
    private String            delivery;

    /**
     * orderId.
     *
     * @return the orderId
     */
    public String getOrderId() {
        return orderId;
    }

    /**
     * orderId.
     *
     * @param orderId the orderId to set
     */
    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    /**
     * itemId.
     *
     * @return the itemId
     */
    public Long getItemId() {
        return itemId;
    }

    /**
     * itemId.
     *
     * @param itemId the itemId to set
     */
    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    /**
     * itemName.
     *
     * @return the itemName
     */
    public String getItemName() {
        return itemName;
    }

    /**
     * itemName.
     *
     * @param itemName the itemName to set
     */
    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    /**
     * itemShortName.
     *
     * @return the itemShortName
     */
    public String getItemShortName() {
        return itemShortName;
    }

    /**
     * itemShortName.
     *
     * @param itemShortName the itemShortName to set
     */
    public void setItemShortName(String itemShortName) {
        this.itemShortName = itemShortName;
    }

    /**
     * itemNo.
     *
     * @return the itemNo
     */
    public String getItemNo() {
        return itemNo;
    }

    /**
     * itemNo.
     *
     * @param itemNo the itemNo to set
     */
    public void setItemNo(String itemNo) {
        this.itemNo = itemNo;
    }

    /**
     * skuId.
     *
     * @return the skuId
     */
    public Long getSkuId() {
        return skuId;
    }

    /**
     * skuId.
     *
     * @param skuId the skuId to set
     */
    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    /**
     * skuName.
     *
     * @return the skuName
     */
    public String getSkuName() {
        return skuName;
    }

    /**
     * skuName.
     *
     * @param skuName the skuName to set
     */
    public void setSkuName(String skuName) {
        this.skuName = skuName;
    }

    /**
     * skuNo.
     *
     * @return the skuNo
     */
    public String getSkuNo() {
        return skuNo;
    }

    /**
     * skuNo.
     *
     * @param skuNo the skuNo to set
     */
    public void setSkuNo(String skuNo) {
        this.skuNo = skuNo;
    }

    /**
     * sellingPrice.
     *
     * @return the sellingPrice
     */
    public Integer getSellingPrice() {
        return sellingPrice;
    }

    /**
     * sellingPrice.
     *
     * @param sellingPrice the sellingPrice to set
     */
    public void setSellingPrice(Integer sellingPrice) {
        this.sellingPrice = sellingPrice;
    }

    /**
     * originalPrice.
     *
     * @return the originalPrice
     */
    public Integer getOriginalPrice() {
        return originalPrice;
    }

    /**
     * originalPrice.
     *
     * @param originalPrice the originalPrice to set
     */
    public void setOriginalPrice(Integer originalPrice) {
        this.originalPrice = originalPrice;
    }

    /**
     * quantity.
     *
     * @return the quantity
     */
    public Integer getQuantity() {
        return quantity;
    }

    /**
     * quantity.
     *
     * @param quantity the quantity to set
     */
    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    /**
     * delivery.
     *
     * @return the delivery
     */
    public String getDelivery() {
        return delivery;
    }

    /**
     * delivery.
     *
     * @param delivery the delivery to set
     */
    public void setDelivery(String delivery) {
        this.delivery = delivery;
    }

}
