package com.qiho.center.api.enums;

import java.util.Map;

import com.google.common.collect.Maps;

/**
 * Created by liuyao on 2017/5/22.
 */
public enum ExpressCompanyEnum {

    YTO("YTO","圆通速递");

    private String code;
    private String name;

    ExpressCompanyEnum(String code,String name){
        this.code = code;
        this.name = name;
    }

    private static Map<String,ExpressCompanyEnum> enumMap = Maps.newHashMap();
    private static Map<String,ExpressCompanyEnum> nameEnumMap = Maps.newHashMap();
    static {
        for(ExpressCompanyEnum it:ExpressCompanyEnum.values()){
            enumMap.put(it.code,it);
            nameEnumMap.put(it.name,it);
        }
    }

    public static ExpressCompanyEnum getExpressCompanyByCode(String code){
        return enumMap.get(code);
    }
    
    /**
     * 
     * getNameByCode:根据编码获取公司名称. <br/>
     * 
     * @param code
     * @return DatabaseSchema
     */
    public static ExpressCompanyEnum getByCode(String code) {
        return enumMap.get(code);
    }
    
    /**
     * 
     * getByCode:根据公司名称获取编码. <br/>
     * 
     * @param code
     * @return DatabaseSchema
     */
    public static ExpressCompanyEnum getByName(String name) {
        return nameEnumMap.get(name);
    }
    
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
