package com.qiho.center.api.enums;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * Created by liuyao on 2017/6/3.
 */
public enum PayTypeEnum {

    COD("COD","圆通COD");
    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    private static Map<String,PayTypeEnum> enumMap = Maps.newHashMap();
    static {
        for(PayTypeEnum it:PayTypeEnum.values()){
            enumMap.put(it.code,it);
        }
    }

    public static PayTypeEnum getEnumByCode(String code){
        return enumMap.get(code);
    }


    private PayTypeEnum(String code,String desc){
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
