package com.qiho.center.api.remoteservice;

import java.util.Set;

import com.qiho.center.api.dto.ExpressBlackListDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.enums.ExpressCompanyEnum;
import com.qiho.center.api.params.ExpressBlackListPageParams;

import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by liuyao on 2017/5/22.
 */
public interface RemoteExpressBlackListService {

    /**
     * 获取快递黑名单
     * @param params
     * @return 分页数据
     */
    public DubboResult<PagenationDto<ExpressBlackListDto>> findExpressBlackPage(ExpressBlackListPageParams params);

    /**
     *
     * @param expressCompany
     * @param addressCode
     * @return
     */
    public DubboResult<Long> findOneBlack(ExpressCompanyEnum expressCompany,String addressCode);

    /**
     * 删除单个配送黑名单
     * @param id
     * @return
     */
    public DubboResult<Boolean> deleteBlackList(Long id);

    /**
     * 批量添加配送黑名单
     * @param expressCompany
     * @param addressCodes
     * @return
     */
    public DubboResult<Integer> batchAddExpressBlackList(ExpressCompanyEnum expressCompany,Set<String> addressCodes);
}
