/**
 * Project Name:qiho-center-api
 * File Name:RemoteItemService.java
 * Package Name:com.qiho.center.api.remoteservice
 * Date:2017年5月18日上午9:37:17
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package com.qiho.center.api.remoteservice;

import java.util.List;

import cn.com.duiba.wolf.dubbo.DubboResult;

import com.qiho.center.api.dto.ItemDetailDto;
import com.qiho.center.api.dto.ItemDto;
import com.qiho.center.api.dto.ItemSimpleDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.enums.ItemStatusEnum;

/**
 * ClassName:RemoteItemService <br/>
 * 类目管理dubbo服务 <br/>
 * Date:     2017年5月18日 上午9:37:17 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface RemoteItemService {
    /**
     * 分页查询商品列表
     * @author zhanglihui
     * @param queryItem
     * @param pageNum
     * @param pageSize
     * @return PagenationDto<ItemDto>
     */
    DubboResult<PagenationDto<ItemDto>> queryItemPage(ItemDto queryItem, Integer pageNum, Integer pageSize);
    
    /**
     * 新建一个商品
     *
     * @author zhanglihui
     * @param itemDetail
     * @return 商品ID
     */
    DubboResult<Long> createItem(ItemDetailDto itemDetail);
    
    
    /**
     * 更新商品信息
     * @author zhanglihui
     * @param itemDetail
     * @return DubboResult
     */
    DubboResult<Void> updateItem(ItemDetailDto itemDetail);
    
    /**
     * 根据商品ID查询商品详情
     * @author zhanglihui
     * @param itemId
     * @return ItemDetailDto
     */
    DubboResult<ItemDetailDto> queryItemDetail(Long itemId);
    
    /**
     * 批量下架商品
     *
     * @author zhanglihui
     * @param itemIds 商品ID列表
     * @param status  更新后的商品状态，{@link ItemStatusEnum}
     * @return DubboResult
     */
    DubboResult<Void> updateStatus(List<Long> itemIds, String status);
    
    
    /**
     * 批量删除商品
     * @author zhanglihui
     * @param itemIds 商品ID列表
     * @return DubboResult
     */
    DubboResult<Void> deleteBatch(List<Long> itemIds);
    
    /**
     * 查询商品基本信息
     * @author zhanglihui
     * @param itemId 商品ID
     * @return ItemSimpleDto
     */
    DubboResult<ItemSimpleDto> queryItemSimpleDto(Long itemId);
}

