/**
 * Project Name:qiho-center-api
 * File Name:RemoteLogisticsOrderService.java
 * Package Name:com.qiho.center.api.remoteLogisticsOrderService
 * Date:2017年6月3日 下午3:37:46 
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package com.qiho.center.api.remoteservice;

import java.util.List;

import cn.com.duiba.wolf.dubbo.DubboResult;

import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.logistics.LogisticsOrderDto;
import com.qiho.center.api.dto.logistics.LogisticsProcessDto;
import com.qiho.center.api.dto.logistics.QueryLogisticsOrderDto;

/**
 * 
 * ClassName: RemoteLogisticsOrderService <br/>
 * Function: 物流子订单管理dubbo服务. <br/>
 * date: 2017年6月3日 下午3:37:46 <br/>
 *
 * @author chencheng
 * @version
 */
public interface RemoteLogisticsOrderService {
    
    /**
     * 
     * 分页查询物流子订单
     *
     * @author chencheng
     * @param queryItem
     * @param pageNum
     * @param pageSize
     * @return
     */
    DubboResult<PagenationDto<LogisticsOrderDto>> queryLogisticsOrderPage(QueryLogisticsOrderDto queryItem,
                                                                          Integer pageNum, Integer pageSize);
   
    /**
     * 
     * 更新订单状态
     *
     * @author chencheng
     * @param logisticsId
     * @param orderStatus
     * @return
     */
    DubboResult<Integer> updateBylogisticsId(String logisticsIds, String orderStatus);
    
    /**
     * 
     * 更新物流子订单物流状态
     *
     * @author chencheng
     * @param logisticsOrderDto
     * @return
     */
    DubboResult<Integer> updateLogisticsOrderStatus(LogisticsOrderDto logisticsOrderDto);
    
    /**
     * 根据订单ID查询物流信息
     *
     * @author zhanglihui
     * @param orderId
     * @return List<LogisticsOrderDto>
     */
    DubboResult<List<LogisticsOrderDto>> findByOrderId(String orderId);
    
    /**
     * 查询圆通快递运单走件流程
     *
     * @author zhanglihui
     * @param orderId
     * @return List<LogisticsOrderDto>
     */
    DubboResult<List<LogisticsProcessDto>> queryYTOLogisticsProcessByPostId(String postId);
    
    /**
     * 批量签收物流订单
     * @param progressKey 审核进度查询Key,用于向缓存中写进度,调用batchAuditOrderInit获取
     * @param paramList
     * @return 提交的审核条数
     */
    DubboResult<Integer> batchSignOrder(String progressKey,List<LogisticsOrderDto> paramList);
    
    /**
     * 手动触发查询ERP系统物流发货信息查询
     * @return 是否执行
     */
    DubboResult<Boolean> ManualErpLogisticsSyncQueryJob();
    
    /**
     * 通过查询走件信息同步物流状态
     *
     * @author zhanglihui
     * @param logisticsOrderStatus 
     * @return DubboResult
     */
    DubboResult<Void> syncLogisticsStatus(String logisticsOrderStatus);
}

