/**
 * Project Name:qiho-center-api
 * File Name:RemoteChannelInfoService.java
 * Package Name:com.qiho.center.api.remoteservice.order
 * Date:2017年6月6日下午12:05:23
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package com.qiho.center.api.remoteservice.order;

import com.qiho.center.api.dto.ChannelInfoDto;

import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteChannelInfoService <br/>
 * 订单渠道信息Dubbo服务. <br/>
 * Date:     2017年6月6日 下午12:05:23 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface RemoteChannelInfoService {

    /**
     * 根据订单ID查询渠道信息
     *
     * @author zhanglihui
     * @param orderId
     * @return ChannelInfoDto
     */
    DubboResult<ChannelInfoDto> findByOrderId(String orderId);
}

