/**
 * Project Name:qiho-center-api
 * File Name:RemoteErpOrderService.java
 * Package Name:com.qiho.center.api.remoteservice.order
 * Date:2017年6月6日上午11:33:12
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package com.qiho.center.api.remoteservice.order;

import java.util.List;

import cn.com.duiba.wolf.dubbo.DubboResult;

import com.qiho.center.api.dto.ErpOrderDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.params.BatchResolveErpDeliverParams;
import com.qiho.center.api.params.ErpOrderPageParams;
import com.qiho.center.api.params.OrderAuditParams;
import com.qiho.center.api.params.ResolveDeliverParams;

/**
 * ClassName:RemoteErpOrderService <br/>
 * ERP子订单服务. <br/>
 * Date:     2017年6月6日 上午11:33:12 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface RemoteErpOrderService {

    /**
     * 根据订单ID查询ERP订单列表
     * @author zhanglihui
     * @param orderId
     * @return List<ErpOrderDto>
     */
    DubboResult<List<ErpOrderDto>> findByOrderId(String orderId);

    /**
     * 查询ERP子订单的分页
     * @param params
     * @return
     */
    DubboResult<PagenationDto<ErpOrderDto>> findErpOrderPage(ErpOrderPageParams params);

    /**
     * 取消发货
     * @param erpId
     * @return
     */
    DubboResult<Boolean> cancelDeliver(String erpId);

    /**
     * 确认发货
     * @param params
     * @return
     */
    DubboResult<Boolean> resolveDeliver(ResolveDeliverParams params);

    /**
     * 批量处理
     * @param progressKey
     * @param paramList
     * @return
     */
    DubboResult<Integer> batchResolveErpDeliver(String progressKey,List<BatchResolveErpDeliverParams> paramList);
}

