/**
 * Project Name:qiho-center-api
 * File Name:RemoteFundOrderService.java
 * Package Name:com.qiho.center.api.remoteservice.order
 * Date:2017年6月6日下午12:57:04
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package com.qiho.center.api.remoteservice.order;

import java.util.List;

import cn.com.duiba.wolf.dubbo.DubboResult;

import com.qiho.center.api.dto.FundOrderDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.params.FundPageParam;

/**
 * ClassName:RemoteFundOrderService <br/>
 * 资金流水Dubbo服务. <br/>
 * Date:     2017年6月6日 下午12:57:04 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface RemoteFundOrderService {

    /**
     * 根据订单ID查询资金流水
     *
     * @author zhanglihui
     * @param orderId
     * @return List<FundOrderDto>
     */
    DubboResult<List<FundOrderDto>> findByOrderId(String orderId);
    
    /**
     * 分页查询资金流水
     * @author zhanglihui
     * @param param
     * @return PagenationDto<FundOrderDto>
     */
    DubboResult<PagenationDto<FundOrderDto>> queryFundPage(FundPageParam param);
}

