/**
 * Project Name:qiho-center-api
 * File Name:RemoteOrderService.java
 * Package Name:com.qiho.center.api.remoteservice
 * Date:2017年6月2日下午7:03:02
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package com.qiho.center.api.remoteservice.order;

import java.util.List;

import cn.com.duiba.wolf.dubbo.DubboResult;

import com.qiho.center.api.dto.ChannelInfoDto;
import com.qiho.center.api.dto.OrderDto;
import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.params.OrderAuditParams;
import com.qiho.center.api.params.OrderConsumerParam;
import com.qiho.center.api.params.OrderItemParam;
import com.qiho.center.api.params.OrderPageParams;

/**
 * ClassName:RemoteOrderService <br/>
 * 订单服务. <br/>
 * Date:     2017年6月2日 下午7:03:02 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface RemoteOrderService {

    /**
     * 提交订单,同步返回订单ID，并同时异步更新订单快照信息，扫描订单防作弊规则
     * @author zhanglihui
     * @param order       订单内容
     * @param channelInfo 订单渠道信息
     * @return 订单ID
     */
    DubboResult<String> submit(OrderDto order, ChannelInfoDto channelInfo);
    
    /**
     * 发送短信验证码
     * @author zhanglihui
     * @param mobile 发送的手机号码
     * @param smsCode 发送的短信验证码
     * @return DubboResult
     */
    DubboResult<Boolean> sendSmsCode(String mobile, String smsCode);

    /**
     * 查询全部订单的分页
     * @param params
     * @return
     */
    DubboResult<PagenationDto<OrderSnapshotDto>> findAllPage(OrderPageParams params);

    /**
     * 获取订单分页总条数
     * @param params
     * @return
     */
    DubboResult<Integer> findAllPageCount(OrderPageParams params);

    /**
     * 导出订单的分页查询
     * @param params
     * @return
     */
    DubboResult<List<OrderSnapshotDto>> exportAllOrderPage(OrderPageParams params);

    /**
     * 查询导出订单的总数(覆盖索引),值会远远大于真实值
     * @param params
     * @return
     */
    DubboResult<Integer> exportOrderPageCount(OrderPageParams params);

    /**
     * 批量审核订单
     * @param progressKey 审核进度查询Key,用于向缓存中写进度,调用batchAuditOrderInit获取
     * @param paramList
     * @return 提交的审核条数
     */
    DubboResult<Integer> batchAuditOrder(String progressKey,List<OrderAuditParams> paramList);

    /**
     * 审核订单
     * @param params
     * @return
     */
    DubboResult<Boolean> auditOrder(OrderAuditParams params);

    /**
     * 根据订单ID查询订单信息
     * @author zhanglihui
     * @param orderId
     * @return OrderDto
     */
    DubboResult<OrderDto> findByOrderId(String orderId);
    
    /**
     * 
     * 查询订单快照
     * @author zhanglihui
     * @param orderId
     * @return OrderSnapshotDto
     */
    DubboResult<OrderSnapshotDto> findOrderSnapshot(String orderId);
    
    /**
     * 更新订单商品详情
     *
     * @author zhanglihui
     * @param param
     * @return DubboResult
     */
    DubboResult<Void> updateOrderItem(OrderItemParam param);
    
    /**
     * 更新订单买家信息
     *
     * @author zhanglihui
     * @param param
     * @return DubboResult
     */
    DubboResult<Void> updateOrderConsumer(OrderConsumerParam param);
    
    /**
     * 更新订单状态
     *
     * @param orderId
     * @param orderStatus
     * @return DubboResult
     */
    DubboResult<Void> updateOrderStatus(String orderId, String orderStatus);
}

