/**
 * Project Name:qiho-center-api File Name:ChannelInfoDto.java Package Name:com.qiho.center.api.dto
 * Date:2017年6月3日下午6:05:36 Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package com.qiho.center.api.dto;

import org.apache.commons.lang.StringUtils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;

/**
 * ClassName:ChannelInfoDto <br/>
 * 订单渠道信息. <br/>
 * Date: 2017年6月3日 下午6:05:36 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
public class ChannelInfoDto extends BaseDto {

    /**
     */
    private static final long  serialVersionUID  = -7400321635426217260L;

    /** 订单ID */
    private String             orderId;

    /** 结算渠道ID */
    private String             channelId;

    /** 统计渠道ID */
    private String             countChannelId;

    /** 下单页URL */
    private String             url;

    /** 客户端IP地址 */
    private String             ip;

    /** 用户代理，包含用户操作系统及浏览器版本等信息 */
    private String             userAgent;

    /** tuiaId */
    private String             tuiaId;

    /** 客户端JS生成的唯一ID，用户查询设备指纹ID */
    private String             tokenId;

    /**
     * 设备指纹ID，json格式保存多个供应商的设备指纹ID
     */
    private JSONObject         deviceId;

    /** 皮肤ID */
    private Long               skinId;

	/**
     *  下单来源appId
     */
    private Long             appId;

    /**
     * 奇货系统生成的用户识别ID
     */
    public static final String TOKEN_ID          = "tokenId";

    /**
     * 同盾设备指纹ID
     */
    public static final String TONGDUN_DEVICE_ID = "tongdunId";

    /**
     * 猛犸设备指纹ID
     */
    public static final String MAXENT_DEVICE_ID  = "maxentId";

    /**
     * orderId.
     *
     * @return the orderId
     */
    public String getOrderId() {
        return orderId;
    }

    /**
     * orderId.
     *
     * @param orderId the orderId to set
     */
    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    /**
     * tuiaId.
     *
     * @return the tuiaId
     */
    public String getTuiaId() {
        return tuiaId;
    }

    /**
     * tuiaId.
     *
     * @param tuiaId the tuiaId to set
     */
    public void setTuiaId(String tuiaId) {
        this.tuiaId = tuiaId;
    }

    /**
     * channelId.
     *
     * @return the channelId
     */
    public String getChannelId() {
        return channelId;
    }

    /**
     * channelId.
     *
     * @param channelId the channelId to set
     */
    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    /**
     * countChannelId.
     *
     * @return the countChannelId
     */
    public String getCountChannelId() {
        return countChannelId;
    }

    /**
     * countChannelId.
     *
     * @param countChannelId the countChannelId to set
     */
    public void setCountChannelId(String countChannelId) {
        this.countChannelId = countChannelId;
    }

    /**
     * url.
     *
     * @return the url
     */
    public String getUrl() {
        return url;
    }

    /**
     * url.
     *
     * @param url the url to set
     */
    public void setUrl(String url) {
        this.url = url;
    }

    /**
     * ip.
     *
     * @return the ip
     */
    public String getIp() {
        return ip;
    }

    /**
     * ip.
     *
     * @param ip the ip to set
     */
    public void setIp(String ip) {
        this.ip = ip;
    }

    /**
     * userAgent.
     *
     * @return the userAgent
     */
    public String getUserAgent() {
        return userAgent;
    }

    /**
     * userAgent.
     *
     * @param userAgent the userAgent to set
     */
    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    /**
     * tokenId.
     *
     * @return the tokenId
     */
    public String getTokenId() {
        return tokenId;
    }

    /**
     * tokenId.
     *
     * @param tokenId the tokenId to set
     */
    public void setTokenId(String tokenId) {
        this.tokenId = tokenId;
    }

    /**
     * deviceId.
     *
     * @param deviceId the deviceId to set
     */
    public void setDeviceId(String deviceId) {
        if (StringUtils.isNotBlank(deviceId)) {
            this.deviceId = JSON.parseObject(deviceId);
        }
    }

    /**
     * deviceId.
     *
     * @return the deviceId
     */
    public String getDeviceId() {
        if (deviceId == null) {
            return null;
        }
        return deviceId.toJSONString();
    }

    /**
     * 获取同盾设备指纹ID
     *
     * @author zhanglihui
     * @return tongdunId
     */
    public String getTongdunId() {
        if (deviceId == null) {
            return null;
        }
        return deviceId.getString(TONGDUN_DEVICE_ID);
    }

    /**
     * 获取猛犸设备指纹ID
     *
     * @author zhanglihui
     * @return maxentId
     */
    public String getMaxentId() {
        if (deviceId == null) {
            return null;
        }
        return deviceId.getString(MAXENT_DEVICE_ID);
    }

    /**
     * 添加设备指纹ID
     *
     * @author zhanglihui
     * @param key 设备指纹供应商key
     * @param value 设备指纹ID
     */
    public void addDeviceId(String key, String value) {
        if (this.deviceId == null) {
            this.deviceId = new JSONObject();
        }
        deviceId.put(key, value);
    }

    public Long getSkinId() {
        return skinId;
    }

    public void setSkinId(Long skinId) {
        this.skinId = skinId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }
}
